/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.views.helpers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.EventDispatcher;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.SWTEventDispatcher;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.ScalableFigure;
import org.eclipse.draw2d.ToolTipHelper;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef4.zest.core.viewers.AbstractStructuredGraphViewer;
import org.eclipse.gef4.zest.core.viewers.GraphViewer;
import org.eclipse.gef4.zest.core.viewers.internal.GraphModelEntityRelationshipFactory;
import org.eclipse.gef4.zest.core.viewers.internal.IStylingGraphModelFactory;
import org.eclipse.gef4.zest.core.widgets.GraphConnection;
import org.eclipse.gef4.zest.core.widgets.IDecorationFigure;
import org.eclipse.gef4.zest.core.widgets.IDecorationLayer;
import org.eclipse.gef4.zest.core.widgets.custom.CGraphNode;
import org.eclipse.gef4.zest.core.widgets.zooming.ZoomManager;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.handlers.IHandlerService;
import org.netxms.base.GeoLocation;
import org.netxms.client.maps.elements.NetworkMapDCIContainer;
import org.netxms.client.maps.elements.NetworkMapDCIImage;
import org.netxms.client.maps.elements.NetworkMapDecoration;
import org.netxms.client.maps.elements.NetworkMapElement;
import org.netxms.client.maps.elements.NetworkMapTextBox;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.networkmaps.Activator;
import org.netxms.ui.eclipse.networkmaps.Messages;
import org.netxms.ui.eclipse.networkmaps.views.helpers.DecorationLayerAbstractFigure;
import org.netxms.ui.eclipse.networkmaps.views.helpers.MapContentProvider;
import org.netxms.ui.eclipse.networkmaps.views.helpers.MapLabelProvider;
import org.netxms.ui.eclipse.networkmaps.views.helpers.ObjectFigure;
import org.netxms.ui.eclipse.networkmaps.views.helpers.ZoomAction;
import org.netxms.ui.eclipse.osm.tools.MapLoader;
import org.netxms.ui.eclipse.osm.tools.Tile;
import org.netxms.ui.eclipse.osm.tools.TileSet;
import org.netxms.ui.eclipse.tools.ColorCache;

public class ExtendedGraphViewer
extends GraphViewer {
    private static final double[] zoomLevels = new double[]{0.1, 0.25, 0.5, 0.75, 1.0, 1.25, 1.5, 1.75, 2.0, 2.5, 3.0, 4.0};
    private ExtendedSWTEventDispatcher eventDispatcher;
    private BackgroundFigure backgroundFigure;
    private Image backgroundImage = null;
    private GeoLocation backgroundLocation = null;
    private int backgroundZoom;
    private MapLoader mapLoader;
    private Layer backgroundLayer;
    private Layer decorationLayer;
    private Layer indicatorLayer;
    private Layer controlLayer;
    private int crosshairX;
    private int crosshairY;
    private Crosshair crosshairFigure;
    private GridFigure gridFigure;
    private int gridSize = 96;
    private boolean snapToGrid = false;
    private MouseListener snapToGridListener;
    private List<NetworkMapElement> mapDecorations;
    private Set<NetworkMapElement> selectedDecorations = new HashSet<NetworkMapElement>();
    private Map<Long, DecorationLayerAbstractFigure> decorationFigures = new HashMap<Long, DecorationLayerAbstractFigure>();
    private ColorCache colors;
    private Image iconBack;
    private OverlayButton backButton = null;
    private boolean draggingEnabled = true;
    private boolean centeredBackground = false;

    public ExtendedGraphViewer(Composite composite, int style) {
        super(composite, style);
        this.eventDispatcher = new ExtendedSWTEventDispatcher();
        this.graph.getLightweightSystem().setEventDispatcher((EventDispatcher)this.eventDispatcher);
        this.colors = new ColorCache((Control)this.graph);
        ScalableFigure rootLayer = this.graph.getRootLayer();
        this.iconBack = Activator.getImageDescriptor("icons/back.png").createImage();
        this.mapLoader = new MapLoader(composite.getDisplay());
        this.graph.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ExtendedGraphViewer.this.mapLoader.dispose();
                ExtendedGraphViewer.this.iconBack.dispose();
            }
        });
        this.backgroundLayer = new FreeformLayer();
        rootLayer.add((IFigure)this.backgroundLayer, null, 0);
        this.backgroundFigure = new BackgroundFigure();
        this.backgroundFigure.setSize(10, 10);
        this.backgroundLayer.add((IFigure)this.backgroundFigure);
        this.decorationLayer = new FreeformLayer();
        this.decorationLayer.setOpaque(false);
        rootLayer.add((IFigure)this.decorationLayer, null, 1);
        this.indicatorLayer = new FreeformLayer();
        rootLayer.add((IFigure)this.indicatorLayer, null, 2);
        this.controlLayer = new FreeformLayer();
        rootLayer.add((IFigure)this.controlLayer, null);
        this.getZoomManager().setZoomLevels(zoomLevels);
        final Runnable timer = new Runnable(){

            @Override
            public void run() {
                if (ExtendedGraphViewer.this.graph.isDisposed()) {
                    return;
                }
                if (ExtendedGraphViewer.this.backgroundLocation != null) {
                    ExtendedGraphViewer.this.reloadMapBackground();
                }
                if (ExtendedGraphViewer.this.gridFigure != null) {
                    ExtendedGraphViewer.this.gridFigure.setSize(ExtendedGraphViewer.this.graph.getZestRootLayer().getSize());
                }
            }
        };
        this.graph.getZestRootLayer().addFigureListener(new FigureListener(){

            public void figureMoved(IFigure source) {
                ExtendedGraphViewer.this.graph.getDisplay().timerExec(-1, timer);
                ExtendedGraphViewer.this.graph.getDisplay().timerExec(1000, timer);
            }
        });
        this.graph.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (ExtendedGraphViewer.this.backgroundImage != null && ExtendedGraphViewer.this.centeredBackground) {
                    ExtendedGraphViewer.this.centerBackgroundImage();
                }
            }
        });
        this.graph.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedGraphViewer.this.clearDecorationSelection(false);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        MouseListener backgroundMouseListener = new MouseListener(){

            public void mouseReleased(MouseEvent me) {
            }

            public void mousePressed(MouseEvent me) {
                Point mousePoint = new Point(me.x, me.y);
                ExtendedGraphViewer.this.graph.getRootLayer().translateToRelative((Translatable)mousePoint);
                IFigure figureUnderMouse = ExtendedGraphViewer.this.graph.getFigureAt(mousePoint.x, mousePoint.y);
                if (figureUnderMouse == null || !(figureUnderMouse instanceof DecorationLayerAbstractFigure)) {
                    if ((me.getState() & SWT.MOD1) == 0) {
                        ExtendedGraphViewer.this.clearDecorationSelection(true);
                    }
                    return;
                }
            }

            public void mouseDoubleClicked(MouseEvent me) {
            }
        };
        this.graph.getLightweightSystem().getRootFigure().addMouseListener(backgroundMouseListener);
        this.graph.getZestRootLayer().addMouseListener(backgroundMouseListener);
        this.snapToGridListener = new MouseListener(){

            public void mouseReleased(MouseEvent me) {
                if (ExtendedGraphViewer.this.snapToGrid && ExtendedGraphViewer.this.graph.getRootLayer().findFigureAt(me.x, me.y) != null) {
                    ExtendedGraphViewer.this.alignToGrid(true);
                }
            }

            public void mousePressed(MouseEvent me) {
                for (Object o : ExtendedGraphViewer.this.graph.getNodes()) {
                    if (!(o instanceof CGraphNode)) continue;
                    CGraphNode n = (CGraphNode)o;
                    ((ObjectFigure)n.getFigure()).readMovedState();
                }
            }

            public void mouseDoubleClicked(MouseEvent me) {
            }
        };
    }

    public void updateDecorationFigure(NetworkMapElement d) {
        DecorationLayerAbstractFigure figure = this.decorationFigures.get(d.getId());
        if (figure != null) {
            figure.refresh();
        }
    }

    protected void inputChanged(Object input, Object oldInput) {
        boolean dynamicLayoutEnabled = this.graph.isDynamicLayoutEnabled();
        this.graph.setDynamicLayout(false);
        super.inputChanged(input, oldInput);
        this.graph.setDynamicLayout(dynamicLayoutEnabled);
        this.decorationLayer.removeAll();
        this.decorationFigures.clear();
        if (this.getContentProvider() instanceof MapContentProvider && this.getLabelProvider() instanceof MapLabelProvider) {
            this.mapDecorations = ((MapContentProvider)this.getContentProvider()).getDecorations(input);
            if (this.mapDecorations != null) {
                MapLabelProvider lp = (MapLabelProvider)this.getLabelProvider();
                for (NetworkMapElement d : this.mapDecorations) {
                    DecorationLayerAbstractFigure figure = (DecorationLayerAbstractFigure)lp.getFigure(d);
                    figure.setLocation(new Point(d.getX(), d.getY()));
                    this.decorationLayer.add((IFigure)figure);
                    this.decorationFigures.put(d.getId(), figure);
                }
            }
        }
    }

    protected void setDecorationSelection(NetworkMapElement d, boolean addToExisting) {
        if (!addToExisting) {
            this.clearDecorationSelection(false);
            this.graph.setSelection(null);
        }
        this.selectedDecorations.add(d);
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        this.fireSelectionChanged(event);
        this.firePostSelectionChanged(event);
    }

    private void clearDecorationSelection(boolean sendEvent) {
        if (this.selectedDecorations.size() == 0) {
            return;
        }
        for (NetworkMapElement d : this.selectedDecorations) {
            DecorationLayerAbstractFigure f = this.decorationFigures.get(d.getId());
            if (f == null) continue;
            f.setSelected(false);
        }
        this.selectedDecorations.clear();
        if (sendEvent) {
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
            this.fireSelectionChanged(event);
            this.firePostSelectionChanged(event);
        }
    }

    protected void setSelectionToWidget(List l, boolean reveal) {
        this.selectedDecorations.clear();
        if (l != null) {
            this.clearDecorationSelection(false);
            for (Object o : l) {
                if (!(o instanceof NetworkMapDecoration) && !(o instanceof NetworkMapDCIContainer) && !(o instanceof NetworkMapDCIImage) && !(o instanceof NetworkMapTextBox)) continue;
                this.selectedDecorations.add((NetworkMapElement)o);
                DecorationLayerAbstractFigure f = this.decorationFigures.get(((NetworkMapElement)o).getId());
                if (f == null) continue;
                f.setSelected(true);
            }
        }
        super.setSelectionToWidget(l, reveal);
    }

    protected List getSelectionFromWidget() {
        List selection = super.getSelectionFromWidget();
        for (NetworkMapElement d : this.selectedDecorations) {
            selection.add(d);
        }
        return selection;
    }

    public void setBackgroundColor(RGB color) {
        Color c = this.colors.create(color);
        this.graph.setBackground(c);
        this.graph.getLightweightSystem().getRootFigure().setBackgroundColor(c);
    }

    public void setBackgroundImage(Image image, boolean centered) {
        this.backgroundImage = image;
        if (image != null) {
            org.eclipse.swt.graphics.Rectangle r = image.getBounds();
            this.backgroundFigure.setSize(r.width, r.height);
            this.centeredBackground = centered;
            if (centered) {
                this.centerBackgroundImage();
            } else {
                this.backgroundFigure.setLocation(new Point(0, 0));
            }
        } else {
            this.backgroundFigure.setSize(10, 10);
            this.centeredBackground = false;
        }
        this.backgroundLocation = null;
        this.graph.redraw();
    }

    private void centerBackgroundImage() {
        int backgroundLayerWidth = this.backgroundLayer.getSize().width();
        int backgroundLayerHeight = this.backgroundLayer.getSize().height();
        int x = backgroundLayerWidth / 2 - this.backgroundImage.getBounds().width / 2;
        int y = backgroundLayerHeight / 2 - this.backgroundImage.getBounds().height / 2;
        this.backgroundFigure.setLocation(new Point(x, y));
    }

    public void setBackgroundImage(GeoLocation location, int zoom) {
        if (this.backgroundLocation != null && this.backgroundImage != null) {
            this.backgroundImage.dispose();
        }
        this.backgroundImage = null;
        this.centeredBackground = false;
        this.backgroundLocation = location;
        this.backgroundZoom = zoom;
        this.backgroundFigure.setSize(10, 10);
        this.backgroundFigure.setLocation(new Point(0, 0));
        this.graph.redraw();
        this.reloadMapBackground();
    }

    private void reloadMapBackground() {
        org.eclipse.swt.graphics.Rectangle controlSize = this.graph.getClientArea();
        Rectangle rootLayerSize = this.graph.getZestRootLayer().getClientArea();
        final org.eclipse.swt.graphics.Point mapSize = new org.eclipse.swt.graphics.Point(Math.min(controlSize.width, rootLayerSize.width), Math.max(controlSize.height, rootLayerSize.height));
        Messages.get();
        ConsoleJob job = new ConsoleJob(Messages.ExtendedGraphViewer_DownloadTilesJob, null, "org.netxms.ui.eclipse.networkmaps", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final TileSet tiles = ExtendedGraphViewer.this.mapLoader.getAllTiles(mapSize, ExtendedGraphViewer.this.backgroundLocation, 1, ExtendedGraphViewer.this.backgroundZoom, false);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).ExtendedGraphViewer.this.backgroundLocation == null || ExtendedGraphViewer.this.graph.isDisposed()) {
                            return;
                        }
                        (this).ExtendedGraphViewer.this.backgroundFigure.setSize(mapSize.x, mapSize.y);
                        ExtendedGraphViewer.this.drawTiles(tiles);
                        ExtendedGraphViewer.this.graph.redraw();
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.ExtendedGraphViewer_DownloadTilesError;
            }
        };
        job.setUser(false);
        job.start();
    }

    private void drawTiles(TileSet tileSet) {
        if (this.backgroundLocation != null && this.backgroundImage != null) {
            this.backgroundImage.dispose();
        }
        if (tileSet == null || tileSet.tiles == null || tileSet.tiles.length == 0) {
            this.backgroundImage = null;
            return;
        }
        Tile[][] tiles = tileSet.tiles;
        Dimension size = this.backgroundFigure.getSize();
        this.backgroundImage = new Image((Device)this.graph.getDisplay(), size.width, size.height);
        GC gc = new GC((Drawable)this.backgroundImage);
        int x = tileSet.xOffset;
        int y = tileSet.yOffset;
        int i = 0;
        while (i < tiles.length) {
            int j = 0;
            while (j < tiles[i].length) {
                gc.drawImage(tiles[i][j].getImage(), x, y);
                if ((x += 256) >= size.width) {
                    x = tileSet.xOffset;
                    y += 256;
                }
                ++j;
            }
            ++i;
        }
        gc.dispose();
    }

    protected void internalRefresh(Object element, boolean updateLabels) {
        if (this.getInput() == null) {
            return;
        }
        if (element == this.getInput()) {
            this.getFactory().refreshGraph(this.graph);
        } else {
            this.getFactory().refresh(this.graph, element, updateLabels);
        }
    }

    public void zoomIn() {
        this.getZoomManager().zoomIn();
    }

    public void zoomOut() {
        this.getZoomManager().zoomOut();
    }

    public void zoomFit() {
        this.getZoomManager().setZoom(1.0);
        org.eclipse.swt.graphics.Rectangle visibleArea = this.getGraphControl().getClientArea();
        Rectangle mapArea = this.getGraphControl().getRootLayer().getBounds();
        double dx = (double)visibleArea.width / (double)mapArea.width;
        double dy = (double)visibleArea.height / (double)mapArea.height;
        this.getZoomManager().setZoom(Math.min(dx, dy));
    }

    public void zoomTo(double zoomLevel) {
        this.getZoomManager().setZoom(zoomLevel);
    }

    public double getZoom() {
        return this.getZoomManager().getZoom();
    }

    public Action[] createZoomActions(IHandlerService handlerService) {
        ZoomManager zoomManager = this.getZoomManager();
        Action[] actions = new Action[zoomLevels.length];
        int i = 0;
        while (i < zoomLevels.length) {
            actions[i] = new ZoomAction(zoomLevels[i], zoomManager);
            if (zoomLevels[i] == 1.0) {
                actions[i].setChecked(true);
                actions[i].setId("org.netxms.ui.eclipse.networkmaps.localActions.AbstractMap.Zoom100Pct");
                actions[i].setActionDefinitionId("org.netxms.ui.eclipse.networkmaps.localCommands.AbstractMap.Zoom100Pct");
                handlerService.activateHandler(actions[i].getActionDefinitionId(), (IHandler)new ActionHandler((IAction)actions[i]));
            }
            ++i;
        }
        return actions;
    }

    public void showBackButton(Runnable action) {
        if (this.backButton != null) {
            this.backButton.setAction(action);
        } else {
            this.backButton = new OverlayButton(this.iconBack, action);
            this.controlLayer.add((IFigure)this.backButton);
            this.backButton.setLocation(new Point(10, 10));
        }
    }

    public void hideBackButton() {
        if (this.backButton != null) {
            this.controlLayer.remove((IFigure)this.backButton);
            this.backButton = null;
        }
    }

    public void showCrosshair(int x, int y) {
        if (this.crosshairFigure == null) {
            this.crosshairFigure = new Crosshair();
            this.indicatorLayer.add((IFigure)this.crosshairFigure);
            this.crosshairFigure.setSize(this.graph.getRootLayer().getSize());
        }
        this.crosshairX = x;
        this.crosshairY = y;
        this.crosshairFigure.repaint();
    }

    public void hideCrosshair() {
        if (this.crosshairFigure != null) {
            this.indicatorLayer.remove((IFigure)this.crosshairFigure);
            this.crosshairFigure = null;
        }
    }

    public void showGrid(boolean show) {
        if (show) {
            if (this.gridFigure == null) {
                this.gridFigure = new GridFigure();
                this.backgroundLayer.add((IFigure)this.gridFigure, null, 1);
                this.gridFigure.setSize(this.graph.getZestRootLayer().getSize());
                this.gridFigure.addMouseListener(new MouseListener(){

                    public void mousePressed(MouseEvent me) {
                        ExtendedGraphViewer.this.setSelection(null);
                    }

                    public void mouseReleased(MouseEvent me) {
                    }

                    public void mouseDoubleClicked(MouseEvent me) {
                    }
                });
            }
        } else if (this.gridFigure != null) {
            this.backgroundLayer.remove((IFigure)this.gridFigure);
            this.gridFigure = null;
        }
    }

    public boolean isGridVisible() {
        return this.gridFigure != null;
    }

    public void alignToGrid(boolean movedOnly) {
        for (Object o : this.graph.getNodes()) {
            ObjectFigure f;
            if (!(o instanceof CGraphNode)) continue;
            CGraphNode n = (CGraphNode)o;
            if (movedOnly && (!(f = (ObjectFigure)n.getFigure()).readMovedState() || !f.isElementSelected())) continue;
            Point p = n.getLocation();
            Dimension size = n.getSize();
            int dx = p.x % this.gridSize;
            dx = dx < this.gridSize / 2 ? -dx : this.gridSize - dx;
            int dy = p.y % this.gridSize;
            dy = dy < this.gridSize / 2 ? -dy : this.gridSize - dy;
            n.setLocation((double)(p.x + (dx += (this.gridSize - size.width) / 2)), (double)(p.y + (dy += (this.gridSize - size.height) / 2)));
        }
    }

    public void setSnapToGrid(boolean snap) {
        if (snap == this.snapToGrid) {
            return;
        }
        this.snapToGrid = snap;
        if (snap) {
            this.graph.getZestRootLayer().addMouseListener(this.snapToGridListener);
        } else {
            this.graph.getZestRootLayer().removeMouseListener(this.snapToGridListener);
        }
    }

    public boolean isSnapToGrid() {
        return this.snapToGrid;
    }

    public boolean isDraggingEnabled() {
        return this.draggingEnabled;
    }

    public void setDraggingEnabled(boolean draggingEnabled) {
        this.draggingEnabled = draggingEnabled;
        this.graph.setDraggingEnabled(draggingEnabled);
    }

    void resizeToolTipShell() {
        this.eventDispatcher.resizeToolTipShell();
    }

    protected IStylingGraphModelFactory getFactory() {
        return new GraphModelEntityRelationshipFactory((AbstractStructuredGraphViewer)this){

            public void styleConnection(GraphConnection conn) {
            }
        };
    }

    public Image takeSnapshot() {
        ScalableFigure rootLayer = this.graph.getRootLayer();
        Dimension d = rootLayer.getSize();
        Image image = new Image((Device)this.graph.getDisplay(), d.width, d.height);
        GC gc = new GC((Drawable)image);
        SWTGraphics g = new SWTGraphics(gc);
        rootLayer.paint((Graphics)g);
        g.dispose();
        gc.dispose();
        return image;
    }

    private class BackgroundFigure
    extends Figure
    implements IDecorationLayer {
        private BackgroundFigure() {
        }

        protected void paintFigure(Graphics gc) {
            if (ExtendedGraphViewer.this.backgroundImage != null) {
                gc.drawImage(ExtendedGraphViewer.this.backgroundImage, this.getLocation());
            }
        }
    }

    private class Crosshair
    extends Figure {
        public Crosshair() {
            this.setOpaque(false);
        }

        protected void paintFigure(Graphics gc) {
            gc.setLineStyle(3);
            Dimension size = this.getSize();
            gc.drawLine(0, ExtendedGraphViewer.this.crosshairY, size.width, ExtendedGraphViewer.this.crosshairY);
            gc.drawLine(ExtendedGraphViewer.this.crosshairX, 0, ExtendedGraphViewer.this.crosshairX, size.height);
        }
    }

    private static class ExtendedSWTEventDispatcher
    extends SWTEventDispatcher {
        private ExtendedToolTipHelper toolTipHelper;

        private ExtendedSWTEventDispatcher() {
        }

        protected ToolTipHelper getToolTipHelper() {
            if (this.toolTipHelper == null) {
                this.toolTipHelper = new ExtendedToolTipHelper(this.control);
            }
            return this.toolTipHelper;
        }

        public void resizeToolTipShell() {
            if (this.toolTipHelper.isShowing()) {
                this.toolTipHelper.resizeShell();
            }
        }
    }

    private static class ExtendedToolTipHelper
    extends ToolTipHelper {
        public ExtendedToolTipHelper(Control c) {
            super(c);
        }

        public void resizeShell() {
            Dimension shellSize = this.getLightweightSystem().getRootFigure().getPreferredSize().getExpanded(this.getShellTrimSize());
            this.getShell().setSize(shellSize.width, shellSize.height);
        }
    }

    private class GridFigure
    extends Figure
    implements IDecorationLayer,
    IDecorationFigure {
        public GridFigure() {
            this.setOpaque(false);
        }

        protected void paintFigure(Graphics gc) {
            gc.setLineStyle(3);
            Dimension size = this.getSize();
            int x = ExtendedGraphViewer.this.gridSize;
            while (x < size.width) {
                gc.drawLine(x, 0, x, size.height);
                x += ExtendedGraphViewer.this.gridSize;
            }
            int y = ExtendedGraphViewer.this.gridSize;
            while (y < size.height) {
                gc.drawLine(0, y, size.width, y);
                y += ExtendedGraphViewer.this.gridSize;
            }
        }
    }

    private class OverlayButton
    extends Figure {
        private Image icon;
        private Runnable action;

        public OverlayButton(Image icon, Runnable action) {
            this.icon = icon;
            this.action = action;
            this.addMouseListener(new MouseListener(){

                public void mousePressed(MouseEvent me) {
                    OverlayButton.this.action.run();
                }

                public void mouseReleased(MouseEvent me) {
                }

                public void mouseDoubleClicked(MouseEvent me) {
                }
            });
            this.setSize(this.getPreferredSize());
        }

        public Dimension getPreferredSize(int wHint, int hHint) {
            return new Dimension(this.icon.getImageData().width, this.icon.getImageData().height).expand(6, 6);
        }

        protected void paintFigure(Graphics gc) {
            Point pos = this.getLocation();
            Dimension size = this.getSize();
            gc.setLineWidth(1);
            gc.setForegroundColor(ExtendedGraphViewer.this.colors.create(86, 20, 152));
            gc.setBackgroundColor(gc.getForegroundColor());
            gc.setAlpha(64);
            gc.fillRectangle(pos.x, pos.y, size.width - 1, size.height - 1);
            gc.setAlpha(255);
            gc.drawRectangle(pos.x, pos.y, size.width - 1, size.height - 1);
            gc.drawImage(this.icon, pos.x + 3, pos.y + 3);
        }

        public void setAction(Runnable action) {
            this.action = action;
        }
    }
}

