/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.propertypages;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.datacollection.DataCollectionObject;
import org.netxms.nxmc.base.helpers.StringComparator;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.DataCollectionObjectEditor;
import org.netxms.nxmc.modules.datacollection.dialogs.EditScheduleDialog;
import org.netxms.nxmc.modules.datacollection.propertypages.AbstractDCIPropertyPage;
import org.netxms.nxmc.modules.datacollection.propertypages.helpers.CustomScheduleLabelProvider;
import org.xnap.commons.i18n.I18n;

public class CustomSchedule
extends AbstractDCIPropertyPage {
    private static final I18n i18n = LocalizationHelper.getI18n(CustomSchedule.class);
    private DataCollectionObject dci;
    private HashSet<String> schedules;
    private SortableTableViewer viewer;
    private Button addButton;
    private Button editButton;
    private Button deleteButton;

    public CustomSchedule(DataCollectionObjectEditor editor) {
        super(i18n.tr("Custom Schedule"), editor);
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = (Composite)super.createContents(parent);
        this.dci = this.editor.getObject();
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        String[] columnNames = new String[]{i18n.tr("Schedule"), i18n.tr("Description")};
        int[] columnWidths = new int[]{300, 300};
        this.viewer = new SortableTableViewer(dialogArea, columnNames, columnWidths, 0, 128, 67586);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator((ViewerComparator)new StringComparator());
        this.viewer.setLabelProvider((IBaseLabelProvider)new CustomScheduleLabelProvider());
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.schedules = new HashSet();
        this.schedules.addAll(this.dci.getSchedules());
        this.viewer.setInput((Object)this.schedules.toArray());
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 0;
        this.viewer.getControl().setLayoutData((Object)gridData);
        Composite buttons = new Composite(dialogArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.marginBottom = 0;
        buttonLayout.marginTop = 0;
        buttonLayout.marginLeft = 0;
        buttonLayout.marginRight = 0;
        buttonLayout.spacing = 4;
        buttonLayout.fill = true;
        buttonLayout.pack = false;
        buttons.setLayout((Layout)buttonLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        buttons.setLayoutData((Object)gridData);
        this.addButton = new Button(buttons, 8);
        this.addButton.setText(i18n.tr("&Add..."));
        RowData rd = new RowData();
        rd.width = 90;
        this.addButton.setLayoutData((Object)rd);
        this.addButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.editButton = new Button(buttons, 8);
        this.editButton.setText(i18n.tr("&Edit..."));
        rd = new RowData();
        rd.width = 90;
        this.editButton.setLayoutData((Object)rd);
        this.editButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.deleteButton = new Button(buttons, 8);
        this.deleteButton.setText(i18n.tr("&Delete"));
        rd = new RowData();
        rd.width = 90;
        this.deleteButton.setLayoutData((Object)rd);
        this.deleteButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        return dialogArea;
    }

    private void addSchedule() {
        EditScheduleDialog dlg = new EditScheduleDialog(this.getShell(), "");
        if (dlg.open() == 0) {
            this.schedules.add(dlg.getSchedule());
            this.viewer.setInput((Object)this.schedules.toArray());
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)dlg.getSchedule()));
        }
    }

    private void editSchedule() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        String oldValue = new String((String)selection.getFirstElement());
        EditScheduleDialog dlg = new EditScheduleDialog(this.getShell(), (String)selection.getFirstElement());
        if (dlg.open() == 0) {
            this.schedules.remove(oldValue);
            this.schedules.add(dlg.getSchedule());
            this.viewer.setInput((Object)this.schedules.toArray());
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)dlg.getSchedule()));
        }
    }

    private void deleteSchedules() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            this.schedules.remove(it.next());
        }
        this.viewer.setInput((Object)this.schedules.toArray());
    }

    protected boolean applyChanges(boolean isApply) {
        this.dci.setSchedules((Collection)this.schedules);
        this.editor.modify();
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.schedules.clear();
        this.viewer.setInput((Object)this.schedules.toArray());
    }
}

