/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.views.helpers;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.datacollection.Threshold;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.AbstractViewerFilter;

public class LastValuesFilter
extends ViewerFilter
implements AbstractViewerFilter {
    private NXCSession session = Registry.getSession();
    private String filterString = null;
    private boolean showDisabled = false;
    private boolean showUnsupported = false;
    private boolean showHidden = false;

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        DciValue value = (DciValue)element;
        if (!this.showUnsupported && value.getStatus() == 2) {
            return false;
        }
        if (!this.showDisabled && value.getStatus() == 1) {
            return false;
        }
        if (!this.showHidden && (value.getFlags() & 0x8000) != 0) {
            return false;
        }
        if (this.filterString == null || this.filterString.isEmpty()) {
            return true;
        }
        return value.getDescription().toLowerCase().contains(this.filterString) || this.matchEventName(value);
    }

    private boolean matchEventName(DciValue value) {
        Threshold t = value.getActiveThreshold();
        if (t == null) {
            return false;
        }
        String eventName = this.session.getEventName((long)t.getFireEvent());
        return eventName.toLowerCase().contains(this.filterString);
    }

    public String getFilterString() {
        return this.filterString;
    }

    public void setFilterString(String filterString) {
        this.filterString = filterString.toLowerCase();
    }

    public boolean isShowDisabled() {
        return this.showDisabled;
    }

    public void setShowDisabled(boolean showDisabled) {
        this.showDisabled = showDisabled;
    }

    public boolean isShowUnsupported() {
        return this.showUnsupported;
    }

    public void setShowUnsupported(boolean showUnsupported) {
        this.showUnsupported = showUnsupported;
    }

    public boolean isShowHidden() {
        return this.showHidden;
    }

    public void setShowHidden(boolean showHidden) {
        this.showHidden = showHidden;
    }
}

