/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.widgets;

import org.eclipse.swt.widgets.Composite;
import org.netxms.client.datacollection.DciSummaryTableDescriptor;
import org.netxms.nxmc.base.widgets.AbstractSelector;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.SummaryTablesCache;
import org.netxms.nxmc.modules.datacollection.dialogs.SelectSummaryTableDialog;
import org.xnap.commons.i18n.I18n;

public class SummaryTableSelector
extends AbstractSelector {
    private static final I18n i18n = LocalizationHelper.getI18n(SummaryTableSelector.class);
    private DciSummaryTableDescriptor table = null;

    public SummaryTableSelector(Composite parent, int style, int options) {
        super(parent, style, options);
        this.setText(i18n.tr("<none>"));
    }

    protected void selectionButtonHandler() {
        SelectSummaryTableDialog dlg = new SelectSummaryTableDialog(this.getShell());
        if (dlg.open() == 0) {
            this.table = dlg.getTable();
            if (this.table != null) {
                this.setText(this.table.getTitle());
            } else {
                this.setText(i18n.tr("<none>"));
            }
        }
    }

    protected void clearButtonHandler() {
        this.table = null;
        this.setText(i18n.tr("<none>"));
    }

    public void setTableId(int id) {
        this.table = null;
        for (DciSummaryTableDescriptor t : SummaryTablesCache.getInstance().getTables()) {
            if (t.getId() != id) continue;
            this.table = t;
            break;
        }
        if (this.table != null) {
            this.setText(this.table.getTitle());
        } else {
            this.setText(i18n.tr("<none>"));
        }
    }

    public int getTableId() {
        return this.table != null ? this.table.getId() : 0;
    }
}

