/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.widgets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeColumn;
import org.netxms.client.NXCSession;
import org.netxms.client.Table;
import org.netxms.client.TableRow;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.actions.ExportToCsvAction;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.views.ViewPlacement;
import org.netxms.nxmc.base.widgets.SortableTreeViewer;
import org.netxms.nxmc.base.widgets.helpers.MenuContributionItem;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.dashboards.widgets.helpers.ObjectSelectionProvider;
import org.netxms.nxmc.modules.datacollection.widgets.SummaryTableWidget;
import org.netxms.nxmc.modules.datacollection.widgets.helpers.SummaryTableContentProvider;
import org.netxms.nxmc.modules.datacollection.widgets.helpers.SummaryTableItemComparator;
import org.netxms.nxmc.modules.datacollection.widgets.helpers.SummaryTableItemLabelProvider;
import org.netxms.nxmc.modules.objects.ObjectMenuFactory;
import org.netxms.nxmc.modules.objects.ObjectWrapper;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.tools.ViewRefreshController;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class SummaryTableWidget
extends Composite {
    private final I18n i18n = LocalizationHelper.getI18n(SummaryTableWidget.class);
    private int tableId;
    private long baseObjectId;
    private View view;
    private SortableTreeViewer viewer;
    private SummaryTableItemLabelProvider labelProvider;
    private Action actionExportToCsv;
    private Action actionUseMultipliers;
    private Action actionForcePollAll;
    private Action actionShowObjectDetails;
    private ViewRefreshController refreshController;
    private boolean useMultipliers = true;
    private TreeColumn currentColumn = null;
    private ObjectSelectionProvider objectSelectionProvider;
    private int showLineCount = 0;
    private List<String> sortingColumnList = null;

    public SummaryTableWidget(Composite parent, int style, View view, int tableId, long baseObjectId) {
        super(parent, style);
        this.view = view;
        this.tableId = tableId;
        this.baseObjectId = baseObjectId;
        this.setLayout((Layout)new FillLayout());
        this.viewer = new SortableTreeViewer((Composite)this, 65538);
        this.viewer.setContentProvider((IContentProvider)new SummaryTableContentProvider());
        this.labelProvider = new SummaryTableItemLabelProvider();
        this.labelProvider.setUseMultipliers(this.useMultipliers);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.objectSelectionProvider = new ObjectSelectionProvider((ISelectionProvider)this.viewer);
        this.createActions();
        this.createContextMenu();
        this.refreshController = new ViewRefreshController(view, -1, (Runnable)new /* Unavailable Anonymous Inner Class!! */);
        this.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.getTree().addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void createActions() {
        this.actionExportToCsv = new ExportToCsvAction(this.view, (ColumnViewer)this.viewer, true);
        this.actionUseMultipliers = new /* Unavailable Anonymous Inner Class!! */;
        this.actionUseMultipliers.setChecked(this.useMultipliers);
        this.actionForcePollAll = new /* Unavailable Anonymous Inner Class!! */;
        this.actionShowObjectDetails = new /* Unavailable Anonymous Inner Class!! */;
    }

    private void createContextMenu() {
        7 nodeMenuManager = new /* Unavailable Anonymous Inner Class!! */;
        MenuManager rowMenuManager = new MenuManager(this.view.getBaseId() + ".SummaryTableRowMenu." + this.hashCode());
        rowMenuManager.setRemoveAllWhenShown(true);
        rowMenuManager.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = rowMenuManager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager, MenuManager nodeMenuManager) {
        Menu graphTemplatesMenu;
        manager.add((IAction)this.actionUseMultipliers);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)nodeMenuManager);
        long contextId = this.view instanceof ObjectView ? ((ObjectView)this.view).getObjectId() : 0L;
        Menu toolsMenu = ObjectMenuFactory.createToolsMenu((IStructuredSelection)this.objectSelectionProvider.getStructuredSelection(), (long)contextId, (Menu)((MenuManager)manager).getMenu(), null, (ViewPlacement)new ViewPlacement(this.view));
        if (toolsMenu != null) {
            manager.add((IContributionItem)new Separator());
            manager.add((IContributionItem)new MenuContributionItem(this.i18n.tr("&Tools"), toolsMenu));
        }
        if ((graphTemplatesMenu = ObjectMenuFactory.createGraphTemplatesMenu((IStructuredSelection)this.objectSelectionProvider.getStructuredSelection(), (long)contextId, (Menu)((MenuManager)manager).getMenu(), null, (ViewPlacement)new ViewPlacement(this.view))) != null) {
            manager.add((IContributionItem)new Separator());
            manager.add((IContributionItem)new MenuContributionItem(this.i18n.tr("&Graphs"), graphTemplatesMenu));
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionShowObjectDetails);
        manager.add((IContributionItem)new Separator());
        if (this.currentColumn != null && (Integer)this.currentColumn.getData("ID") > 0) {
            manager.add((IAction)new /* Unavailable Anonymous Inner Class!! */);
        }
        manager.add((IAction)this.actionForcePollAll);
        manager.add((IAction)this.actionExportToCsv);
    }

    public void refresh() {
        this.viewer.setInput(null);
        NXCSession session = Registry.getSession();
        10 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }

    public void update(Table table) {
        if (!this.viewer.isInitialized()) {
            String[] names = table.getColumnDisplayNames();
            int[] widths = new int[names.length];
            Arrays.fill(widths, 100);
            this.viewer.createColumns(names, widths, 0, 128);
            PreferenceStore settings = PreferenceStore.getInstance();
            String key = this.view.getBaseId() + ".SummaryTable." + Integer.toString(this.tableId);
            WidgetHelper.restoreTreeViewerSettings((SortableTreeViewer)this.viewer, (String)key);
            this.useMultipliers = settings.getAsBoolean(key + ".useMultipliers", this.useMultipliers);
            this.labelProvider.setUseMultipliers(this.useMultipliers);
            this.viewer.getControl().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
            this.viewer.setComparator((ViewerComparator)new SummaryTableItemComparator(table));
        }
        this.labelProvider.setColumnDataTypes(table.getColumns());
        if (this.sortingColumnList != null && !this.sortingColumnList.isEmpty()) {
            ArrayList<SortItem> sortItem = new ArrayList<SortItem>();
            for (int i = 0; i < this.sortingColumnList.size(); ++i) {
                boolean isDesc = ((String)this.sortingColumnList.get(i)).charAt(0) == '>';
                int index = table.getColumnIndex(((String)this.sortingColumnList.get(i)).substring(1));
                if (index < 0) continue;
                sortItem.add(new SortItem(this, index, isDesc));
            }
            ArrayList<SortItem> sortItemFin = sortItem;
            table.sort((Comparator)new /* Unavailable Anonymous Inner Class!! */);
            this.viewer.setComparator(null);
        }
        if (this.showLineCount > 0) {
            this.viewer.setInput((Object)table.getFirstRows(this.showLineCount));
        } else {
            this.viewer.setInput((Object)table);
        }
        this.viewer.expandAll();
    }

    public SortableTreeViewer getViewer() {
        return this.viewer;
    }

    public ISelectionProvider getObjectSelectionProvider() {
        return this.objectSelectionProvider;
    }

    public void setAutoRefresh(int interval) {
        this.refreshController.setInterval(interval);
    }

    public boolean areMultipliersUsed() {
        return this.useMultipliers;
    }

    public void setUseMultipliers(boolean value) {
        this.useMultipliers = value;
        this.actionUseMultipliers.setChecked(value);
        if (this.viewer.isInitialized()) {
            this.labelProvider.setUseMultipliers(value);
            this.viewer.refresh();
        }
    }

    public Action getActionUseMultipliers() {
        return this.actionUseMultipliers;
    }

    private void showObjectDetails() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        AbstractObject object = ((ObjectWrapper)selection.getFirstElement()).getObject();
        if (object != null) {
            // empty if block
        }
    }

    private void forcePoll(boolean pollAll) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        ArrayList<PollRequest> requests = new ArrayList<PollRequest>();
        for (Object o : selection.toList()) {
            TableRow r = (TableRow)o;
            long nodeId = r.getObjectId();
            if (pollAll) {
                int count = ((Table)this.viewer.getInput()).getColumnCount();
                for (int i = 1; i < count; ++i) {
                    long dciId = r.get(i).getObjectId();
                    if (dciId == 0L) continue;
                    requests.add(new PollRequest(this, nodeId, dciId));
                }
                continue;
            }
            int index = ((Table)this.viewer.getInput()).getColumnIndex(this.currentColumn.getText());
            long dciId = r.get(index).getObjectId();
            if (dciId == 0L) continue;
            requests.add(new PollRequest(this, nodeId, dciId));
        }
        if (requests.isEmpty()) {
            return;
        }
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public void setShowNumLine(int lineCount) {
        this.showLineCount = lineCount;
    }

    public void setSortColumns(List<String> sortingColumnList) {
        this.sortingColumnList = sortingColumnList;
    }
}

