/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.propertypages.helpers;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.ConditionDciInfo;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.xnap.commons.i18n.I18n;

public class ConditionDciListLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private static final I18n i18n = LocalizationHelper.getI18n(ConditionDciListLabelProvider.class);
    private static final String[] functions = new String[]{"last()", "average(", "deviation(", "diff()", "error(", "sum("};
    private NXCSession session;
    private Map<Long, String> dciNameCache = new HashMap();
    private List<ConditionDciInfo> elementList;

    public ConditionDciListLabelProvider(List<ConditionDciInfo> elementList) {
        this.elementList = elementList;
        this.session = Registry.getSession();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        ConditionDciInfo dci = (ConditionDciInfo)element;
        switch (columnIndex) {
            case 0: {
                return Integer.toString(this.elementList.indexOf(dci) + 1);
            }
            case 1: {
                AbstractObject object = this.session.findObjectById(dci.getNodeId());
                return object != null ? object.getObjectName() : "[" + Long.toString(dci.getNodeId()) + "]";
            }
            case 2: {
                String name = (String)this.dciNameCache.get(dci.getDciId());
                return name != null ? name : i18n.tr("<unresolved>");
            }
            case 3: {
                if (dci.getType() == 2) {
                    return "";
                }
                int f = dci.getFunction();
                StringBuilder text = new StringBuilder(functions[f]);
                if (f != 3 && f != 0) {
                    text.append(dci.getPolls());
                    text.append(')');
                }
                return text.toString();
            }
        }
        return null;
    }

    public void resolveDciNames(Collection<ConditionDciInfo> dciList) {
        new /* Unavailable Anonymous Inner Class!! */.runInForeground();
    }

    public void addCacheEntry(long nodeId, long dciId, String name) {
        this.dciNameCache.put(dciId, name);
    }
}

