/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.netxms.client.SessionListener;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Template;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.ObjectContextMenuManager;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objects.views.helpers.TemplateTargetsComparator;
import org.netxms.nxmc.modules.objects.views.helpers.TemplateTargetsFilter;
import org.netxms.nxmc.modules.objects.views.helpers.TemplateTargetsLabelProvider;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class TemplateTargets
extends ObjectView {
    private static final I18n i18n = LocalizationHelper.getI18n(TemplateTargets.class);
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_NAME = 1;
    public static final int COLUMN_ZONE = 2;
    public static final int COLUMN_PRIMARY_HOST_NAME = 3;
    public static final int COLUMN_DESCRIPTION = 4;
    private SessionListener sessionListener;
    private SortableTableViewer viewer;
    private TemplateTargetsFilter filter;
    private TemplateTargetsLabelProvider labelProvider;

    public TemplateTargets() {
        super("Targets", ResourceManager.getImageDescriptor((String)"icons/object-views/nodes.png"), "Targets", true);
    }

    protected void createContent(Composite parent) {
        String[] names = new String[]{i18n.tr("ID"), i18n.tr("Name"), i18n.tr("Zone"), i18n.tr("Primary host name"), i18n.tr("Description")};
        int[] widths = new int[]{60, 300, 300, 300, 300};
        this.viewer = new SortableTableViewer(parent, names, widths, 1, 128, 65538);
        this.labelProvider = new TemplateTargetsLabelProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator((ViewerComparator)new TemplateTargetsComparator(this.labelProvider));
        this.filter = new TemplateTargetsFilter(this.labelProvider);
        this.setFilterClient((ISelectionProvider)this.viewer, (AbstractViewerFilter)this.filter);
        this.viewer.addFilter((ViewerFilter)this.filter);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (String)"InterfacesView.TableViewer");
        this.viewer.getTable().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createContextMenu();
        this.sessionListener = new /* Unavailable Anonymous Inner Class!! */;
        this.session.addListener(this.sessionListener);
    }

    private void createContextMenu() {
        ObjectContextMenuManager menuMgr = new ObjectContextMenuManager((View)this, (ISelectionProvider)this.viewer, null);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    public void refresh() {
        if (this.getObject() != null) {
            this.viewer.setInput((Object)this.getObject().getChildrenAsArray());
        } else {
            this.viewer.setInput((Object)new AbstractNode[0]);
        }
    }

    protected void onObjectChange(AbstractObject object) {
        if (object != null && this.isActive()) {
            this.refresh();
        }
    }

    public boolean isValidForContext(Object context) {
        return context instanceof Template;
    }

    public void dispose() {
        this.session.removeListener(this.sessionListener);
        super.dispose();
    }
}

