/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objecttools.propertypages;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.NXCSession;
import org.netxms.client.objecttools.ObjectToolDetails;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.propertypages.PropertyPage;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.propertypages.helpers.AccessListComparator;
import org.netxms.nxmc.modules.datacollection.propertypages.helpers.AccessListLabelProvider;
import org.netxms.nxmc.modules.objecttools.propertypages.AccessControl;
import org.netxms.nxmc.modules.users.dialogs.UserSelectionDialog;
import org.xnap.commons.i18n.I18n;

public class AccessControl
extends PropertyPage {
    private static final I18n i18n = LocalizationHelper.getI18n(AccessControl.class);
    private ObjectToolDetails objectTool;
    private Set<AbstractUserObject> acl = new HashSet();
    private TableViewer viewer;
    private Button buttonAdd;
    private Button buttonRemove;
    private NXCSession session;

    public AccessControl(ObjectToolDetails toolDetails) {
        super("Access Control");
        this.noDefaultAndApplyButton();
        this.objectTool = toolDetails;
    }

    protected Control createContents(Composite parent) {
        this.session = Registry.getSession();
        for (Long uid : this.objectTool.getAccessList()) {
            AbstractUserObject o = this.session.findUserDBObjectById(uid.longValue(), null);
            if (o == null) continue;
            this.acl.add(o);
        }
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        Label label = new Label(dialogArea, 0);
        label.setText(i18n.tr("Users allowed to use this tool"));
        this.viewer = new TableViewer(dialogArea, 67586);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new AccessListLabelProvider());
        this.viewer.setComparator((ViewerComparator)new AccessListComparator());
        this.viewer.getTable().setSortDirection(128);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 300;
        this.viewer.getTable().setLayoutData((Object)gd);
        this.viewer.setInput((Object)this.acl.toArray());
        Composite buttons = new Composite(dialogArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttons.setLayout((Layout)buttonLayout);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        gd.verticalIndent = 2;
        buttons.setLayoutData((Object)gd);
        this.buttonAdd = new Button(buttons, 8);
        this.buttonAdd.setText(i18n.tr("Add..."));
        this.buttonAdd.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        RowData rd = new RowData();
        rd.width = 90;
        this.buttonAdd.setLayoutData((Object)rd);
        this.buttonRemove = new Button(buttons, 8);
        this.buttonRemove.setText(i18n.tr("Delete"));
        this.buttonRemove.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        rd = new RowData();
        rd.width = 90;
        this.buttonRemove.setLayoutData((Object)rd);
        this.syncUsersAndRefresh();
        return dialogArea;
    }

    private void syncUsersAndRefresh() {
        if (this.session.isUserDatabaseSynchronized()) {
            return;
        }
        3 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }

    public void addUser() {
        UserSelectionDialog dlg = new UserSelectionDialog(this.getShell(), AbstractUserObject.class);
        if (dlg.open() == 0) {
            for (AbstractUserObject o : dlg.getSelection()) {
                this.acl.add(o);
            }
            this.viewer.setInput((Object)this.acl.toArray());
        }
    }

    public void removeUsers() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        for (Object o : selection.toList()) {
            this.acl.remove(o);
        }
        this.viewer.setInput((Object)this.acl.toArray());
    }

    protected boolean applyChanges(boolean isApply) {
        if (this.isControlCreated()) {
            ArrayList<Long> list = new ArrayList<Long>(this.acl.size());
            for (AbstractUserObject o : this.acl) {
                list.add(o.getId());
            }
            this.objectTool.setAccessList(list);
        }
        return true;
    }
}

