/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.widgets;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.netxms.ui.eclipse.console.dialogs.KeyValuePairEditDialog;
import org.netxms.ui.eclipse.tools.ElementLabelComparator;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;
import org.netxms.ui.eclipse.widgets.helpers.KeyValuePairLabelProvider;

public class KeyValueSetEditor
extends Composite {
    private SortableTableViewer viewer;
    private Button buttonAdd;
    private Button buttonEdit;
    private Button buttonRemove;
    private String label;
    private Map<String, String> content = new HashMap<String, String>();

    public KeyValueSetEditor(Composite parent, int style, String label) {
        super(parent, style);
        this.label = label;
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        String[] setColumnNames = new String[]{label, "Value"};
        int[] setColumnWidths = new int[]{150, 300};
        this.viewer = new SortableTableViewer(this, setColumnNames, setColumnWidths, 0, 128, 67586);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new KeyValuePairLabelProvider());
        this.viewer.setComparator(new ElementLabelComparator((ILabelProvider)this.viewer.getLabelProvider()));
        this.viewer.setInput(this.content.entrySet().toArray());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                int size = KeyValueSetEditor.this.viewer.getStructuredSelection().size();
                KeyValueSetEditor.this.buttonEdit.setEnabled(size == 1);
                KeyValueSetEditor.this.buttonRemove.setEnabled(size > 0);
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                KeyValueSetEditor.this.editEntry();
            }
        });
        GridData gd = new GridData();
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.viewer.getControl().setLayoutData((Object)gd);
        Composite buttons = new Composite((Composite)this, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginLeft = 0;
        buttonLayout.marginRight = 0;
        buttons.setLayout((Layout)buttonLayout);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        buttons.setLayoutData((Object)gd);
        this.buttonAdd = new Button(buttons, 8);
        this.buttonAdd.setText("&Add...");
        this.buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KeyValueSetEditor.this.addEntry();
            }
        });
        RowData rd = new RowData();
        rd.width = 90;
        this.buttonAdd.setLayoutData((Object)rd);
        this.buttonEdit = new Button(buttons, 8);
        this.buttonEdit.setText("&Edit...");
        this.buttonEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KeyValueSetEditor.this.editEntry();
            }
        });
        rd = new RowData();
        rd.width = 90;
        this.buttonEdit.setLayoutData((Object)rd);
        this.buttonEdit.setEnabled(false);
        this.buttonRemove = new Button(buttons, 8);
        this.buttonRemove.setText("&Delete");
        this.buttonRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KeyValueSetEditor.this.deleteEntry();
            }
        });
        rd = new RowData();
        rd.width = 90;
        this.buttonRemove.setLayoutData((Object)rd);
        this.buttonRemove.setEnabled(false);
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.viewer.getControl().setLayoutData((Object)gd);
    }

    private void addEntry() {
        KeyValuePairEditDialog dlg = new KeyValuePairEditDialog(this.getShell(), null, null, true, true, this.label);
        if (dlg.open() == 0) {
            this.content.put(dlg.getAtributeName(), dlg.getAttributeValue());
            this.viewer.setInput(this.content.entrySet().toArray());
        }
    }

    private void editEntry() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        Map.Entry attr = (Map.Entry)selection.getFirstElement();
        KeyValuePairEditDialog dlg = new KeyValuePairEditDialog(this.getShell(), (String)attr.getKey(), (String)attr.getValue(), true, false, this.label);
        if (dlg.open() == 0) {
            this.content.put(dlg.getAtributeName(), dlg.getAttributeValue());
            this.viewer.setInput(this.content.entrySet().toArray());
        }
    }

    private void deleteEntry() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        Iterator it = selection.iterator();
        if (it.hasNext()) {
            while (it.hasNext()) {
                Map.Entry e = (Map.Entry)it.next();
                this.content.remove(e.getKey());
            }
            this.viewer.setInput(this.content.entrySet().toArray());
        }
    }

    public void addAll(Map<String, String> entries) {
        this.content.putAll(entries);
        this.viewer.setInput(entries.entrySet().toArray());
    }

    public void setContent(Map<String, String> entries) {
        this.content = entries;
    }

    public Map<String, String> getContent() {
        return this.content;
    }
}

