/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.agentmanager.views;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.imageio.ImageIO;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.ImageTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.Table;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.agentmanager.Messages;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.PngTransfer;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class ScreenshotView
extends ViewPart
implements IPartListener {
    public static final String ID = "org.netxms.ui.eclipse.agentmanager.views.ScreenshotView";
    private NXCSession session;
    private long nodeId;
    private String userSession;
    private String userName;
    private Image image;
    private String errorMessage;
    private String imageInfo;
    private ScrolledComposite scroller;
    private Canvas canvas;
    private byte[] byteImage;
    private Action actionRefresh;
    private Action actionAutoRefresh;
    private Action actionSave;
    private Action actionCopyToClipboard;
    private boolean autoRefresh;
    private long lastRequestTime;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = ConsoleSharedData.getSession();
        String[] params = site.getSecondaryId().split("&");
        this.nodeId = Long.parseLong(params[0]);
        if (params.length > 1) {
            this.userSession = params[1];
            this.userName = params.length > 2 ? params[2] : params[1];
        }
        Messages.get();
        this.setPartName(String.format(Messages.ScreenshotView_PartTitle, this.session.getObjectName(this.nodeId)));
        this.autoRefresh = false;
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.scroller = new ScrolledComposite(parent, 768);
        this.canvas = new Canvas((Composite)this.scroller, 0);
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GC gc = e.gc;
                if (ScreenshotView.this.image != null) {
                    gc.drawImage(ScreenshotView.this.image, 0, 0);
                    gc.drawText(ScreenshotView.this.imageInfo, 10, ScreenshotView.this.image.getImageData().height + 10);
                } else if (ScreenshotView.this.errorMessage != null) {
                    gc.setForeground(ScreenshotView.this.canvas.getDisplay().getSystemColor(4));
                    gc.setFont(JFaceResources.getBannerFont());
                    gc.drawText(ScreenshotView.this.errorMessage, 10, 10, true);
                }
            }
        });
        this.scroller.setContent((Control)this.canvas);
        this.scroller.setExpandVertical(true);
        this.scroller.setExpandHorizontal(true);
        WidgetHelper.setScrollBarIncrement((Scrollable)this.scroller, (int)512, (int)20);
        WidgetHelper.setScrollBarIncrement((Scrollable)this.scroller, (int)256, (int)20);
        this.scroller.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                ScreenshotView.this.updateScrollerSize();
            }
        });
        this.getSite().getPage().addPartListener((IPartListener)this);
        this.activateContext();
        this.createActions();
        this.contributeToActionBars();
        this.refresh();
    }

    private void updateScrollerSize() {
        if (this.image != null) {
            ImageData d = this.image.getImageData();
            Point pt = WidgetHelper.getTextExtent((Control)this.canvas, (String)this.imageInfo);
            this.scroller.setMinSize(new Point(Math.max(d.width, pt.x + 20), d.height + pt.y + 15));
        } else if (this.errorMessage != null) {
            Point pt = WidgetHelper.getTextExtent((Control)this.canvas, (String)this.errorMessage);
            this.scroller.setMinSize(new Point(pt.x + 20, pt.y + 20));
        } else {
            this.scroller.setMinSize(new Point(0, 0));
        }
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext("org.netxms.ui.eclipse.agentmanager.context.ScreenshotView");
        }
    }

    public void refresh() {
        Messages.get();
        ConsoleJob job = new ConsoleJob(Messages.ScreenshotView_JobTitle, (IWorkbenchPart)this, "org.netxms.ui.eclipse.agentmanager"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                try {
                    Table sessions;
                    if (ScreenshotView.this.userSession == null && (sessions = ScreenshotView.this.session.queryAgentTable(ScreenshotView.this.nodeId, "Agent.SessionAgents")) != null && sessions.getRowCount() > 0) {
                        int colIndexName = sessions.getColumnIndex("SESSION_NAME");
                        int colIndexUser = sessions.getColumnIndex("USER_NAME");
                        int i = 0;
                        while (i < sessions.getRowCount()) {
                            String n = sessions.getCellValue(i, colIndexName);
                            if ("Console".equalsIgnoreCase(n)) {
                                ScreenshotView.this.userSession = n;
                                ScreenshotView.this.userName = sessions.getCellValue(i, colIndexUser);
                                break;
                            }
                            ++i;
                        }
                        if (ScreenshotView.this.userSession == null) {
                            ScreenshotView.this.userSession = sessions.getCellValue(0, colIndexName);
                            ScreenshotView.this.userName = sessions.getCellValue(0, colIndexUser);
                        }
                    }
                    if (ScreenshotView.this.userSession == null) {
                        this.runInUIThread(new Runnable(){

                            @Override
                            public void run() {
                                if ((this).ScreenshotView.this.canvas.isDisposed()) {
                                    return;
                                }
                                if ((this).ScreenshotView.this.image != null) {
                                    (this).ScreenshotView.this.image.dispose();
                                }
                                (this).ScreenshotView.this.image = null;
                                ScreenshotView screenshotView = ScreenshotView.this;
                                Messages.get();
                                screenshotView.errorMessage = Messages.ScreenshotView_ErrorNoActiveSessions;
                                (this).ScreenshotView.this.canvas.redraw();
                                (this).ScreenshotView.this.actionCopyToClipboard.setEnabled(false);
                                (this).ScreenshotView.this.actionSave.setEnabled(false);
                                ScreenshotView.this.updateScrollerSize();
                            }
                        });
                        return;
                    }
                    ScreenshotView.this.lastRequestTime = System.currentTimeMillis();
                    ScreenshotView.this.byteImage = ScreenshotView.this.session.takeScreenshot(ScreenshotView.this.nodeId, ScreenshotView.this.userSession);
                    final ImageData data = new ImageData((InputStream)new ByteArrayInputStream(ScreenshotView.this.byteImage));
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            if ((this).ScreenshotView.this.canvas.isDisposed()) {
                                return;
                            }
                            if ((this).ScreenshotView.this.image != null) {
                                (this).ScreenshotView.this.image.dispose();
                            }
                            (this).ScreenshotView.this.image = new Image((Device)this.getDisplay(), data);
                            (this).ScreenshotView.this.imageInfo = String.valueOf((this).ScreenshotView.this.userName) + "@" + (this).ScreenshotView.this.userSession;
                            (this).ScreenshotView.this.errorMessage = null;
                            (this).ScreenshotView.this.canvas.redraw();
                            (this).ScreenshotView.this.actionCopyToClipboard.setEnabled(true);
                            (this).ScreenshotView.this.actionSave.setEnabled(true);
                            ScreenshotView.this.updateScrollerSize();
                        }
                    });
                }
                catch (Exception e) {
                    ScreenshotView.this.byteImage = null;
                    final String emsg = e.getLocalizedMessage();
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            String string;
                            if ((this).ScreenshotView.this.canvas.isDisposed()) {
                                return;
                            }
                            if ((this).ScreenshotView.this.image != null) {
                                (this).ScreenshotView.this.image.dispose();
                            }
                            (this).ScreenshotView.this.image = null;
                            ScreenshotView screenshotView = ScreenshotView.this;
                            if (emsg != null) {
                                Messages.get();
                                string = String.format(Messages.ScreenshotView_ErrorWithMsg, emsg);
                            } else {
                                Messages.get();
                                string = Messages.ScreenshotView_ErrorWithoutMsg;
                            }
                            screenshotView.errorMessage = string;
                            (this).ScreenshotView.this.canvas.redraw();
                            (this).ScreenshotView.this.actionCopyToClipboard.setEnabled(false);
                            (this).ScreenshotView.this.actionSave.setEnabled(false);
                            ScreenshotView.this.updateScrollerSize();
                        }
                    });
                }
                if (ScreenshotView.this.autoRefresh) {
                    long diff = System.currentTimeMillis() - ScreenshotView.this.lastRequestTime;
                    if (diff < 250L) {
                        Thread.sleep(250L - diff);
                    }
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            if ((this).ScreenshotView.this.autoRefresh && !(this).ScreenshotView.this.canvas.isDisposed() && ScreenshotView.this.getSite().getPage().isPartVisible((IWorkbenchPart)ScreenshotView.this)) {
                                ScreenshotView.this.refresh();
                            }
                        }
                    });
                }
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.ScreenshotView_JobError;
            }
        };
        job.setUser(false);
        job.start();
    }

    private void createActions() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                ScreenshotView.this.refresh();
            }
        };
        this.actionAutoRefresh = new Action("Auto refresh", 2){

            public void run() {
                ScreenshotView.this.autoRefresh = ScreenshotView.this.actionAutoRefresh.isChecked();
                if (ScreenshotView.this.autoRefresh) {
                    ScreenshotView.this.refresh();
                }
            }
        };
        this.actionAutoRefresh.setChecked(this.autoRefresh);
        Messages.get();
        this.actionCopyToClipboard = new Action(Messages.ScreenshotView_CopyToClipboard, SharedIcons.COPY){

            public void run() {
                if (ScreenshotView.this.image == null) {
                    return;
                }
                PngTransfer imageTransfer = Platform.getOS().equals("linux") ? PngTransfer.getInstance() : ImageTransfer.getInstance();
                Clipboard clipboard = new Clipboard(ScreenshotView.this.canvas.getDisplay());
                clipboard.setContents(new Object[]{ScreenshotView.this.image.getImageData()}, new Transfer[]{imageTransfer});
            }
        };
        this.actionCopyToClipboard.setActionDefinitionId("org.netxms.ui.eclipse.agentmanager.commands.copy_screenshot");
        handlerService.activateHandler(this.actionCopyToClipboard.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionCopyToClipboard));
        this.actionCopyToClipboard.setEnabled(false);
        Messages.get();
        this.actionSave = new Action(Messages.ScreenshotView_Save, SharedIcons.SAVE){

            public void run() {
                ScreenshotView.this.saveImage();
            }
        };
        this.actionSave.setActionDefinitionId("org.netxms.ui.eclipse.agentmanager.commands.save_screenshot");
        handlerService.activateHandler(this.actionSave.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionSave));
        this.actionSave.setEnabled(false);
    }

    private void saveImage() {
        if (this.byteImage == null) {
            return;
        }
        FileDialog fd = new FileDialog(this.getSite().getShell(), 8192);
        Messages.get();
        fd.setText(Messages.ScreenshotView_SaveScreenshot);
        fd.setFilterExtensions(new String[]{"*.png", "*.*"});
        String[] stringArray = new String[2];
        Messages.get();
        stringArray[0] = Messages.ScreenshotView_PngFiles;
        Messages.get();
        stringArray[1] = Messages.ScreenshotView_AllFiles;
        fd.setFilterNames(stringArray);
        fd.setFileName(String.valueOf(this.session.getObjectName(this.nodeId)) + "-screenshot-" + new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date()) + ".png");
        String name = fd.open();
        if (name == null) {
            return;
        }
        File outputFile = new File(name);
        try {
            outputFile.createNewFile();
        }
        catch (IOException e) {
            Shell shell = this.getViewSite().getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.ScreenshotView_Error, (String)String.format(Messages.ScreenshotView_CannotCreateFile, name, e.getLocalizedMessage()));
        }
        try {
            BufferedImage bi = ImageIO.read(new ByteArrayInputStream(this.byteImage));
            ImageIO.write((RenderedImage)bi, "png", outputFile);
        }
        catch (IOException e) {
            Shell shell = this.getViewSite().getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.ScreenshotView_Error, (String)String.format(Messages.ScreenshotView_CannotSaveImage, name, e.getLocalizedMessage()));
        }
    }

    public void setFocus() {
        this.canvas.setFocus();
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionSave);
        manager.add((IAction)this.actionCopyToClipboard);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
        manager.add((IAction)this.actionAutoRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionSave);
        manager.add((IAction)this.actionCopyToClipboard);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener)this);
        if (this.image != null) {
            this.image.dispose();
        }
        super.dispose();
    }

    public void partActivated(IWorkbenchPart part) {
        if (this.autoRefresh && this.getSite().getPage().isPartVisible((IWorkbenchPart)this)) {
            this.refresh();
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
        if (this.autoRefresh && this.getSite().getPage().isPartVisible((IWorkbenchPart)this)) {
            this.refresh();
        }
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }
}

