/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets;

import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.netxms.client.NXCSession;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.dashboard.widgets.DashboardControl;
import org.netxms.ui.eclipse.dashboard.widgets.ElementWidget;
import org.netxms.ui.eclipse.dashboard.widgets.internal.TableValueConfig;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.perfview.widgets.TableValueViewer;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.ViewRefreshController;

public class TableValueElement
extends ElementWidget {
    private TableValueConfig config;
    private TableValueViewer viewer;

    public TableValueElement(DashboardControl parent, DashboardElement element, IViewPart viewPart) {
        super(parent, element, viewPart);
        try {
            this.config = TableValueConfig.createFromXml(element.getData());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.config = new TableValueConfig();
        }
        this.processCommonSettings(this.config);
        this.viewer = new TableValueViewer(this.getContentArea(), 0, viewPart, parent.getDashboardObject().getGuid().toString(), true);
        if (this.config.getObjectId() == 0xFFFFFFFFL) {
            this.configureContext();
        } else {
            this.viewer.setObject(this.config.getObjectId(), this.config.getDciId());
            this.viewer.refresh(null);
        }
        final ViewRefreshController refreshController = new ViewRefreshController(viewPart, this.config.getRefreshRate(), new Runnable(){

            @Override
            public void run() {
                if (TableValueElement.this.isDisposed()) {
                    return;
                }
                TableValueElement.this.viewer.refresh(null);
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                refreshController.dispose();
            }
        });
    }

    private void configureContext() {
        final AbstractObject contextObject = this.getContext();
        if (contextObject == null) {
            return;
        }
        final NXCSession session = ConsoleSharedData.getSession();
        new ConsoleJob("Configuring context", (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.dashboard"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                DciValue[] dciList = session.getLastValues(contextObject.getObjectId());
                Pattern namePattern = Pattern.compile(TableValueElement.this.config.getDciName());
                Pattern descriptionPattern = Pattern.compile(TableValueElement.this.config.getDciDescription());
                DciValue[] dciValueArray = dciList;
                int n = dciList.length;
                int n2 = 0;
                while (n2 < n) {
                    final DciValue dciInfo = dciValueArray[n2];
                    if (dciInfo.getDcObjectType() == 2 && (!TableValueElement.this.config.getDciName().isEmpty() && namePattern.matcher(dciInfo.getName()).find() || !TableValueElement.this.config.getDciDescription().isEmpty() && descriptionPattern.matcher(dciInfo.getDescription()).find())) {
                        this.runInUIThread(new Runnable(){

                            @Override
                            public void run() {
                                (this).TableValueElement.this.viewer.setObject(dciInfo.getNodeId(), dciInfo.getId());
                                (this).TableValueElement.this.viewer.refresh(null);
                            }
                        });
                        break;
                    }
                    ++n2;
                }
            }

            protected String getErrorMessage() {
                return "Cannot read DCI data from server";
            }
        }.start();
    }
}

