/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.charts.widgets;

import java.util.List;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.netxms.client.datacollection.ChartConfiguration;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.ui.eclipse.charts.api.DataSeries;
import org.netxms.ui.eclipse.charts.widgets.Chart;
import org.netxms.ui.eclipse.charts.widgets.GenericComparisonChart;

public abstract class GenericGauge
extends GenericComparisonChart {
    protected static final int OUTER_MARGIN_WIDTH = 5;
    protected static final int OUTER_MARGIN_HEIGHT = 5;
    protected static final int INNER_MARGIN_WIDTH = 5;
    protected static final int INNER_MARGIN_HEIGHT = 5;
    protected static final RGB GREEN_ZONE_COLOR = new RGB(0, 224, 0);
    protected static final RGB YELLOW_ZONE_COLOR = new RGB(255, 242, 0);
    protected static final RGB RED_ZONE_COLOR = new RGB(224, 0, 0);

    public GenericGauge(Chart parent) {
        super(parent);
    }

    @Override
    protected void render(GC gc) {
        block9: {
            List<DataSeries> series;
            List<GraphItem> items;
            ChartConfiguration config;
            int top;
            Point size;
            block8: {
                int i;
                size = this.getSize();
                top = 5;
                config = this.chart.getConfiguration();
                items = this.chart.getItems();
                if (items.size() == 0 || size.x < 10 || size.y < 10) {
                    return;
                }
                series = this.chart.getDataSeries();
                if (!config.isTransposed()) break block8;
                int w = size.x - 10;
                int h = (size.y - 5 - top) / items.size();
                Point minSize = this.getMinElementSize();
                if (w < minSize.x || h < minSize.x) break block9;
                Object renderData = this.createRenderData();
                if (renderData != null) {
                    i = 0;
                    while (i < items.size()) {
                        this.prepareElementRender(gc, config, renderData, items.get(i), series.get(i), 0, top + i * h, w, h);
                        ++i;
                    }
                }
                i = 0;
                while (i < items.size()) {
                    this.renderElement(gc, config, renderData, items.get(i), series.get(i), 0, top + i * h, w, h);
                    ++i;
                }
                break block9;
            }
            int w = (size.x - 10) / items.size();
            int h = size.y - 5 - top;
            Point minSize = this.getMinElementSize();
            if (w >= minSize.x && h >= minSize.x) {
                int i;
                Object renderData = this.createRenderData();
                if (renderData != null) {
                    i = 0;
                    while (i < items.size()) {
                        this.prepareElementRender(gc, config, renderData, items.get(i), series.get(i), i * w, top, w, h);
                        ++i;
                    }
                }
                i = 0;
                while (i < items.size()) {
                    this.renderElement(gc, config, renderData, items.get(i), series.get(i), i * w, top, w, h);
                    ++i;
                }
            }
        }
    }

    protected Point getMinElementSize() {
        return new Point(10, 10);
    }

    protected Object createRenderData() {
        return null;
    }

    protected void prepareElementRender(GC gc, ChartConfiguration configuration, Object renderData, GraphItem dci, DataSeries data, int x, int y, int w, int h) {
    }

    protected abstract void renderElement(GC var1, ChartConfiguration var2, Object var3, GraphItem var4, DataSeries var5, int var6, int var7, int var8, int var9);
}

