/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.netxms.nxmc.base.widgets.helpers.TableSortingListener;

public class SortableTableViewer
extends TableViewer {
    public static final int DEFAULT_STYLE = -1;
    private boolean initialized = false;
    private List<TableColumn> columns = new ArrayList(16);
    private TableSortingListener sortingListener;

    public SortableTableViewer(Composite parent, String[] names, int[] widths, int defaultSortingColumn, int defaultSortDir, int style) {
        super(new Table(parent, style == -1 ? 65538 : style));
        this.getTable().setLinesVisible(true);
        this.getTable().setHeaderVisible(true);
        this.sortingListener = new TableSortingListener((TableViewer)this);
        this.createColumns(names, widths, defaultSortingColumn, defaultSortDir);
    }

    public SortableTableViewer(Composite parent, int style) {
        super(new Table(parent, style == -1 ? 65538 : style));
        this.getTable().setLinesVisible(true);
        this.getTable().setHeaderVisible(true);
        this.sortingListener = new TableSortingListener((TableViewer)this);
    }

    public void createColumns(String[] names, int[] widths, int defaultSortingColumn, int defaultSortDir) {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        for (int i = 0; i < names.length; ++i) {
            TableColumn c = new TableColumn(this.getTable(), 16384);
            this.columns.add(c);
            c.setText(names[i]);
            if (widths != null) {
                c.setWidth(widths[i]);
            }
            c.setData("ID", (Object)i);
            c.addSelectionListener((SelectionListener)this.sortingListener);
        }
        if (defaultSortingColumn >= 0 && defaultSortingColumn < names.length) {
            this.getTable().setSortColumn((TableColumn)this.columns.get(defaultSortingColumn));
        }
        this.getTable().setSortDirection(defaultSortDir);
    }

    public TableColumn addColumn(String name, int width) {
        int index = this.getTable().getColumnCount();
        TableColumn c = new TableColumn(this.getTable(), 16384);
        this.columns.add(c);
        c.setText(name);
        c.pack();
        if (width > 0) {
            c.setWidth(width);
        }
        c.setData("ID", (Object)index);
        c.addSelectionListener((SelectionListener)this.sortingListener);
        return c;
    }

    public TableColumn getColumnById(int id) {
        for (TableColumn c : this.columns) {
            if (c.isDisposed() || (Integer)c.getData("ID") != id) continue;
            return c;
        }
        return null;
    }

    public void removeColumnById(int id) {
        for (TableColumn c : this.columns) {
            if (c.isDisposed() || (Integer)c.getData("ID") != id) continue;
            this.columns.remove(c);
            c.dispose();
            return;
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void disableSorting() {
        for (TableColumn c : this.columns) {
            c.removeSelectionListener((SelectionListener)this.sortingListener);
        }
        this.getTable().setSortColumn(null);
    }

    public void packColumns() {
        Table table = this.getTable();
        int count = table.getColumnCount();
        for (int i = 0; i < count; ++i) {
            table.getColumn(i).pack();
        }
    }

    public TableColumn getColumnAtPoint(Point p) {
        TableItem item = this.getTable().getItem(p);
        if (item == null) {
            return null;
        }
        int columnCount = this.getTable().getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            Rectangle rect = item.getBounds(i);
            if (!rect.contains(p)) continue;
            return this.getTable().getColumn(i);
        }
        return null;
    }

    public ViewerRow getViewerRowFromItem(Widget item) {
        return super.getViewerRowFromItem(item);
    }
}

