/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.agentmanagement.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.Node;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.agentmanagement.dialogs.SaveConfigDialog;
import org.netxms.nxmc.modules.agentmanagement.widgets.AgentConfigEditor;
import org.netxms.nxmc.modules.objects.views.AdHocObjectView;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class AgentConfigurationEditor
extends AdHocObjectView {
    private static final I18n i18n = LocalizationHelper.getI18n(AgentConfigurationEditor.class);
    private AgentConfigEditor editor;
    private boolean modified = false;
    private Action actionSave;
    private Action actionSaveAndApply;

    public AgentConfigurationEditor(Node node, long contextId) {
        super(i18n.tr("Agent Configuration"), ResourceManager.getImageDescriptor((String)"icons/object-views/agent-config.png"), "AgentConfigurationEditor", node.getObjectId(), contextId, false);
    }

    protected AgentConfigurationEditor() {
        super(null, null, null, 0L, 0L, false);
    }

    protected void postClone(View origin) {
        super.postClone(origin);
        AgentConfigurationEditor view = (AgentConfigurationEditor)origin;
        this.editor.setText(view.editor.getText());
        this.modified = view.modified;
        this.actionSave.setEnabled(view.actionSave.isEnabled());
    }

    public void createContent(Composite parent) {
        this.editor = new AgentConfigEditor(parent, 0, 768);
        this.editor.getTextWidget().addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createActions();
        this.actionSave.setEnabled(false);
    }

    protected void postContentCreate() {
        super.postContentCreate();
        this.refresh();
    }

    public void setFocus() {
        this.editor.setFocus();
    }

    private void createActions() {
        this.actionSave = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+S", (IAction)this.actionSave);
        this.actionSaveAndApply = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+M2+S", (IAction)this.actionSaveAndApply);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionSave);
        manager.add((IAction)this.actionSaveAndApply);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionSave);
    }

    public void refresh() {
        if (this.modified && !MessageDialogHelper.openQuestion((Shell)this.getWindow().getShell(), (String)i18n.tr("Reload Content"), (String)i18n.tr("You have unsaved changes to configuration file. These changes will be lost after reload. Do you want to continue?"))) {
            return;
        }
        this.clearMessages();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public boolean beforeClose() {
        if (!this.modified) {
            return true;
        }
        SaveConfigDialog dlg = new SaveConfigDialog(this.getWindow().getShell());
        int rc = dlg.open();
        if (rc == 1) {
            return false;
        }
        if (rc == 102) {
            return true;
        }
        this.saveConfig(rc == 101);
        return true;
    }

    private void saveConfig(boolean saveAndApply) {
        if (!this.modified) {
            return;
        }
        this.clearMessages();
        String content = this.editor.getText();
        long nodeId = this.getObjectId();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    static /* synthetic */ NXCSession access$000(AgentConfigurationEditor x0) {
        return x0.session;
    }

    static /* synthetic */ NXCSession access$100(AgentConfigurationEditor x0) {
        return x0.session;
    }
}

