/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.propertypages;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.config.TableBarChartConfig;
import org.netxms.nxmc.modules.dashboards.config.TableComparisonChartConfig;
import org.netxms.nxmc.modules.dashboards.config.TablePieChartConfig;
import org.netxms.nxmc.modules.dashboards.propertypages.DashboardElementPropertyPage;
import org.netxms.nxmc.modules.dashboards.widgets.TitleConfigurator;
import org.netxms.nxmc.modules.datacollection.widgets.YAxisRangeEditor;
import org.netxms.nxmc.modules.objects.dialogs.ObjectSelectionDialog;
import org.netxms.nxmc.modules.objects.widgets.ObjectSelector;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class TableComparisonChart
extends DashboardElementPropertyPage {
    private static final I18n i18n = LocalizationHelper.getI18n(TableComparisonChart.class);
    private TableComparisonChartConfig config;
    private TitleConfigurator title;
    private Spinner refreshRate;
    private Combo legendPosition;
    private Button checkShowLegend;
    private Button checkExtendedLegend;
    private Button checkTranslucent;
    private Button checkTransposed;
    private YAxisRangeEditor yAxisRange;
    private ObjectSelector drillDownObject;

    public TableComparisonChart(DashboardElementConfig elementConfig) {
        super(i18n.tr("Chart"), elementConfig);
    }

    public String getId() {
        return "table-comparison-chart";
    }

    public boolean isVisible() {
        return this.elementConfig instanceof TableComparisonChartConfig;
    }

    public int getPriority() {
        return 0;
    }

    protected Control createContents(Composite parent) {
        this.config = (TableComparisonChartConfig)this.elementConfig;
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        dialogArea.setLayout((Layout)layout);
        this.title = new TitleConfigurator(dialogArea, (DashboardElementConfig)this.config);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.title.setLayoutData((Object)gd);
        this.legendPosition = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)i18n.tr("Legend position"), (Object)"WidgetHelper::default_layout_data");
        this.legendPosition.add(i18n.tr("Left"));
        this.legendPosition.add(i18n.tr("Right"));
        this.legendPosition.add(i18n.tr("Top"));
        this.legendPosition.add(i18n.tr("Bottom"));
        this.legendPosition.select(this.positionIndexFromValue(this.config.getLegendPosition()));
        Group optionsGroup = new Group(dialogArea, 0);
        optionsGroup.setText(i18n.tr("Options"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalSpan = 2;
        optionsGroup.setLayoutData((Object)gd);
        GridLayout optionsLayout = new GridLayout();
        optionsGroup.setLayout((Layout)optionsLayout);
        this.checkShowLegend = new Button((Composite)optionsGroup, 32);
        this.checkShowLegend.setText(i18n.tr("Show &legend"));
        this.checkShowLegend.setSelection(this.config.isShowLegend());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.checkShowLegend.setLayoutData((Object)gd);
        this.checkExtendedLegend = new Button((Composite)optionsGroup, 32);
        this.checkExtendedLegend.setText(i18n.tr("E&xtended legend"));
        this.checkExtendedLegend.setSelection(this.config.isExtendedLegend());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.checkExtendedLegend.setLayoutData((Object)gd);
        this.checkTranslucent = new Button((Composite)optionsGroup, 32);
        this.checkTranslucent.setText(i18n.tr("T&ranslucent"));
        this.checkTranslucent.setSelection(this.config.isTranslucent());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.checkTranslucent.setLayoutData((Object)gd);
        if (this.config instanceof TableBarChartConfig) {
            this.checkTransposed = new Button((Composite)optionsGroup, 32);
            this.checkTransposed.setText(i18n.tr("Trans&posed"));
            this.checkTransposed.setSelection(((TableBarChartConfig)this.config).isTransposed());
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.checkTransposed.setLayoutData((Object)gd);
        }
        gd = new GridData();
        gd.verticalAlignment = 128;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.refreshRate = WidgetHelper.createLabeledSpinner((Composite)dialogArea, (int)2048, (String)i18n.tr("Refresh interval (seconds)"), (int)1, (int)10000, (Object)gd);
        this.refreshRate.setSelection(this.config.getRefreshRate());
        if (!(this.config instanceof TablePieChartConfig)) {
            this.yAxisRange = new YAxisRangeEditor(dialogArea, 0);
            gd = new GridData();
            gd.horizontalSpan = layout.numColumns;
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.yAxisRange.setLayoutData((Object)gd);
            this.yAxisRange.setSelection(this.config.isAutoScale(), this.config.modifyYBase(), this.config.getMinYScaleValue(), this.config.getMaxYScaleValue());
        }
        this.drillDownObject = new ObjectSelector(dialogArea, 0, true);
        this.drillDownObject.setLabel(i18n.tr("Drill-down object"));
        this.drillDownObject.setObjectClass(AbstractObject.class);
        this.drillDownObject.setClassFilter(ObjectSelectionDialog.createDashboardAndNetworkMapSelectionFilter());
        this.drillDownObject.setObjectId(this.config.getDrillDownObjectId());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.drillDownObject.setLayoutData((Object)gd);
        return dialogArea;
    }

    private int positionIndexFromValue(int value) {
        switch (value) {
            case 8: {
                return 3;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 2;
            }
        }
        return 0;
    }

    protected boolean applyChanges(boolean isApply) {
        this.title.updateConfiguration((DashboardElementConfig)this.config);
        this.config.setLegendPosition(1 << this.legendPosition.getSelectionIndex());
        this.config.setRefreshRate(this.refreshRate.getSelection());
        this.config.setShowLegend(this.checkShowLegend.getSelection());
        this.config.setExtendedLegend(this.checkExtendedLegend.getSelection());
        this.config.setTranslucent(this.checkTranslucent.getSelection());
        this.config.setDrillDownObjectId(this.drillDownObject.getObjectId());
        if (!(this.config instanceof TablePieChartConfig)) {
            if (!this.yAxisRange.validate(true)) {
                return false;
            }
            this.config.setAutoScale(this.yAxisRange.isAuto());
            this.config.setMinYScaleValue(this.yAxisRange.getMinY());
            this.config.setMaxYScaleValue(this.yAxisRange.getMaxY());
            this.config.setModifyYBase(this.yAxisRange.modifyYBase());
        }
        if (this.config instanceof TableBarChartConfig) {
            ((TableBarChartConfig)this.config).setTransposed(this.checkTransposed.getSelection());
        }
        return true;
    }
}

