/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.dialogs;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.base.InetAddressEx;
import org.netxms.base.MacAddress;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.tools.IPAddressValidator;
import org.netxms.nxmc.tools.IPNetMaskValidator;
import org.netxms.nxmc.tools.MacAddressValidator;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.NumericTextFieldValidator;
import org.netxms.nxmc.tools.ObjectNameValidator;
import org.netxms.nxmc.tools.TextFieldValidator;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class CreateInterfaceDialog
extends Dialog {
    private static final int DEFAULT_MASK_BITS = 8;
    private I18n i18n = LocalizationHelper.getI18n(CreateInterfaceDialog.class);
    private LabeledText nameField;
    private LabeledText aliasField;
    private LabeledText macAddrField;
    private LabeledText ipAddrField;
    private LabeledText ipMaskField;
    private Button checkIsPhy;
    private LabeledText slotField;
    private LabeledText portField;
    private String name;
    private String alias;
    private MacAddress macAddress;
    private InetAddressEx ipAddress;
    private int ifIndex;
    private int ifType;
    private int slot;
    private int port;
    private boolean physicalPort;

    public CreateInterfaceDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.i18n.tr("Create Interface"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        dialogArea.setLayout((Layout)layout);
        this.nameField = new LabeledText(dialogArea, 0);
        this.nameField.setLabel(this.i18n.tr("Name"));
        this.nameField.getTextControl().setTextLimit(255);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 300;
        gd.horizontalSpan = 2;
        this.nameField.setLayoutData((Object)gd);
        this.aliasField = new LabeledText(dialogArea, 0);
        this.aliasField.setLabel(this.i18n.tr("Alias"));
        this.aliasField.getTextControl().setTextLimit(255);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.aliasField.setLayoutData((Object)gd);
        this.macAddrField = new LabeledText(dialogArea, 0);
        this.macAddrField.setLabel(this.i18n.tr("MAC address"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.macAddrField.setLayoutData((Object)gd);
        this.ipAddrField = new LabeledText(dialogArea, 0);
        this.ipAddrField.setLabel(this.i18n.tr("IP address"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.ipAddrField.setLayoutData((Object)gd);
        this.ipMaskField = new LabeledText(dialogArea, 0);
        this.ipMaskField.setLabel(this.i18n.tr("IP network mask"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.ipMaskField.setLayoutData((Object)gd);
        this.checkIsPhy = new Button(dialogArea, 32);
        this.checkIsPhy.setText(this.i18n.tr("This interface is a physical port"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.checkIsPhy.setLayoutData((Object)gd);
        this.checkIsPhy.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.slotField = new LabeledText(dialogArea, 0);
        this.slotField.setLabel(this.i18n.tr("Slot"));
        this.slotField.setText("0");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.slotField.setLayoutData((Object)gd);
        this.slotField.setEnabled(false);
        this.portField = new LabeledText(dialogArea, 0);
        this.portField.setLabel(this.i18n.tr("Port"));
        this.portField.setText("0");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.portField.setLayoutData((Object)gd);
        this.portField.setEnabled(false);
        return dialogArea;
    }

    protected void okPressed() {
        this.physicalPort = this.checkIsPhy.getSelection();
        if (!WidgetHelper.validateTextInput((LabeledText)this.nameField, (TextFieldValidator)new ObjectNameValidator(), null) || !WidgetHelper.validateTextInput((LabeledText)this.macAddrField, (TextFieldValidator)new MacAddressValidator(true), null) || !WidgetHelper.validateTextInput((LabeledText)this.ipAddrField, (TextFieldValidator)new IPAddressValidator(true), null) || !WidgetHelper.validateTextInput((LabeledText)this.ipMaskField, (TextFieldValidator)new IPNetMaskValidator(true, this.ipAddrField.getText().trim()), null) || this.physicalPort && !WidgetHelper.validateTextInput((LabeledText)this.slotField, (TextFieldValidator)new NumericTextFieldValidator(0L, 4096L), null) || this.physicalPort && !WidgetHelper.validateTextInput((LabeledText)this.portField, (TextFieldValidator)new NumericTextFieldValidator(0L, 4096L), null)) {
            return;
        }
        try {
            this.name = this.nameField.getText().trim();
            this.alias = this.aliasField.getText().trim();
            this.macAddress = this.macAddrField.getText().trim().isEmpty() ? new MacAddress() : MacAddress.parseMacAddress((String)this.macAddrField.getText());
            InetAddress addr = this.ipAddrField.getText().trim().isEmpty() ? InetAddress.getByName("0.0.0.0") : InetAddress.getByName(this.ipAddrField.getText());
            this.ipAddress = new InetAddressEx(addr, this.getMaskBits(this.ipMaskField.getText().trim(), addr instanceof Inet4Address ? 32 : 128));
            this.slot = this.physicalPort ? Integer.parseInt(this.slotField.getText()) : 0;
            this.port = this.physicalPort ? Integer.parseInt(this.portField.getText()) : 0;
            super.okPressed();
        }
        catch (Exception e) {
            MessageDialogHelper.openError((Shell)this.getShell(), (String)this.i18n.tr("Error"), (String)String.format(this.i18n.tr("Internal error: %s"), e.getLocalizedMessage()));
        }
    }

    private int getMaskBits(String mask, int maxBits) {
        if (mask.isEmpty()) {
            return 8;
        }
        try {
            int bits = Integer.parseInt(mask);
            return bits >= 0 && bits <= maxBits ? bits : 8;
        }
        catch (NumberFormatException bits) {
            try {
                InetAddress addr = InetAddress.getByName(mask);
                return InetAddressEx.bitsInMask((InetAddress)addr);
            }
            catch (UnknownHostException unknownHostException) {
                return 8;
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public int getPort() {
        return this.port;
    }

    public MacAddress getMacAddress() {
        return this.macAddress;
    }

    public InetAddressEx getIpAddress() {
        return this.ipAddress;
    }

    public int getIfIndex() {
        return this.ifIndex;
    }

    public int getIfType() {
        return this.ifType;
    }

    public int getSlot() {
        return this.slot;
    }

    public boolean isPhysicalPort() {
        return this.physicalPort;
    }
}

