/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.Interface;
import org.netxms.client.objects.Node;
import org.netxms.client.objects.Rack;
import org.netxms.client.objects.Subnet;
import org.netxms.client.objects.Zone;
import org.netxms.nxmc.base.actions.ExportToCsvAction;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objects.views.helpers.Dot1xPortComparator;
import org.netxms.nxmc.modules.objects.views.helpers.Dot1xPortFilter;
import org.netxms.nxmc.modules.objects.views.helpers.Dot1xPortListLabelProvider;
import org.netxms.nxmc.modules.objects.views.helpers.Dot1xPortSummary;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class Dot1xStatusView
extends ObjectView {
    private static I18n i18n = LocalizationHelper.getI18n(Dot1xStatusView.class);
    public static final int COLUMN_NODE = 0;
    public static final int COLUMN_PORT = 1;
    public static final int COLUMN_INTERFACE = 2;
    public static final int COLUMN_PAE_STATE = 3;
    public static final int COLUMN_BACKEND_STATE = 4;
    private SortableTableViewer viewer;
    private Action actionExportToCsv;
    private Action actionExportAllToCsv;

    public Dot1xStatusView() {
        super(i18n.tr("802.1x"), ResourceManager.getImageDescriptor((String)"icons/object-views/pae.png"), "Dot1xStatusView", true);
    }

    protected void createContent(Composite parent) {
        String[] names = new String[]{i18n.tr("Device"), i18n.tr("Port"), i18n.tr("Interface"), i18n.tr("PAE State"), i18n.tr("Backend State")};
        int[] widths = new int[]{250, 60, 180, 150, 150};
        this.viewer = new SortableTableViewer(parent, names, widths, 1, 128, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new Dot1xPortListLabelProvider());
        this.viewer.setComparator((ViewerComparator)new Dot1xPortComparator());
        Dot1xPortFilter filter = new Dot1xPortFilter();
        this.setFilterClient((ISelectionProvider)this.viewer, (AbstractViewerFilter)filter);
        this.viewer.addFilter((ViewerFilter)filter);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (String)"Dot1xStatusView");
        this.viewer.getTable().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createActions();
        this.createPopupMenu();
    }

    private void createActions() {
        this.actionExportToCsv = new ExportToCsvAction((View)this, (ColumnViewer)this.viewer, true);
        this.actionExportAllToCsv = new ExportToCsvAction((View)this, (ColumnViewer)this.viewer, false);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionExportToCsv);
        manager.add((IAction)this.actionExportAllToCsv);
    }

    public void refresh() {
        if (this.getObject() != null) {
            ArrayList portList = new ArrayList();
            HashSet nodeList = new HashSet();
            this.fillPortList(portList, nodeList, this.getObject());
            this.viewer.setInput((Object)portList.toArray());
        } else {
            this.viewer.setInput((Object)new Dot1xPortSummary[0]);
        }
    }

    private void fillPortList(List<Dot1xPortSummary> portList, Set<Long> nodeList, AbstractObject root) {
        if (root instanceof Node && !nodeList.contains(root.getObjectId())) {
            for (AbstractObject o : root.getAllChildren(3)) {
                if ((((Interface)o).getFlags() & 2) == 0) continue;
                portList.add(new Dot1xPortSummary((Node)root, (Interface)o));
            }
            nodeList.add(root.getObjectId());
        } else {
            for (AbstractObject object : root.getChildrenAsArray()) {
                this.fillPortList(portList, nodeList, object);
            }
        }
    }

    protected void onObjectChange(AbstractObject object) {
        this.refresh();
    }

    public boolean isValidForContext(Object context) {
        if (context == null) {
            return false;
        }
        if (context instanceof Node) {
            return ((Node)context).is8021xSupported();
        }
        return context instanceof Container || context instanceof Cluster || context instanceof Rack || context instanceof Subnet || context instanceof Zone;
    }

    public int getPriority() {
        return 290;
    }
}

