/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.InputField;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.objects.queries.ObjectQuery;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.views.ConfigurationView;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.dialogs.InputFieldEntryDialog;
import org.netxms.nxmc.modules.objects.dialogs.ObjectQueryEditDialog;
import org.netxms.nxmc.modules.objects.views.helpers.ObjectQueryComparator;
import org.netxms.nxmc.modules.objects.views.helpers.ObjectQueryFilter;
import org.netxms.nxmc.modules.objects.views.helpers.ObjectQueryLabelProvider;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.RefreshTimer;
import org.xnap.commons.i18n.I18n;

public class ObjectQueryManager
extends ConfigurationView {
    private static final I18n i18n = LocalizationHelper.getI18n(ObjectQueryManager.class);
    public static final int COL_ID = 0;
    public static final int COL_NAME = 1;
    public static final int COL_DESCRIPTION = 2;
    public static final int COL_IS_VALID = 3;
    private NXCSession session = Registry.getSession();
    private SessionListener sessionListener;
    private SortableTableViewer viewer;
    private RefreshTimer refreshTimer;
    private Action actionCreate;
    private Action actionEdit;
    private Action actionDelete;
    private Action actionExecute;

    public ObjectQueryManager() {
        super(i18n.tr("Object Queries"), ResourceManager.getImageDescriptor((String)"icons/config-views/object-queries.png"), "ObjectQueryManager", true);
    }

    public void createContent(Composite parent) {
        String[] names = new String[]{i18n.tr("ID"), i18n.tr("Name"), i18n.tr("Description"), i18n.tr("Valid")};
        int[] widths = new int[]{120, 300, 600, 60};
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 128, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ObjectQueryLabelProvider());
        this.viewer.setComparator((ViewerComparator)new ObjectQueryComparator());
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        ObjectQueryFilter filter = new ObjectQueryFilter();
        this.viewer.addFilter((ViewerFilter)filter);
        this.setFilterClient((ISelectionProvider)this.viewer, (AbstractViewerFilter)filter);
        this.createActions();
        this.createContextMenu();
        this.refreshTimer = new RefreshTimer(500, this.viewer.getControl(), (Runnable)new /* Unavailable Anonymous Inner Class!! */);
        this.sessionListener = new /* Unavailable Anonymous Inner Class!! */;
        this.session.addListener(this.sessionListener);
    }

    protected void postContentCreate() {
        super.postContentCreate();
        this.refresh();
    }

    private void createActions() {
        this.actionCreate = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+N", (IAction)this.actionCreate);
        this.actionEdit = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M3+ENTER", (IAction)this.actionEdit);
        this.actionDelete = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+D", (IAction)this.actionDelete);
        this.actionExecute = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("F9", (IAction)this.actionExecute);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionCreate);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionCreate);
    }

    private void createContextMenu() {
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = manager.createContextMenu((Control)this.viewer.getTable());
        this.viewer.getTable().setMenu(menu);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void dispose() {
        this.session.removeListener(this.sessionListener);
        super.dispose();
    }

    public void refresh() {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void createQuery() {
        ObjectQueryEditDialog dlg = new ObjectQueryEditDialog(this.getWindow().getShell(), null);
        if (dlg.open() != 0) {
            return;
        }
        ObjectQuery query = dlg.getQuery();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void editQuery() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        ObjectQuery query = (ObjectQuery)selection.getFirstElement();
        ObjectQueryEditDialog dlg = new ObjectQueryEditDialog(this.getWindow().getShell(), query);
        if (dlg.open() != 0) {
            return;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void deleteQueries() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!MessageDialogHelper.openQuestion((Shell)this.getWindow().getShell(), (String)i18n.tr("Delete"), (String)i18n.tr("Selected object queries will be permanently deleted. Are you sure?"))) {
            return;
        }
        ArrayList<Integer> idList = new ArrayList<Integer>(selection.size());
        for (Object o : selection.toList()) {
            idList.add(((ObjectQuery)o).getId());
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void executeQuery() {
        Map inputValues;
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        ObjectQuery query = (ObjectQuery)selection.getFirstElement();
        List fields = query.getInputFields();
        if (!fields.isEmpty()) {
            fields.sort(new /* Unavailable Anonymous Inner Class!! */);
            inputValues = InputFieldEntryDialog.readInputFields((Shell)this.getWindow().getShell(), (String)query.getName(), (InputField[])fields.toArray(new InputField[fields.size()]));
            if (inputValues == null) {
                return;
            }
        } else {
            inputValues = new HashMap(0);
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public boolean isModified() {
        return false;
    }

    public void save() {
    }
}

