/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeListener;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.VPNConnector;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.NodeSubObjectTableView;
import org.netxms.nxmc.modules.objects.views.helpers.VPNConnectorFilter;
import org.netxms.nxmc.modules.objects.views.helpers.VPNConnectorListComparator;
import org.netxms.nxmc.modules.objects.views.helpers.VPNConnectorListLabelProvider;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class VpnView
extends NodeSubObjectTableView {
    private static final I18n i18n = LocalizationHelper.getI18n(VpnView.class);
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_NAME = 1;
    public static final int COLUMN_STATUS = 2;
    public static final int COLUMN_PEER_GATEWAY = 3;
    public static final int COLUMN_LOCAL_SUBNETS = 4;
    public static final int COLUMN_REMOTE_SUBNETS = 5;
    private VPNConnectorListLabelProvider labelProvider;

    public VpnView() {
        super(i18n.tr("VPNs"), ResourceManager.getImageDescriptor((String)"icons/object-views/vpn.png"), "VPNs", true);
    }

    public boolean isValidForContext(Object context) {
        if (context != null && context instanceof AbstractNode) {
            return ((AbstractNode)context).hasVpnConnectors();
        }
        return false;
    }

    public int getPriority() {
        return 60;
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionCopyToClipboard);
        manager.add((IAction)this.actionExportToCsv);
    }

    public void refresh() {
        if (this.getObject() != null) {
            this.viewer.setInput((Object)this.getObject().getAllChildren(12).toArray());
        } else {
            this.viewer.setInput((Object)new VPNConnector[0]);
        }
    }

    protected void createViewer() {
        String[] names = new String[]{i18n.tr("Id"), i18n.tr("Name"), i18n.tr("Status"), i18n.tr("Peer gateway"), i18n.tr("Local subnets"), i18n.tr("Remote subnets")};
        int[] widths = new int[]{60, 150, 80, 150, 200, 200};
        this.viewer = new SortableTableViewer(this.mainArea, names, widths, 1, 128, 65538);
        this.labelProvider = new VPNConnectorListLabelProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator((ViewerComparator)new VPNConnectorListComparator(this.labelProvider));
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        this.filter = new VPNConnectorFilter(this.labelProvider);
        this.setFilterClient((ISelectionProvider)this.viewer, (AbstractViewerFilter)this.filter);
        this.viewer.addFilter((ViewerFilter)this.filter);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (String)"VPNTable.V1");
        this.viewer.getTable().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public boolean needRefreshOnObjectChange(AbstractObject object) {
        return object instanceof VPNConnector && object.isChildOf(this.getObjectId());
    }
}

