/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.widgets;

import java.util.ArrayList;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Node;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.base.widgets.SortableTreeViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objects.widgets.helpers.SoftwareInventoryContentProvider;
import org.netxms.nxmc.modules.objects.widgets.helpers.SoftwarePackageComparator;
import org.netxms.nxmc.modules.objects.widgets.helpers.SoftwarePackageLabelProvider;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class SoftwareInventory
extends Composite {
    private static final I18n i18n = LocalizationHelper.getI18n(SoftwareInventory.class);
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_VERSION = 1;
    public static final int COLUMN_VENDOR = 2;
    public static final int COLUMN_DATE = 3;
    public static final int COLUMN_DESCRIPTION = 4;
    public static final int COLUMN_URL = 5;
    private static final String[] names = new String[]{i18n.tr("Name"), i18n.tr("Version"), i18n.tr("Vendor"), i18n.tr("Install Date"), i18n.tr("Description"), i18n.tr("URL")};
    private static final int[] widths = new int[]{200, 100, 200, 100, 300, 200};
    private ObjectView viewPart;
    private ColumnViewer viewer;
    private String configPrefix;
    private MenuManager menuManager = null;

    public SoftwareInventory(Composite parent, int style, ObjectView viewPart, String configPrefix) {
        super(parent, style);
        this.viewPart = viewPart;
        this.configPrefix = configPrefix;
        this.setLayout((Layout)new FillLayout());
        this.createTableViewer();
    }

    private void createTableViewer() {
        this.viewer = new SortableTableViewer((Composite)this, names, widths, 0, 128, 65538);
        WidgetHelper.restoreColumnViewerSettings((ColumnViewer)this.viewer, (String)this.configPrefix);
        this.viewer.getControl().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new SoftwarePackageLabelProvider(false));
        this.viewer.setComparator((ViewerComparator)new SoftwarePackageComparator());
        if (this.menuManager != null) {
            Menu menu = this.menuManager.createContextMenu(this.viewer.getControl());
            this.viewer.getControl().setMenu(menu);
        }
    }

    private void createTreeViewer() {
        this.viewer = new SortableTreeViewer((Composite)this, names, widths, 0, 128, 65538);
        WidgetHelper.restoreColumnViewerSettings((ColumnViewer)this.viewer, (String)this.configPrefix);
        this.viewer.getControl().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.setContentProvider((IContentProvider)new SoftwareInventoryContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new SoftwarePackageLabelProvider(true));
        this.viewer.setComparator((ViewerComparator)new SoftwarePackageComparator());
        if (this.menuManager != null) {
            Menu menu = this.menuManager.createContextMenu(this.viewer.getControl());
            this.viewer.getControl().setMenu(menu);
        }
    }

    public void refresh() {
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public void setRootObjectId(long rootObjectId) {
        AbstractObject object = Registry.getSession().findObjectById(rootObjectId);
        if (object instanceof Node) {
            if (!(this.viewer instanceof SortableTableViewer)) {
                this.viewer.getControl().dispose();
                this.createTableViewer();
                this.layout(true, true);
            }
        } else if (!(this.viewer instanceof SortableTreeViewer)) {
            this.viewer.getControl().dispose();
            this.createTreeViewer();
            this.layout(true, true);
        }
    }

    public ColumnViewer getViewer() {
        return this.viewer;
    }

    public void setViewerMenu(MenuManager manager) {
        this.menuManager = manager;
        if (this.viewer != null) {
            Menu menu = this.menuManager.createContextMenu(this.viewer.getControl());
            this.viewer.getControl().setMenu(menu);
        }
    }

    public void clear() {
        this.viewer.setInput(new ArrayList());
    }
}

