/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.serverconfig.views.helpers;

import it.burning.cron.CronExpressionDescriptor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.NXCSession;
import org.netxms.client.ScheduledTask;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.DateFormatFactory;
import org.netxms.nxmc.modules.objects.widgets.helpers.BaseObjectLabelProvider;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.ViewerElementUpdater;

public class ScheduledTaskLabelProvider
extends LabelProvider
implements ITableLabelProvider,
IColorProvider {
    private static final Color COLOR_DISABLED = new Color((Device)Display.getDefault(), new RGB(126, 137, 185));
    private static final Color COLOR_SYSTEM = new Color((Device)Display.getDefault(), new RGB(196, 170, 94));
    private static final int EXECUTED = 0;
    private static final int PENDING = 1;
    private static final int DISABLED = 2;
    private NXCSession session = Registry.getSession();
    private BaseObjectLabelProvider objectLabelProvider = new BaseObjectLabelProvider();
    private Image[] statusImages;
    private SortableTableViewer viewer;

    public ScheduledTaskLabelProvider(SortableTableViewer viewer) {
        this.viewer = viewer;
        this.statusImages = new Image[3];
        this.statusImages[0] = ResourceManager.getImageDescriptor((String)"icons/active.gif").createImage();
        this.statusImages[1] = ResourceManager.getImageDescriptor((String)"icons/pending.png").createImage();
        this.statusImages[2] = ResourceManager.getImageDescriptor((String)"icons/inactive.gif").createImage();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        ScheduledTask task = (ScheduledTask)element;
        switch (columnIndex) {
            case 0: {
                if (task.isDisabled()) {
                    return this.statusImages[2];
                }
                if ((task.getFlags() & 2) != 0 || (task.getFlags() & 4) != 0) {
                    return this.statusImages[0];
                }
                return this.statusImages[1];
            }
            case 2: {
                if (task.getObjectId() == 0L) {
                    return null;
                }
                AbstractObject object = this.session.findObjectById(((ScheduledTask)element).getObjectId());
                return object != null ? this.objectLabelProvider.getImage((Object)object) : null;
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        ScheduledTask task = (ScheduledTask)element;
        switch (columnIndex) {
            case 0: {
                return Long.toString(task.getId());
            }
            case 1: {
                return task.getTaskHandlerId();
            }
            case 2: {
                return task.getObjectId() == 0L ? "" : this.session.getObjectName(task.getObjectId());
            }
            case 3: {
                return task.getParameters();
            }
            case 5: {
                return task.getSchedule().isEmpty() ? DateFormatFactory.getDateTimeFormat().format(task.getExecutionTime()) : task.getSchedule();
            }
            case 6: {
                if (task.getSchedule().isEmpty()) {
                    return String.format("Exactly at %s", DateFormatFactory.getDateTimeFormat().format(task.getExecutionTime()));
                }
                try {
                    return CronExpressionDescriptor.getDescription((String)task.getSchedule());
                }
                catch (Exception e) {
                    return "";
                }
            }
            case 7: {
                return task.getLastExecutionTime().getTime() == 0L ? "" : DateFormatFactory.getDateTimeFormat().format(task.getLastExecutionTime());
            }
            case 8: {
                return task.getStatus();
            }
            case 9: {
                return task.isDisabled() ? "Disabled" : "Enabled";
            }
            case 10: {
                if (task.isSystem()) {
                    return "system";
                }
                AbstractUserObject user = this.session.findUserDBObjectById(task.getOwner(), (Runnable)new ViewerElementUpdater((ColumnViewer)this.viewer, element));
                return user != null ? user.getName() : "[" + Long.toString(task.getOwner()) + "]";
            }
            case 11: {
                return task.getComments();
            }
            case 4: {
                return task.getKey();
            }
        }
        return null;
    }

    public Color getForeground(Object element) {
        if (((ScheduledTask)element).isDisabled()) {
            return COLOR_DISABLED;
        }
        if (((ScheduledTask)element).isSystem()) {
            return COLOR_SYSTEM;
        }
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }
}

