/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.worldmap.views;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.netxms.base.GeoLocation;
import org.netxms.client.GeoArea;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.views.ConfigurationView;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.worldmap.dialogs.GeoAreaEditDialog;
import org.netxms.nxmc.modules.worldmap.views.helpers.GeoAreaComparator;
import org.netxms.nxmc.modules.worldmap.views.helpers.GeoAreaFilter;
import org.netxms.nxmc.modules.worldmap.views.helpers.GeoAreaLabelProvider;
import org.netxms.nxmc.modules.worldmap.widgets.GeoAreaViewer;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class GeoAreasManager
extends ConfigurationView
implements SessionListener {
    private static final I18n i18n = LocalizationHelper.getI18n(GeoAreasManager.class);
    public static final int COL_ID = 0;
    public static final int COL_NAME = 1;
    public static final int COL_COMMENTS = 2;
    private static final String TABLE_CONFIG_PREFIX = "GeoAreaManager";
    private Map<Integer, GeoArea> areas = new HashMap();
    private SashForm splitter;
    private SortableTableViewer viewer;
    private NXCSession session = Registry.getSession();
    private GeoAreaFilter filter;
    private Composite details;
    private TableViewer coordinateListViewer;
    private GeoAreaViewer mapViewer;
    private Action actionNew;
    private Action actionEdit;
    private Action actionDelete;
    private Action actionImport;

    public GeoAreasManager() {
        super(i18n.tr("Geographical Areas"), ResourceManager.getImageDescriptor((String)"icons/config-views/geo-areas.png"), "GeographicalAreas", true);
    }

    protected void createContent(Composite parent) {
        this.splitter = new SashForm(parent, 256);
        String[] names = new String[]{"ID", "Name", "Comments"};
        int[] widths = new int[]{100, 400, 800};
        this.viewer = new SortableTableViewer((Composite)this.splitter, names, widths, 1, 1024, 65538);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (String)TABLE_CONFIG_PREFIX);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new GeoAreaLabelProvider());
        this.viewer.setComparator((ViewerComparator)new GeoAreaComparator());
        this.filter = new GeoAreaFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.setFilterClient((ISelectionProvider)this.viewer, (AbstractViewerFilter)this.filter);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.getTable().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.details = new Composite((Composite)this.splitter, 0);
        this.details.setLayout((Layout)new FillLayout(512));
        this.coordinateListViewer = new TableViewer(this.details);
        this.coordinateListViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.mapViewer = new GeoAreaViewer(this.details, 2048, (View)this);
        this.mapViewer.enableMapControls(false);
        this.splitter.setWeights(new int[]{60, 40});
        this.createActions();
        this.createContextMenu();
        this.session.addListener((SessionListener)this);
        this.refresh();
    }

    protected void postContentCreate() {
        super.postContentCreate();
        this.refresh();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void dispose() {
        this.session.removeListener((SessionListener)this);
        super.dispose();
    }

    public void notificationHandler(SessionNotification n) {
        if (n.getCode() == 1050) {
            this.getDisplay().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        } else if (n.getCode() == 1051) {
            this.getDisplay().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void createActions() {
        this.actionNew = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+N", (IAction)this.actionNew);
        this.actionEdit = new /* Unavailable Anonymous Inner Class!! */;
        this.actionDelete = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+D", (IAction)this.actionDelete);
        this.actionImport = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+I", (IAction)this.actionImport);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionNew);
        manager.add((IAction)this.actionImport);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionNew);
        manager.add((IAction)this.actionImport);
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        mgr.add((IAction)this.actionNew);
        mgr.add((IAction)this.actionImport);
        mgr.add((IAction)this.actionEdit);
        mgr.add((IAction)this.actionDelete);
    }

    private void createArea() {
        GeoAreaEditDialog dlg = new GeoAreaEditDialog(this.getWindow().getShell(), null);
        if (dlg.open() == 0) {
            this.updateArea(dlg.getArea());
        }
    }

    private void editArea() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        GeoAreaEditDialog dlg = new GeoAreaEditDialog(this.getWindow().getShell(), (GeoArea)selection.getFirstElement());
        if (dlg.open() == 0) {
            this.updateArea(dlg.getArea());
        }
    }

    private void updateArea(GeoArea area) {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void deleteAreas() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!MessageDialogHelper.openQuestion((Shell)this.getWindow().getShell(), (String)i18n.tr("Delete Geographical Areas"), (String)i18n.tr("Selected geographical areas will be deleted. Are you sure?"))) {
            return;
        }
        int[] idList = new int[selection.size()];
        int index = 0;
        for (Object o : selection.toList()) {
            idList[index++] = ((GeoArea)o).getId();
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public void refresh() {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void updateAreaDetails(GeoArea area) {
        if (area != null) {
            this.coordinateListViewer.setInput((Object)area.getBorder());
        } else {
            this.coordinateListViewer.setInput((Object)new Object[0]);
        }
        this.mapViewer.setArea(area);
    }

    private void importAreas() {
        FileDialog dlg = new FileDialog(this.getWindow().getShell(), 4096);
        WidgetHelper.setFileDialogFilterExtensions((FileDialog)dlg, (String[])new String[]{"*.kml", "*.*"});
        WidgetHelper.setFileDialogFilterNames((FileDialog)dlg, (String[])new String[]{"KML files", "All files"});
        String fileName = dlg.open();
        if (fileName == null) {
            return;
        }
        File file = new File(fileName);
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void validateImportedAreas(Map<String, List<GeoLocation>> importedAreas) {
        HashSet<String> skipSet = new HashSet<String>();
        ArrayList<GeoArea> replaceList = new ArrayList<GeoArea>();
        for (String n : importedAreas.keySet()) {
            for (GeoArea a : this.areas.values()) {
                if (!a.getName().equalsIgnoreCase(n)) continue;
                if (MessageDialogHelper.openQuestion((Shell)this.getWindow().getShell(), (String)i18n.tr("Override Geographical Area"), (String)String.format(i18n.tr("Geographical area with name \"%s\" already exist. Do you want to override it's content?"), a.getName()))) {
                    replaceList.add(new GeoArea(a.getId(), a.getName(), a.getComments(), importedAreas.get(n)));
                }
                skipSet.add(n);
            }
        }
        for (String n : skipSet) {
            importedAreas.remove(n);
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public boolean isModified() {
        return false;
    }

    public void save() {
    }
}

