/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.tools;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.netxms.base.InetAddressEx;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.tools.TextFieldValidator;
import org.xnap.commons.i18n.I18n;

public class IPNetMaskValidator
implements TextFieldValidator {
    private static final String IP_ADDRESS_PATTERN = "^([0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}|[A-Fa-f0-9:]+)$";
    private I18n i18n = LocalizationHelper.getI18n(IPNetMaskValidator.class);
    private boolean allowEmpty;
    private int maxBits;

    public IPNetMaskValidator(boolean allowEmpty, String ipAddress) {
        this.allowEmpty = allowEmpty;
        if (ipAddress.isEmpty()) {
            this.maxBits = 32;
        } else {
            try {
                this.maxBits = InetAddress.getByName(ipAddress) instanceof Inet4Address ? 32 : 128;
            }
            catch (UnknownHostException e) {
                this.maxBits = 32;
            }
        }
    }

    public boolean validate(String text) {
        if (this.allowEmpty && text.trim().isEmpty()) {
            return true;
        }
        if (!text.matches(IP_ADDRESS_PATTERN)) {
            return false;
        }
        if (text.length() <= 2) {
            try {
                int bits = Integer.parseInt(text);
                return bits >= 0 && bits < this.maxBits;
            }
            catch (NumberFormatException bits) {
                // empty catch block
            }
        }
        try {
            InetAddress mask = InetAddress.getByName(text);
            byte[] bytes = mask.getAddress();
            boolean state = false;
            for (int i = 0; i < bytes.length; ++i) {
                if (bytes[i] == -1) continue;
                if (state && bytes[i] != 0) {
                    return false;
                }
                if (bytes[i] != 0 && bytes[i] != -128 && bytes[i] != -64 && bytes[i] != -32 && bytes[i] != -16 && bytes[i] != -8 && bytes[i] != -4 && bytes[i] != -2) {
                    return false;
                }
                state = true;
            }
            int bits = InetAddressEx.bitsInMask((InetAddress)mask);
            return bits >= 0 && bits < this.maxBits;
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    public String getErrorMessage(String text, String label) {
        return String.format(this.i18n.tr("Please enter valid IP network mask in \"%s\" field"), label);
    }
}

