/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.datacollection.ChartDciConfig;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.widgets.DciSelector;
import org.netxms.ui.eclipse.datacollection.widgets.TemplateDciSelector;
import org.netxms.ui.eclipse.tools.ColorConverter;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.ExtendedColorSelector;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class DataSourceEditDlg
extends Dialog {
    private ChartDciConfig dci;
    private DciSelector dciSelector;
    private LabeledText name;
    private LabeledText displayFormat;
    private TemplateDciSelector dciName;
    private TemplateDciSelector dciDescription;
    private ExtendedColorSelector colorSelector;
    private Combo displayType;
    private Button checkShowThresholds;
    private Button checkInvertValues;
    private Button checkRawValues;
    private Button checkMultipeMatch;
    private LabeledText instance;
    private LabeledText dataColumn;
    private boolean isTemplate;

    public DataSourceEditDlg(Shell parentShell, ChartDciConfig dci, boolean isTemplate) {
        super(parentShell);
        this.dci = dci;
        this.isTemplate = isTemplate;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        Messages.get();
        newShell.setText(Messages.DataSourceEditDlg_ShellTitle);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        GridData gd = new GridData();
        if (!this.isTemplate) {
            this.dciSelector = new DciSelector(dialogArea, 0);
            Messages.get();
            this.dciSelector.setLabel(Messages.DataSourceEditDlg_DCI);
            this.dciSelector.setDciId(this.dci.nodeId, this.dci.dciId);
            this.dciSelector.setDcObjectType(this.dci.type);
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            gd.widthHint = 400;
            gd.horizontalSpan = 2;
            this.dciSelector.setLayoutData(gd);
        }
        this.name = new LabeledText(dialogArea, 0);
        Messages.get();
        this.name.setLabel(Messages.DataSourceEditDlg_DispName);
        this.name.setText(this.dci.name);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.name.setLayoutData((Object)gd);
        this.displayFormat = new LabeledText(dialogArea, 0);
        Messages.get();
        this.displayFormat.setLabel(Messages.DataSourceEditDlg_DisplayFormat);
        this.displayFormat.setText(this.dci.displayFormat);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.displayFormat.setLayoutData((Object)gd);
        if (this.isTemplate) {
            this.dciName = new TemplateDciSelector(dialogArea, 0);
            this.dciName.setLabel("DCI Name");
            this.dciName.setText(this.dci.dciName);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            this.dciName.setLayoutData(gd);
            this.dciDescription = new TemplateDciSelector(dialogArea, 0);
            this.dciDescription.setLabel("DCI Description");
            this.dciDescription.setText(this.dci.dciDescription);
            this.dciDescription.setSelectDescription(true);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            this.dciDescription.setLayoutData(gd);
        }
        if (this.dci.type == 2) {
            Group tableGroup = new Group(dialogArea, 0);
            Messages.get();
            tableGroup.setText(Messages.DataSourceEditDlg_TableCell);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            tableGroup.setLayoutData((Object)gd);
            layout = new GridLayout();
            tableGroup.setLayout((Layout)layout);
            this.dataColumn = new LabeledText((Composite)tableGroup, 0);
            Messages.get();
            this.dataColumn.setLabel(Messages.DataSourceEditDlg_DataColumn);
            this.dataColumn.setText(this.dci.column);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.dataColumn.setLayoutData((Object)gd);
            this.instance = new LabeledText((Composite)tableGroup, 0);
            Messages.get();
            this.instance.setLabel(Messages.DataSourceEditDlg_Instance);
            this.instance.setText(this.dci.instance);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.instance.setLayoutData((Object)gd);
        }
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 128;
        this.displayType = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)2056, (String)"Display type", (Object)gd);
        this.displayType.add("Default");
        this.displayType.add("Line");
        this.displayType.add("Area");
        this.displayType.select(this.dci.getLineChartType() + 1);
        Group optionsGroup = new Group(dialogArea, 0);
        Messages.get();
        optionsGroup.setText(Messages.DataSourceEditDlg_Options);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 128;
        gd.verticalSpan = 2;
        optionsGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        optionsGroup.setLayout((Layout)layout);
        this.checkShowThresholds = new Button((Composite)optionsGroup, 32);
        Messages.get();
        this.checkShowThresholds.setText(Messages.DataSourceEditDlg_ShowThresholds);
        this.checkShowThresholds.setSelection(this.dci.showThresholds);
        this.checkInvertValues = new Button((Composite)optionsGroup, 32);
        Messages.get();
        this.checkInvertValues.setText(Messages.DataSourceEditDlg_InvertValues);
        this.checkInvertValues.setSelection(this.dci.invertValues);
        this.checkRawValues = new Button((Composite)optionsGroup, 32);
        this.checkRawValues.setText("Raw values");
        this.checkRawValues.setSelection(this.dci.useRawValues);
        if (this.isTemplate) {
            this.checkMultipeMatch = new Button((Composite)optionsGroup, 32);
            this.checkMultipeMatch.setText("Multiple match");
            this.checkMultipeMatch.setSelection(this.dci.multiMatch);
        }
        this.colorSelector = new ExtendedColorSelector(dialogArea);
        Messages.get();
        Messages.get();
        Messages.get();
        this.colorSelector.setLabels(Messages.DataSourceEditDlg_Color, Messages.DataSourceEditDlg_AutoColor, Messages.DataSourceEditDlg_CustomColor);
        this.colorSelector.setColorValue(this.dci.color.equalsIgnoreCase("UNSET") ? null : ColorConverter.rgbFromInt((int)this.dci.getColorAsInt()));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        this.colorSelector.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void okPressed() {
        if (this.isTemplate) {
            this.dci.dciName = this.dciName.getText();
            this.dci.dciDescription = this.dciDescription.getText();
            this.dci.multiMatch = this.checkMultipeMatch.getSelection();
        } else {
            this.dci.nodeId = this.dciSelector.getNodeId();
            this.dci.dciId = this.dciSelector.getDciId();
        }
        this.dci.name = this.name.getText();
        this.dci.displayFormat = this.displayFormat.getText();
        RGB color = this.colorSelector.getColorValue();
        this.dci.color = color == null ? "UNSET" : "0x" + Integer.toHexString(ColorConverter.rgbToInt((RGB)color));
        this.dci.lineChartType = this.displayType.getSelectionIndex() - 1;
        this.dci.showThresholds = this.checkShowThresholds.getSelection();
        this.dci.invertValues = this.checkInvertValues.getSelection();
        this.dci.useRawValues = this.checkRawValues.getSelection();
        if (this.dci.type == 2) {
            this.dci.column = this.dataColumn.getText().trim();
            this.dci.instance = this.instance.getText();
        }
        super.okPressed();
    }
}

