/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.filemanager.dialogs;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.server.ServerFile;
import org.netxms.ui.eclipse.filemanager.Messages;
import org.netxms.ui.eclipse.filemanager.dialogs.helpers.ServerFileComparator;
import org.netxms.ui.eclipse.filemanager.dialogs.helpers.ServerFileLabelProvider;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class SelectServerFileDialog
extends Dialog {
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_SIZE = 1;
    public static final int COLUMN_MODTIME = 2;
    private SortableTableViewer viewer;
    private ServerFile[] selectedFiles;
    private boolean multiSelect;

    public SelectServerFileDialog(Shell parentShell, boolean multiSelect) {
        super(parentShell);
        this.multiSelect = multiSelect;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        Messages.get();
        newShell.setText(Messages.SelectServerFileDialog_Title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        dialogArea.setLayout((Layout)layout);
        String[] stringArray = new String[3];
        Messages.get();
        stringArray[0] = Messages.SelectServerFileDialog_ColName;
        Messages.get();
        stringArray[1] = Messages.SelectServerFileDialog_ColSize;
        Messages.get();
        stringArray[2] = Messages.SelectServerFileDialog_ColModTime;
        String[] names = stringArray;
        int[] widths = new int[]{200, 100, 150};
        this.viewer = new SortableTableViewer(dialogArea, names, widths, 0, 1024, 0x10800 | (this.multiSelect ? 2 : 0));
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ServerFileLabelProvider());
        this.viewer.setComparator((ViewerComparator)new ServerFileComparator());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 450;
        this.viewer.getControl().setLayoutData((Object)gd);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SelectServerFileDialog.this.okPressed();
            }
        });
        final NXCSession session = ConsoleSharedData.getSession();
        Messages.get();
        new ConsoleJob(Messages.SelectServerFileDialog_JobTitle, null, "org.netxms.ui.eclipse.filemanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final ServerFile[] files = session.listServerFiles();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).SelectServerFileDialog.this.viewer.setInput((Object)files);
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.SelectServerFileDialog_JobError;
            }
        }.start();
        return dialogArea;
    }

    protected void okPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            Shell shell = this.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openWarning((Shell)shell, (String)Messages.SelectServerFileDialog_Warning, (String)Messages.SelectServerFileDialog_WarningText);
            return;
        }
        List list = selection.toList();
        this.selectedFiles = list.toArray(new ServerFile[list.size()]);
        super.okPressed();
    }

    public ServerFile[] getSelectedFiles() {
        return this.selectedFiles;
    }
}

