/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.slm.objecttabs.helpers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.client.NXCSession;
import org.netxms.client.businessservices.BusinessServiceCheck;
import org.netxms.client.constants.BusinessServiceCheckType;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.interfaces.NodeChild;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class BusinessServiceCheckLabelProvider
extends LabelProvider
implements ITableLabelProvider,
ITableColorProvider {
    private static final String[] TYPES = new String[]{"None", "Script", "DCI threshold", "Object status"};
    private NXCSession session = ConsoleSharedData.getSession();
    private Map<Long, String> dciNameCache = new HashMap<Long, String>();
    private WorkbenchLabelProvider objectLabelProvider = new WorkbenchLabelProvider();

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex != 3) {
            return null;
        }
        BusinessServiceCheck check = (BusinessServiceCheck)element;
        AbstractObject object = this.session.findObjectById(check.getObjectId());
        return object != null ? this.objectLabelProvider.getImage((Object)object) : null;
    }

    public String getColumnText(Object element, int columnIndex) {
        BusinessServiceCheck check = (BusinessServiceCheck)element;
        switch (columnIndex) {
            case 0: {
                return Long.toString(check.getId());
            }
            case 1: {
                return check.getDescription();
            }
            case 2: {
                return this.getTypeName(check);
            }
            case 3: {
                return this.getObjectName(check);
            }
            case 4: {
                return this.getDciName(check);
            }
            case 5: {
                return this.getCheckStateText(check);
            }
            case 6: {
                return check.getFailureReason();
            }
            case 7: {
                return this.getOriginName(check);
            }
        }
        return null;
    }

    public String getCheckStateText(BusinessServiceCheck check) {
        switch (check.getState()) {
            case OPERATIONAL: {
                return "OK";
            }
            case DEGRADED: {
                return "Degraded";
            }
            case FAILED: {
                return "Failed";
            }
        }
        return null;
    }

    public String getObjectName(BusinessServiceCheck check) {
        if (check.getObjectId() == 0L) {
            return "";
        }
        StringBuilder name = new StringBuilder();
        AbstractObject object = this.session.findObjectById(check.getObjectId());
        if (object != null) {
            name.append(object.getObjectName());
            if (object instanceof NodeChild) {
                name.append(" @ ");
                AbstractNode node = ((NodeChild)object).getParentNode();
                name.append(node.getObjectName());
            }
        } else {
            name.append("[");
            name.append(Long.toString(check.getObjectId()));
            name.append("]");
        }
        return name.toString();
    }

    public String getOriginName(BusinessServiceCheck check) {
        if (check.getPrototypeServiceId() == 0L) {
            return "";
        }
        StringBuilder name = new StringBuilder();
        AbstractObject object = this.session.findObjectById(check.getPrototypeServiceId());
        if (object != null) {
            name.append(object.getObjectName());
        } else {
            name.append("[");
            name.append(Long.toString(check.getObjectId()));
            name.append("]");
        }
        return name.toString();
    }

    public String getDciName(BusinessServiceCheck check) {
        if (check.getCheckType() != BusinessServiceCheckType.DCI || check.getDciId() == 0L) {
            return "";
        }
        String name = this.dciNameCache.get(check.getDciId());
        return name != null ? name : "[" + Long.toString(check.getDciId()) + "]";
    }

    public String getTypeName(BusinessServiceCheck check) {
        return TYPES[check.getCheckType().getValue()];
    }

    public Color getForeground(Object element, int columnIndex) {
        if (columnIndex != 5) {
            return null;
        }
        switch (((BusinessServiceCheck)element).getState()) {
            case OPERATIONAL: {
                return StatusDisplayInfo.getStatusColor((ObjectStatus)ObjectStatus.NORMAL);
            }
            case DEGRADED: {
                return StatusDisplayInfo.getStatusColor((ObjectStatus)ObjectStatus.MINOR);
            }
            case FAILED: {
                return StatusDisplayInfo.getStatusColor((ObjectStatus)ObjectStatus.CRITICAL);
            }
        }
        return null;
    }

    public Color getBackground(Object element, int columnIndex) {
        return null;
    }

    public void updateDciNames(Map<Long, String> names) {
        this.dciNameCache.putAll(names);
    }

    public void dispose() {
        this.objectLabelProvider.dispose();
        super.dispose();
    }
}

