/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.dialogs;

import java.net.Inet4Address;
import java.net.InetAddress;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.base.InetAddressEx;
import org.netxms.ui.eclipse.tools.IPAddressValidator;
import org.netxms.ui.eclipse.tools.IPNetMaskValidator;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.TextFieldValidator;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class CreateSubnetDialog
extends Dialog {
    private String objectName = "";
    private String objectAlias = "";
    private InetAddressEx ipAddress;
    private LabeledText objectNameText;
    private LabeledText objectAliasText;
    private LabeledText ipAddressText;
    private LabeledText maskText;

    public CreateSubnetDialog(Shell shell) {
        super(shell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Create Subnet");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 5;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        dialogArea.setLayout((Layout)layout);
        this.objectNameText = new LabeledText(dialogArea, 0);
        this.objectNameText.setLabel("Name (leave empty to construct from address and mask)");
        this.objectNameText.getTextControl().setTextLimit(255);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 600;
        gd.horizontalSpan = 2;
        this.objectNameText.setLayoutData((Object)gd);
        this.objectNameText.setText(this.objectName);
        this.objectAliasText = new LabeledText(dialogArea, 0);
        this.objectAliasText.setLabel("Alias");
        this.objectAliasText.getTextControl().setTextLimit(255);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.objectAliasText.setLayoutData((Object)gd);
        this.objectAliasText.setText(this.objectAlias);
        this.ipAddressText = new LabeledText(dialogArea, 0);
        this.ipAddressText.setLabel("IP address");
        this.ipAddressText.getTextControl().setTextLimit(64);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.ipAddressText.setLayoutData((Object)gd);
        this.ipAddressText.setText("");
        this.maskText = new LabeledText(dialogArea, 0);
        this.maskText.setLabel("Network mask");
        this.maskText.getTextControl().setTextLimit(16);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.maskText.setLayoutData((Object)gd);
        this.maskText.setText("");
        return dialogArea;
    }

    protected void okPressed() {
        if (!WidgetHelper.validateTextInput((LabeledText)this.ipAddressText, (TextFieldValidator)new IPAddressValidator(false), null) || !WidgetHelper.validateTextInput((LabeledText)this.maskText, (TextFieldValidator)new IPNetMaskValidator(false, this.ipAddressText.getText()), null)) {
            return;
        }
        try {
            int maskBits;
            this.objectName = this.objectNameText.getText().trim();
            this.objectAlias = this.objectAliasText.getText().trim();
            InetAddress addr = InetAddress.getByName(this.ipAddressText.getText().trim());
            try {
                maskBits = Integer.parseInt(this.maskText.getText().trim());
            }
            catch (NumberFormatException e) {
                InetAddress mask = InetAddress.getByName(this.maskText.getText().trim());
                maskBits = InetAddressEx.bitsInMask((InetAddress)mask);
            }
            if (maskBits > (addr instanceof Inet4Address ? 31 : 127)) {
                MessageDialogHelper.openError((Shell)this.getShell(), (String)"Invalid network mask", (String)"Please enter valid network mask");
                return;
            }
            this.ipAddress = new InetAddressEx(addr, maskBits);
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)String.format("Internal error: %s", e.getMessage()));
            return;
        }
        super.okPressed();
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getObjectAlias() {
        return this.objectAlias;
    }

    public InetAddressEx getIpAddress() {
        return this.ipAddress;
    }
}

