/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.propertypages;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.Dashboard;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.widgets.LabeledSpinner;

public class DashboardObjectContext
extends PropertyPage {
    private Dashboard object;
    private Button checkboxShowAsObjectView;
    private LabeledSpinner displayPriority;

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.object = (Dashboard)this.getElement().getAdapter(Dashboard.class);
        if (this.object == null) {
            return dialogArea;
        }
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.checkboxShowAsObjectView = new Button(dialogArea, 32);
        this.checkboxShowAsObjectView.setText("&Show this dashboard in object context");
        this.checkboxShowAsObjectView.setSelection((this.object.getFlags() & 0x10000) != 0);
        this.checkboxShowAsObjectView.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.displayPriority = new LabeledSpinner(dialogArea, 0);
        this.displayPriority.setLabel("Display priority (1-65535, 0 for automatic)");
        this.displayPriority.setRange(0, 65535);
        this.displayPriority.setSelection(this.object.getDisplayPriority());
        this.displayPriority.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        return dialogArea;
    }

    protected void applyChanges(final boolean isApply) {
        if (isApply) {
            this.setValid(false);
        }
        final NXCObjectModificationData md = new NXCObjectModificationData(this.object.getObjectId());
        md.setObjectFlags(this.checkboxShowAsObjectView.getSelection() ? 65536 : 0, 65536);
        md.setDisplayPriority(Integer.valueOf(this.displayPriority.getSelection()));
        final NXCSession session = ConsoleSharedData.getSession();
        new ConsoleJob("Updating dashboard object context configuration", null, "org.netxms.ui.eclipse.dashboard"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(md);
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            DashboardObjectContext.this.setValid(true);
                        }
                    });
                }
            }

            protected String getErrorMessage() {
                return "Cannot update dashboard object context configuration";
            }
        }.start();
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }
}

