/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.charts.widgets;

import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.Severity;
import org.netxms.client.datacollection.ChartConfiguration;
import org.netxms.client.datacollection.DataFormatter;
import org.netxms.client.datacollection.DciDataRow;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.client.datacollection.Threshold;
import org.netxms.client.events.EventTemplate;
import org.netxms.ui.eclipse.charts.Activator;
import org.netxms.ui.eclipse.charts.Messages;
import org.netxms.ui.eclipse.charts.api.ChartColor;
import org.netxms.ui.eclipse.charts.api.DataPoint;
import org.netxms.ui.eclipse.charts.widgets.Chart;
import org.netxms.ui.eclipse.charts.widgets.PlotArea;
import org.netxms.ui.eclipse.charts.widgets.internal.SelectionRectangle;
import org.netxms.ui.eclipse.console.resources.RegionalSettings;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.ColorCache;
import org.netxms.ui.eclipse.tools.ColorConverter;
import org.swtchart.IAxis;
import org.swtchart.IAxisSet;
import org.swtchart.IAxisTick;
import org.swtchart.ICustomPaintListener;
import org.swtchart.ILineSeries;
import org.swtchart.IPlotArea;
import org.swtchart.ISeries;
import org.swtchart.ISeriesSet;
import org.swtchart.LineStyle;
import org.swtchart.Range;

public class LineChart
extends org.swtchart.Chart
implements PlotArea {
    private static final int MAX_ZOOM_LEVEL = 16;
    private Chart chart;
    private ChartConfiguration configuration;
    private ColorCache colorCache;
    private IPreferenceStore preferenceStore;
    private long timeFrom;
    private long timeTo;
    private boolean showToolTips;
    private boolean selectionActive = false;
    private int zoomLevel = 0;
    private MouseMoveListener moveListener;
    private SelectionRectangle selection = new SelectionRectangle();
    private MouseListener zoomMouseListener = null;
    private PaintListener zoomPaintListener = null;
    private boolean tooltipShown = false;
    private boolean zoomedToSelectionX = false;
    private boolean zoomedToSelectionY = false;
    private Date delayedRangeFrom;
    private Date delayedRangeTo;

    public LineChart(Chart parent) {
        super((Composite)parent, 0);
        this.chart = parent;
        this.configuration = this.chart.getConfiguration();
        this.colorCache = this.chart.getColorCache();
        this.preferenceStore = Activator.getDefault().getPreferenceStore();
        this.showToolTips = this.preferenceStore.getBoolean("Chart.ShowToolTips");
        this.setBackground(parent.getBackground());
        this.selection.setColor(this.getColorFromPreferences("Chart.Colors.Selection"));
        this.getTitle().setVisible(false);
        this.getLegend().setVisible(false);
        this.setTranslucent(this.configuration.isTranslucent());
        this.timeTo = System.currentTimeMillis();
        this.timeFrom = this.timeTo - 3600000L;
        IAxisSet axisSet = this.getAxisSet();
        final IAxis xAxis = axisSet.getXAxis(0);
        xAxis.getTitle().setVisible(false);
        xAxis.setRange(new Range((double)this.timeFrom, (double)this.timeTo));
        IAxisTick xTick = xAxis.getTick();
        xTick.setForeground(this.getColorFromPreferences("Chart.Axis.X.Color"));
        Messages.get();
        SimpleDateFormat format = new SimpleDateFormat(Messages.LineChart_ShortTimeFormat);
        xTick.setFormat((Format)format);
        xTick.setFont(Activator.getDefault().getChartFont());
        final IAxis yAxis = axisSet.getYAxis(0);
        yAxis.getTitle().setVisible(false);
        yAxis.getTick().setForeground(this.getColorFromPreferences("Chart.Axis.Y.Color"));
        yAxis.getTick().setFont(Activator.getDefault().getChartFont());
        yAxis.enableLogScale(this.configuration.isLogScale());
        if (!this.configuration.isAutoScale()) {
            yAxis.setRange(new Range(this.configuration.getMinYScaleValue(), this.configuration.getMaxYScaleValue()));
        }
        xAxis.getGrid().setStyle(this.getLineStyleFromPreferences("Chart.Grid.X.Style"));
        xAxis.getGrid().setForeground(this.getColorFromPreferences("Chart.Grid.X.Color"));
        yAxis.getGrid().setStyle(this.getLineStyleFromPreferences("Chart.Grid.Y.Style"));
        yAxis.getGrid().setForeground(this.getColorFromPreferences("Chart.Grid.Y.Color"));
        this.setGridVisible(this.configuration.isGridVisible());
        this.setBackgroundInPlotArea(this.getColorFromPreferences("Chart.Colors.PlotArea"));
        Canvas plotArea = this.getPlotArea();
        if (this.showToolTips) {
            plotArea.addMouseTrackListener(new MouseTrackListener(){

                public void mouseEnter(MouseEvent e) {
                }

                public void mouseExit(MouseEvent e) {
                    if (LineChart.this.tooltipShown) {
                        LineChart.this.getPlotArea().setToolTipText(null);
                        LineChart.this.tooltipShown = false;
                    }
                }

                public void mouseHover(MouseEvent e) {
                    ISeries series = LineChart.this.getSeriesAtPoint(e.x, e.y);
                    if (series != null) {
                        Date timestamp = new Date((long)xAxis.getDataCoordinate(e.x));
                        double value = yAxis.getDataCoordinate(e.y);
                        LineChart.this.getPlotArea().setToolTipText(String.valueOf(series.getName()) + "\n" + RegionalSettings.getDateTimeFormat().format(timestamp) + "\n" + (LineChart.this.useMultipliers ? DataFormatter.roundDecimalValue((double)value, (double)LineChart.this.cachedTickStep, (int)5) : Double.toString(value)));
                        LineChart.this.tooltipShown = true;
                    }
                }
            });
            plotArea.addMouseMoveListener(new MouseMoveListener((Composite)plotArea){
                private final /* synthetic */ Composite val$plotArea;
                {
                    this.val$plotArea = composite;
                }

                public void mouseMove(MouseEvent e) {
                    if (LineChart.this.tooltipShown) {
                        this.val$plotArea.setToolTipText(null);
                        LineChart.this.tooltipShown = false;
                    }
                }
            });
        }
        plotArea.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                LineChart.this.chart.fireDoubleClickListeners();
            }
        });
        this.zoomMouseListener = new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (e.button == 1) {
                    LineChart.this.startSelection(e);
                }
            }

            public void mouseUp(MouseEvent e) {
                if (e.button == 1) {
                    LineChart.this.endSelection();
                }
            }
        };
        this.zoomPaintListener = new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (LineChart.this.selectionActive) {
                    LineChart.this.selection.draw(e.gc);
                }
            }
        };
        this.setZoomEnabled(this.configuration.isZoomEnabled());
        ((IPlotArea)plotArea).addCustomPaintListener(new ICustomPaintListener(){

            public void paintControl(PaintEvent e) {
                LineChart.this.paintThresholds(e, yAxis);
            }

            public boolean drawBehindSeries() {
                return true;
            }
        });
    }

    private void startSelection(MouseEvent e) {
        if (this.zoomLevel >= 16) {
            return;
        }
        this.selectionActive = true;
        this.selection.setStartPoint(e.x, e.y);
        this.selection.setEndPoint(e.x, e.y);
        Canvas plotArea = this.getPlotArea();
        this.moveListener = new MouseMoveListener((Composite)plotArea){
            private final /* synthetic */ Composite val$plotArea;
            {
                this.val$plotArea = composite;
            }

            public void mouseMove(MouseEvent e) {
                LineChart.this.selection.setEndPoint(e.x, e.y);
                this.val$plotArea.redraw();
            }
        };
        plotArea.addMouseMoveListener(this.moveListener);
    }

    private void endSelection() {
        if (!this.selectionActive) {
            return;
        }
        this.selectionActive = false;
        Canvas plotArea = this.getPlotArea();
        plotArea.removeMouseMoveListener(this.moveListener);
        if (this.selection.isUsableSize()) {
            IAxis[] iAxisArray = this.getAxisSet().getAxes();
            int n = iAxisArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAxis axis = iAxisArray[n2];
                Point range = null;
                range = this.getOrientation() == 256 && axis.getDirection() == IAxis.Direction.X || this.getOrientation() == 512 && axis.getDirection() == IAxis.Direction.Y ? this.selection.getHorizontalRange() : this.selection.getVerticalRange();
                if (range != null && range.x != range.y) {
                    this.setRange(range, axis);
                }
                ++n2;
            }
            this.zoomedToSelectionX = true;
            this.zoomedToSelectionY = true;
        }
        this.selection.dispose();
        this.redraw();
    }

    private void setRange(Point range, IAxis axis) {
        double min = axis.getDataCoordinate(range.x);
        double max = axis.getDataCoordinate(range.y);
        axis.setRange(new Range(min, max));
    }

    private Color getColorFromPreferences(String name) {
        return this.colorCache.create(PreferenceConverter.getColor((IPreferenceStore)this.preferenceStore, (String)name));
    }

    private LineStyle getLineStyleFromPreferences(String name) {
        String value = this.preferenceStore.getString(name);
        LineStyle[] lineStyleArray = LineStyle.values();
        int n = lineStyleArray.length;
        int n2 = 0;
        while (n2 < n) {
            LineStyle s = lineStyleArray[n2];
            if (s.label.equalsIgnoreCase(value)) {
                return s;
            }
            ++n2;
        }
        return LineStyle.NONE;
    }

    private ILineSeries addLineSeries(int index, String description, Date[] xSeries, double[] ySeries) {
        ISeriesSet seriesSet = this.getSeriesSet();
        ILineSeries series = (ILineSeries)seriesSet.createSeries(ISeries.SeriesType.LINE, Integer.toString(index), false);
        series.setName(description);
        series.setSymbolType(ILineSeries.PlotSymbolType.NONE);
        series.setLineWidth(this.configuration.getLineWidth());
        series.setLineColor(this.getColorFromPreferences("Chart.Colors.Data." + index));
        series.setXDateSeries(xSeries);
        series.setYSeries(ySeries);
        try {
            series.enableStack(this.configuration.isStacked(), false);
        }
        catch (IllegalStateException e) {
            Activator.logError("Exception while adding chart series", e);
        }
        return series;
    }

    public void setTimeRange(Date from, Date to) {
        int angle;
        String formatString;
        if (this.zoomedToSelectionX) {
            this.delayedRangeFrom = from;
            this.delayedRangeTo = to;
            return;
        }
        this.delayedRangeFrom = null;
        this.delayedRangeTo = null;
        this.timeFrom = from.getTime();
        this.timeTo = to.getTime();
        this.getAxisSet().getXAxis(0).setRange(new Range((double)this.timeFrom, (double)this.timeTo));
        int seconds = (int)((this.timeTo - this.timeFrom) / 1000L);
        if (seconds <= 600) {
            Messages.get();
            formatString = Messages.LineChart_MediumTimeFormat;
            angle = 0;
        } else if (seconds <= 86400) {
            Messages.get();
            formatString = Messages.LineChart_ShortTimeFormat;
            angle = 0;
        } else if (seconds <= 604800) {
            Messages.get();
            formatString = Messages.LineChart_Medium2TimeFormat;
            angle = 0;
        } else {
            Messages.get();
            formatString = Messages.LineChart_LongTimeFormat;
            angle = 45;
        }
        IAxisTick xTick = this.getAxisSet().getXAxis(0).getTick();
        SimpleDateFormat format = new SimpleDateFormat(formatString);
        xTick.setFormat((Format)format);
        xTick.setTickLabelAngle(angle);
    }

    private void paintThresholds(PaintEvent e, IAxis axis) {
        GC gc = e.gc;
        Rectangle clientArea = this.getPlotArea().getClientArea();
        NXCSession session = ConsoleSharedData.getSession();
        List<GraphItem> items = this.chart.getItems();
        int i = 0;
        while (i < items.size()) {
            Threshold[] tr = this.chart.getThreshold(i);
            if (items.get(i).isShowThresholds() && !this.configuration.isStacked() && tr != null) {
                int j = 0;
                while (j < tr.length) {
                    try {
                        int y = axis.getPixelCoordinate((double)Integer.parseInt(tr[j].getValue()));
                        EventTemplate event = session.findEventTemplateByCode((long)tr[j].getFireEvent());
                        gc.setForeground(StatusDisplayInfo.getStatusColor((Severity)event.getSeverity()));
                        gc.setLineStyle(3);
                        gc.setLineWidth(3);
                        gc.drawLine(0, y, clientArea.width, y);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    @Override
    public void refresh() {
        List<GraphItem> items = this.chart.getItems();
        int i = 0;
        while (i < items.size()) {
            this.updateSeries(i, items.get(i));
            ++i;
        }
        this.updateLayout();
        this.updateStackAndRiserData();
        if (this.configuration.isAutoScale() && !this.zoomedToSelectionY) {
            this.adjustYAxis(true);
        } else {
            this.redraw();
        }
    }

    private void updateSeries(int index, GraphItem item) {
        DciDataRow[] values = this.chart.getDataSeries().get(index).getValues();
        Date[] xSeries = new Date[values.length];
        double[] ySeries = new double[values.length];
        int i = 0;
        while (i < values.length) {
            xSeries[i] = values[i].getTimestamp();
            ySeries[i] = values[i].getValueAsDouble();
            ++i;
        }
        ILineSeries series = this.addLineSeries(index, item.getDescription(), xSeries, ySeries);
        if (item.getColor() != -1) {
            series.setLineColor(ColorConverter.colorFromInt((int)item.getColor(), (ColorCache)this.colorCache));
        }
        series.enableArea(item.isArea(this.configuration.isArea()));
        series.setInverted(item.isInverted());
    }

    private void setZoomEnabled(boolean enableZoom) {
        Canvas plotArea = this.getPlotArea();
        if (enableZoom) {
            plotArea.addMouseListener(this.zoomMouseListener);
            plotArea.addPaintListener(this.zoomPaintListener);
        } else {
            plotArea.removeMouseListener(this.zoomMouseListener);
            plotArea.removePaintListener(this.zoomPaintListener);
        }
    }

    private static double adjustRange(double upper) {
        double adjustedUpper = upper;
        double d = 1.0E-5;
        while (d < 1.0E19) {
            if (upper > d && upper <= d * 10.0) {
                adjustedUpper -= adjustedUpper % d;
                adjustedUpper += d;
                break;
            }
            d *= 10.0;
        }
        return adjustedUpper;
    }

    private void setGridVisible(boolean visible) {
        LineStyle ls = visible ? LineStyle.DOT : LineStyle.NONE;
        this.getAxisSet().getXAxis(0).getGrid().setStyle(ls);
        this.getAxisSet().getYAxis(0).getGrid().setStyle(ls);
    }

    public void adjustXAxis(boolean repaint) {
        this.zoomedToSelectionX = false;
        if (this.delayedRangeFrom != null) {
            this.setTimeRange(this.delayedRangeFrom, this.delayedRangeTo);
        } else {
            IAxis[] iAxisArray = this.getAxisSet().getXAxes();
            int n = iAxisArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAxis axis = iAxisArray[n2];
                axis.adjustRange();
                ++n2;
            }
        }
        if (repaint) {
            this.redraw();
        }
    }

    public void adjustYAxis(boolean repaint) {
        this.zoomedToSelectionY = false;
        IAxis yAxis = this.getAxisSet().getYAxis(0);
        yAxis.adjustRange();
        Range range = yAxis.getRange();
        if (!this.configuration.isModifyYBase() && range.lower > 0.0) {
            range.lower = 0.0;
        } else if (range.lower < 0.0) {
            range.lower = -LineChart.adjustRange(Math.abs(range.lower));
        }
        range.upper = LineChart.adjustRange(range.upper);
        yAxis.setRange(range);
        if (repaint) {
            this.redraw();
        }
    }

    public void zoomIn() {
        this.getAxisSet().zoomIn();
        this.redraw();
    }

    public void zoomOut() {
        this.getAxisSet().zoomOut();
        this.redraw();
    }

    public void setAxisColor(ChartColor color) {
        Color c = this.colorCache.create(color.getRGBObject());
        this.getAxisSet().getXAxis(0).getTick().setForeground(c);
        this.getAxisSet().getYAxis(0).getTick().setForeground(c);
    }

    public void setGridColor(ChartColor color) {
        Color c = this.colorCache.create(color.getRGBObject());
        this.getAxisSet().getXAxis(0).getGrid().setForeground(c);
        this.getAxisSet().getYAxis(0).getGrid().setForeground(c);
    }

    public DataPoint getClosestDataPoint(int px, int py) {
        ISeries[] series;
        IAxis xAxis = this.getAxisSet().getXAxis(0);
        IAxis yAxis = this.getAxisSet().getYAxis(0);
        double x = xAxis.getDataCoordinate(px);
        double y = yAxis.getDataCoordinate(py);
        double closestX = 0.0;
        double closestY = 0.0;
        double minDist = Double.MAX_VALUE;
        ISeries closestSeries = null;
        ISeries[] iSeriesArray = series = this.getSeriesSet().getSeries();
        int n = series.length;
        int n2 = 0;
        while (n2 < n) {
            ISeries s = iSeriesArray[n2];
            double[] xS = s.getXSeries();
            double[] yS = s.getYSeries();
            int i = 0;
            while (i < xS.length) {
                double newDist = Math.sqrt(Math.pow(x - xS[i], 2.0) + Math.pow(y - yS[i], 2.0));
                if (newDist < minDist) {
                    minDist = newDist;
                    closestX = xS[i];
                    closestY = yS[i];
                    closestSeries = s;
                }
                ++i;
            }
            ++n2;
        }
        return closestSeries != null ? new DataPoint(new Date((long)closestX), closestY, closestSeries) : null;
    }

    public ISeries getSeriesAtPoint(int px, int py) {
        ISeries[] series;
        ISeries[] iSeriesArray = series = this.getSeriesSet().getSeries();
        int n = series.length;
        int n2 = 0;
        while (n2 < n) {
            ISeries s = iSeriesArray[n2];
            int size = s.getSize();
            int i = 1;
            while (i < size) {
                Point p1 = s.getPixelCoordinates(i - 1);
                Point p2 = s.getPixelCoordinates(i);
                if (px <= p1.x + 2 && px >= p2.x - 2 && py >= Math.min(p1.y, p2.y) - 2 && py <= Math.max(p1.y, p2.y) + 2 && LineChart.pointToLineDistance(px, py, p2, p1) <= (double)((ILineSeries)s).getLineWidth() * 3.0) {
                    return s;
                }
                ++i;
            }
            ++n2;
        }
        return null;
    }

    private static double pointToLineDistance(int x, int y, Point p1, Point p2) {
        int dx = p2.x - p1.x;
        int dy = p2.y - p1.y;
        double area2 = Math.abs(dy * x - dx * y + p2.x * p1.y - p2.y * p1.x);
        double dist = Math.sqrt(dx * dx + dy * dy);
        return area2 / dist;
    }
}

