/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.views;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.nxmc.base.views.NavigationView;
import org.netxms.nxmc.base.views.PerspectiveConfiguration;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.views.ViewFolder;
import org.netxms.nxmc.base.views.ViewFolderSelectionListener;
import org.netxms.nxmc.base.views.ViewStack;
import org.netxms.nxmc.base.views.helpers.NavigationHistory;
import org.netxms.nxmc.base.widgets.CompositeWithMessageArea;
import org.netxms.nxmc.base.widgets.MessageAreaHolder;
import org.netxms.nxmc.keyboard.KeyStroke;
import org.netxms.nxmc.tools.ImageCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Perspective {
    private static Logger logger = LoggerFactory.getLogger(Perspective.class);
    private String id;
    private String name;
    private Image image;
    private PerspectiveConfiguration configuration = new PerspectiveConfiguration();
    private Window window;
    private Composite content;
    private SashForm verticalSplitter;
    private SashForm horizontalSpliter;
    private ViewFolder navigationFolder;
    private ViewFolder mainFolder;
    private ViewFolder supplementaryFolder;
    private Composite headerArea;
    private ViewStack navigationArea;
    private ViewStack mainArea;
    private Composite supplementalArea;
    private MessageAreaHolder messageArea;
    private ISelectionProvider navigationSelectionProvider;
    private ISelectionChangedListener navigationSelectionListener;
    private ImageCache imageCache;

    protected Perspective(String id, String name, Image image) {
        this.id = id;
        this.name = name;
        this.image = image;
        this.navigationSelectionListener = new /* Unavailable Anonymous Inner Class!! */;
        this.configurePerspective(this.configuration);
        logger.debug("Perspective \"" + name + "\" configuration: " + this.configuration);
    }

    protected void configurePerspective(PerspectiveConfiguration configuration) {
    }

    protected void navigationSelectionChanged(IStructuredSelection selection) {
        this.setContext(selection.getFirstElement());
        if (this.configuration.enableNavigationHistory) {
            NavigationHistory navigationHistory;
            NavigationHistory navigationHistory2 = navigationHistory = this.navigationArea != null ? this.navigationArea.getNavigationHistory() : this.navigationFolder.getNavigationHistory();
            if (navigationHistory != null) {
                navigationHistory.add(selection.getFirstElement());
                if (this.navigationArea != null) {
                    this.navigationArea.updateNavigationControls();
                } else {
                    this.navigationFolder.updateNavigationControls();
                }
            }
        }
    }

    protected Object getContext() {
        if (this.mainFolder != null) {
            return this.mainFolder.getContext();
        }
        if (this.mainArea != null) {
            return this.mainArea.getContext();
        }
        return null;
    }

    protected void setContext(Object context) {
        if (this.mainFolder != null) {
            this.mainFolder.setContext(context);
        } else if (this.mainArea != null) {
            this.mainArea.setContext(context);
        }
    }

    protected void updateContext(Object context) {
        if (this.mainFolder != null) {
            this.mainFolder.updateContext(context);
        } else if (this.mainArea != null) {
            this.mainArea.updateContext(context);
        }
    }

    public void bindToWindow(Window window) {
        this.window = window;
    }

    public void hide() {
        if (this.content != null && !this.content.isDisposed()) {
            this.content.setVisible(false);
        }
    }

    public void show(Composite parent) {
        if (this.content == null || this.content.isDisposed()) {
            logger.debug("Creating content for perspective " + this.name);
            this.createWidgets(parent);
        } else {
            this.content.setVisible(true);
        }
        this.window.getShell().getDisplay().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public boolean isVisible() {
        return this.content != null && !this.content.isDisposed() && this.content.isVisible();
    }

    public void createWidgets(Composite parent) {
        View selectedView;
        this.content = new Composite(parent, 0);
        this.content.setLayout((Layout)new FillLayout());
        this.imageCache = new ImageCache((Control)this.content);
        if (this.configuration.hasNavigationArea) {
            this.verticalSplitter = new SashForm(this.content, 256);
            if (this.configuration.multiViewNavigationArea) {
                this.navigationFolder = new ViewFolder(this.window, this, (Composite)this.verticalSplitter, false, false, this.configuration.enableNavigationHistory);
                this.navigationFolder.addSelectionListener((ViewFolderSelectionListener)new /* Unavailable Anonymous Inner Class!! */);
                this.navigationFolder.setAllViewsAsCloseable(this.configuration.allViewsAreCloseable);
            } else {
                this.navigationArea = new ViewStack(this.window, this, (Composite)this.verticalSplitter, false, false, this.configuration.enableNavigationHistory);
            }
        }
        if (this.configuration.hasSupplementalArea) {
            this.horizontalSpliter = new SashForm((Composite)(this.configuration.hasNavigationArea ? this.verticalSplitter : this.content), 512);
        }
        CompositeWithMessageArea mainAreaHolder = new CompositeWithMessageArea((Composite)(this.configuration.hasSupplementalArea ? this.horizontalSpliter : (this.configuration.hasNavigationArea ? this.verticalSplitter : this.content)), 0);
        if (this.configuration.hasHeaderArea) {
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            mainAreaHolder.getContent().setLayout((Layout)layout);
            this.headerArea = new Composite(mainAreaHolder.getContent(), 0);
            GridData gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 0x1000000;
            gd.grabExcessHorizontalSpace = true;
            this.headerArea.setLayoutData((Object)gd);
            this.headerArea.setLayout((Layout)new FillLayout());
            this.createHeaderArea(this.headerArea);
        }
        this.messageArea = mainAreaHolder;
        if (this.configuration.multiViewMainArea) {
            this.mainFolder = new ViewFolder(this.window, this, mainAreaHolder.getContent(), this.configuration.enableViewExtraction, this.configuration.enableViewPinning, false);
            this.mainFolder.setAllViewsAsCloseable(this.configuration.allViewsAreCloseable);
            this.mainFolder.setUseGlobalViewId(this.configuration.useGlobalViewId);
            if (this.configuration.hasHeaderArea) {
                this.mainFolder.setLayoutData((Object)new GridData(4, 4, true, true));
            }
        } else {
            this.mainArea = new ViewStack(this.window, this, mainAreaHolder.getContent(), this.configuration.enableViewExtraction, this.configuration.enableViewPinning, false);
            if (this.configuration.hasHeaderArea) {
                this.mainArea.setLayoutData((Object)new GridData(4, 4, true, true));
            }
        }
        if (this.configuration.hasSupplementalArea) {
            if (this.configuration.multiViewSupplementalArea) {
                this.supplementaryFolder = new ViewFolder(this.window, this, (Composite)this.horizontalSpliter, this.configuration.enableViewExtraction, this.configuration.enableViewPinning, false);
                this.supplementaryFolder.setAllViewsAsCloseable(this.configuration.allViewsAreCloseable);
            } else {
                this.supplementalArea = new Composite((Composite)this.verticalSplitter, 0);
                this.supplementalArea.setLayout((Layout)new FillLayout());
                this.createSupplementalArea(this.supplementalArea);
            }
        }
        if (this.verticalSplitter != null) {
            this.verticalSplitter.setWeights(new int[]{25, 75});
        }
        if (this.horizontalSpliter != null) {
            this.horizontalSpliter.setWeights(new int[]{80, 20});
        }
        this.configureViews();
        if (this.navigationFolder != null && (selectedView = this.navigationFolder.getActiveView()) != null && selectedView instanceof NavigationView) {
            this.setNavigationSelectionProvider(((NavigationView)selectedView).getSelectionProvider());
        }
    }

    public void disposeWidgets() {
        if (!this.content.isDisposed()) {
            this.content.dispose();
        }
    }

    protected void createHeaderArea(Composite parent) {
    }

    protected void createSupplementalArea(Composite parent) {
    }

    protected void configureViews() {
    }

    public int getPriority() {
        return this.configuration.priority;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Image getImage() {
        return this.image;
    }

    public Window getWindow() {
        return this.window;
    }

    public MessageAreaHolder getMessageArea() {
        return this.messageArea;
    }

    protected ImageCache getImageCache() {
        return this.imageCache;
    }

    protected ISelectionProvider getNavigationSelectionProvider() {
        return this.navigationSelectionProvider;
    }

    protected void setNavigationSelectionProvider(ISelectionProvider navigationSelectionProvider) {
        if (this.navigationSelectionProvider != null) {
            this.navigationSelectionProvider.removeSelectionChangedListener(this.navigationSelectionListener);
        }
        this.navigationSelectionProvider = navigationSelectionProvider;
        if (navigationSelectionProvider != null) {
            navigationSelectionProvider.addSelectionChangedListener(this.navigationSelectionListener);
        }
    }

    public void addMainView(View view) {
        if (this.mainFolder != null) {
            this.mainFolder.addView(view);
        } else {
            this.mainArea.pushView(view);
        }
    }

    public void addMainView(View view, boolean activate, boolean ignoreContext) {
        if (this.mainFolder != null) {
            this.mainFolder.addView(view, activate, ignoreContext);
        } else {
            this.mainArea.pushView(view, activate);
        }
    }

    protected View getMainView() {
        return this.mainArea.getActiveView();
    }

    public void setMainView(View view) {
        this.mainArea.setView(view);
    }

    public View findMainView(String id) {
        return this.mainFolder != null ? this.mainFolder.findView(id) : null;
    }

    public void removeMainView(String id) {
        if (this.mainFolder != null) {
            this.mainFolder.removeView(id);
        }
    }

    public void addNavigationView(NavigationView view) {
        if (this.navigationFolder != null) {
            this.navigationFolder.addView((View)view);
        } else if (this.navigationArea != null) {
            this.navigationArea.pushView((View)view);
            this.setNavigationSelectionProvider(view != null && view instanceof NavigationView ? view.getSelectionProvider() : null);
        }
    }

    public void setNavigationView(NavigationView view) {
        if (this.navigationArea != null) {
            this.navigationArea.setView((View)view);
            this.setNavigationSelectionProvider(view != null && view instanceof NavigationView ? view.getSelectionProvider() : null);
        }
    }

    public View findNavigationView(String id) {
        return this.navigationFolder != null ? this.navigationFolder.findView(id) : null;
    }

    public void removeNavigationView(String id) {
        if (this.navigationFolder != null) {
            this.navigationFolder.removeView(id);
        }
    }

    public void addSupplementaryView(View view) {
        if (this.supplementaryFolder != null) {
            this.supplementaryFolder.addView(view);
        }
    }

    public View findSupplementaryView(String id) {
        return this.supplementaryFolder != null ? this.supplementaryFolder.findView(id) : null;
    }

    public void removeSupplementaryView(String id) {
        if (this.supplementaryFolder != null) {
            this.supplementaryFolder.removeView(id);
        }
    }

    public boolean updateViewTrim(View view) {
        boolean updated = false;
        if (this.mainFolder != null) {
            updated = this.mainFolder.updateViewTrim(view);
        }
        if (!updated && this.navigationFolder != null) {
            updated = this.navigationFolder.updateViewTrim(view);
        }
        if (!updated && this.supplementaryFolder != null) {
            updated = this.supplementaryFolder.updateViewTrim(view);
        }
        return updated;
    }

    public KeyStroke getKeyboardShortcut() {
        return this.configuration.keyboardShortcut;
    }

    public void processKeyStroke(KeyStroke ks) {
        ViewFolder activeViewStack = null;
        ViewStack activeViewContainer = null;
        for (Control c = this.content.getDisplay().getFocusControl(); c != null; c = c.getParent()) {
            if (c instanceof ViewFolder) {
                activeViewStack = (ViewFolder)c;
                break;
            }
            if (!(c instanceof ViewStack)) continue;
            activeViewContainer = (ViewStack)c;
            break;
        }
        if (activeViewStack != null) {
            activeViewStack.processKeyStroke(ks);
        } else if (activeViewContainer != null) {
            activeViewContainer.processKeyStroke(ks);
        }
    }
}

