/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.windows;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.netxms.client.NXCSession;
import org.netxms.nxmc.BrandingManager;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.menus.HelpMenuManager;
import org.netxms.nxmc.base.menus.UserMenuManager;
import org.netxms.nxmc.base.preferencepages.Appearance;
import org.netxms.nxmc.base.views.Perspective;
import org.netxms.nxmc.base.views.PinLocation;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.views.ViewFolder;
import org.netxms.nxmc.base.widgets.MessageArea;
import org.netxms.nxmc.base.widgets.MessageAreaHolder;
import org.netxms.nxmc.base.widgets.ServerClock;
import org.netxms.nxmc.base.windows.MainWindow;
import org.netxms.nxmc.keyboard.KeyStroke;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.resources.ThemeEngine;
import org.netxms.nxmc.tools.ColorConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

public class MainWindow
extends Window
implements MessageAreaHolder {
    private static Logger logger = LoggerFactory.getLogger(MainWindow.class);
    private static I18n i18n = LocalizationHelper.getI18n(MainWindow.class);
    private Composite windowContent;
    private ToolBar mainMenu;
    private Composite headerArea;
    private MessageArea messageArea;
    private Composite perspectiveArea;
    private List<Perspective> perspectives;
    private Perspective currentPerspective;
    private Perspective pinboardPerspective;
    private SashForm verticalSplitArea;
    private SashForm horizontalSplitArea;
    private ViewFolder leftPinArea;
    private ViewFolder rightPinArea;
    private ViewFolder bottomPinArea;
    private boolean verticalLayout;
    private boolean showServerClock;
    private Composite serverClockArea;
    private ServerClock serverClock;
    private HeaderButton userMenuButton;
    private UserMenuManager userMenuManager;
    private HeaderButton helpMenuButton;
    private HelpMenuManager helpMenuManager;

    public MainWindow(Shell parentShell) {
        super(parentShell);
        PreferenceStore ps = PreferenceStore.getInstance();
        this.verticalLayout = ps.getAsBoolean("Appearance.VerticalLayout", true);
        this.showServerClock = ps.getAsBoolean("Appearance.ShowServerClock", false);
        this.userMenuManager = new UserMenuManager();
        this.helpMenuManager = new HelpMenuManager();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        NXCSession session = Registry.getSession();
        shell.setText(String.format(i18n.tr("%s - %s"), BrandingManager.getClientProductName(), session.getUserName() + "@" + session.getServerAddress()));
        shell.setMaximized(true);
        shell.setFullScreen(true);
        shell.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected Layout getLayout() {
        return new FillLayout();
    }

    protected Control createContents(Composite parent) {
        NXCSession session = Registry.getSession();
        Font perspectiveSwitcherFont = ThemeEngine.getFont((String)"Window.PerspectiveSwitcher");
        this.windowContent = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.numColumns = this.verticalLayout ? 2 : 1;
        this.windowContent.setLayout((Layout)layout);
        Color headerBackgroundColor = new Color((Device)parent.getDisplay(), BrandingManager.getAppHeaderBackground());
        Color headerForegroundColor = ThemeEngine.getForegroundColor((String)"Window.Header");
        this.headerArea = new Composite(this.windowContent, 0);
        this.headerArea.setBackground(headerBackgroundColor);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = this.verticalLayout ? 2 : 1;
        this.headerArea.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 14;
        this.headerArea.setLayout((Layout)layout);
        Label appLogo = new Label(this.headerArea, 0x1000000);
        appLogo.setBackground(headerBackgroundColor);
        appLogo.setImage(BrandingManager.getAppHeaderImage().createImage());
        gd = new GridData(16384, 0x1000000, false, false);
        gd.horizontalIndent = 8;
        appLogo.setLayoutData((Object)gd);
        Label title = new Label(this.headerArea, 16384);
        title.setBackground(headerBackgroundColor);
        title.setForeground(headerForegroundColor);
        title.setData("org.eclipse.rap.rwt.customVariant", (Object)"MainWindowHeaderBold");
        title.setText(BrandingManager.getProductName());
        Label filler = new Label(this.headerArea, 0x1000000);
        filler.setBackground(headerBackgroundColor);
        filler.setLayoutData((Object)new GridData(4, 4, true, false));
        this.serverClockArea = new Composite(this.headerArea, 0);
        this.serverClockArea.setBackground(headerBackgroundColor);
        this.serverClockArea.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, true));
        this.serverClockArea.setLayout((Layout)new FillLayout());
        if (this.showServerClock) {
            this.createServerClockWidget();
        }
        new Spacer(this.headerArea, 32);
        Composite serverNameHolder = new Composite(this.headerArea, 0);
        FillLayout serverNameLayout = new FillLayout();
        serverNameLayout.marginHeight = 4;
        serverNameLayout.marginWidth = 4;
        serverNameHolder.setLayout((Layout)serverNameLayout);
        serverNameHolder.setBackground(headerBackgroundColor);
        Label serverName = new Label(serverNameHolder, 0x1000000);
        serverName.setBackground(headerBackgroundColor);
        serverName.setForeground(headerForegroundColor);
        serverName.setData("org.eclipse.rap.rwt.customVariant", (Object)"MainWindowHeaderNormal");
        serverName.setText(session.getServerName());
        serverName.setToolTipText(i18n.tr("Server name"));
        RGB serverColor = ColorConverter.parseColorDefinition((String)session.getServerColor());
        if (serverColor != null) {
            Color color = new Color((Device)serverName.getDisplay(), serverColor);
            serverName.setBackground(color);
            serverName.setData("org.eclipse.rap.rwt.customVariant", (Object)"ServerName");
            if (!ColorConverter.isDarkColor((RGB)serverColor)) {
                serverName.setForeground(serverName.getDisplay().getSystemColor(2));
            }
        }
        new Spacer(this.headerArea, 32);
        this.userMenuButton = new HeaderButton(this.headerArea, "icons/main-window/user.png", i18n.tr("User properties"), (Runnable)new /* Unavailable Anonymous Inner Class!! */);
        Label userInfo = new Label(this.headerArea, 16384);
        userInfo.setBackground(headerBackgroundColor);
        userInfo.setForeground(headerForegroundColor);
        serverName.setData("org.eclipse.rap.rwt.customVariant", (Object)"MainWindowHeaderNormal");
        userInfo.setText(session.getUserName() + "@" + session.getServerAddress());
        userInfo.setToolTipText(i18n.tr("Login name and server address"));
        new Spacer(this.headerArea, 32);
        new HeaderButton(this.headerArea, "icons/main-window/preferences.png", i18n.tr("Client preferences"), (Runnable)new /* Unavailable Anonymous Inner Class!! */);
        this.helpMenuButton = new HeaderButton(this.headerArea, "icons/main-window/help.png", BrandingManager.isExtendedHelpMenuEnabled() ? i18n.tr("Help") : i18n.tr("Open user manual"), (Runnable)new /* Unavailable Anonymous Inner Class!! */);
        new HeaderButton(this.headerArea, "icons/main-window/about.png", i18n.tr("About NetXMS Management Client"), (Runnable)new /* Unavailable Anonymous Inner Class!! */);
        new Spacer(this.headerArea, 8);
        Composite menuArea = new Composite(this.windowContent, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = this.verticalLayout ? 1 : 2;
        menuArea.setLayout((Layout)layout);
        gd = new GridData();
        if (this.verticalLayout) {
            gd.grabExcessVerticalSpace = true;
            gd.verticalAlignment = 4;
            gd.verticalSpan = 2;
        } else {
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalAlignment = 4;
        }
        menuArea.setLayoutData((Object)gd);
        this.mainMenu = new ToolBar(menuArea, 0x820040 | (this.verticalLayout ? 512 : 256));
        this.mainMenu.setFont(perspectiveSwitcherFont);
        gd = new GridData();
        if (this.verticalLayout) {
            gd.grabExcessVerticalSpace = true;
            gd.verticalAlignment = 4;
        } else {
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalAlignment = 4;
        }
        this.mainMenu.setLayoutData((Object)gd);
        this.messageArea = new MessageArea(this.windowContent, 0);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.messageArea.setLayoutData((Object)gd);
        this.horizontalSplitArea = new SashForm(this.windowContent, 256);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        this.horizontalSplitArea.setLayoutData((Object)gd);
        this.verticalSplitArea = new SashForm((Composite)this.horizontalSplitArea, 512);
        this.perspectiveArea = new Composite((Composite)this.verticalSplitArea, 0);
        this.perspectiveArea.addControlListener((ControlListener)new /* Unavailable Anonymous Inner Class!! */);
        this.setupPerspectiveSwitcher();
        Display display = parent.getDisplay();
        display.addFilter(1, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        this.switchToPerspective("Pinboard");
        this.switchToPerspective(PreferenceStore.getInstance().getAsString(PreferenceStore.serverProperty((String)"MainWindow.CurrentPerspective", (NXCSession)session)));
        String motd = session.getMessageOfTheDay();
        if (motd != null && !motd.isEmpty()) {
            this.addMessage(0, session.getMessageOfTheDay());
        }
        return this.windowContent;
    }

    private void processKeyDownEvent(int stateMask, int keyCode) {
        if (keyCode == 131072 || keyCode == 262144 || keyCode == 131072 || keyCode == 65536 || keyCode == 0x400000) {
            return;
        }
        KeyStroke ks = new KeyStroke(stateMask, keyCode);
        boolean processed = false;
        for (Perspective p : this.perspectives) {
            if (!ks.equals((Object)p.getKeyboardShortcut())) continue;
            processed = true;
            this.getShell().getDisplay().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            break;
        }
        if (!processed && this.currentPerspective != null) {
            this.currentPerspective.processKeyStroke(ks);
        }
    }

    private void resizePerspectiveAreaContent() {
        for (Control c : this.perspectiveArea.getChildren()) {
            if (!c.isVisible()) continue;
            c.setSize(this.perspectiveArea.getSize());
            break;
        }
    }

    private void setupPerspectiveSwitcher() {
        this.perspectives = Registry.getPerspectives();
        for (Perspective p : this.perspectives) {
            KeyStroke shortcut;
            p.bindToWindow((Window)this);
            ToolItem item = new ToolItem(this.mainMenu, 16);
            item.setData("PerspectiveId", (Object)p.getId());
            item.setImage(p.getImage());
            if (!this.verticalLayout) {
                item.setText(p.getName());
            }
            item.setToolTipText((String)((shortcut = p.getKeyboardShortcut()) != null ? p.getName() + "\t" + shortcut.toString() : p.getName()));
            item.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            if (!p.getId().equals("Pinboard")) continue;
            this.pinboardPerspective = p;
        }
    }

    private void switchToPerspective(Perspective p) {
        logger.debug("Switching to perspective " + p.getName());
        if (this.currentPerspective != null) {
            this.currentPerspective.hide();
        }
        this.currentPerspective = p;
        this.currentPerspective.show(this.perspectiveArea);
        this.resizePerspectiveAreaContent();
        for (ToolItem item : this.mainMenu.getItems()) {
            Object id = item.getData("PerspectiveId");
            if (id == null) continue;
            item.setSelection(p.getId().equals(id));
        }
    }

    public void switchToPerspective(String id) {
        for (Perspective p : this.perspectives) {
            if (!p.getId().equals(id)) continue;
            this.switchToPerspective(p);
            break;
        }
    }

    public void pinView(View view, PinLocation location) {
        logger.debug("Request to pin view with GlobalID=" + view.getGlobalId() + " at location=" + location);
        switch (12.$SwitchMap$org$netxms$nxmc$base$views$PinLocation[location.ordinal()]) {
            case 1: {
                this.bottomPinArea = this.pinViewToArea(view, this.bottomPinArea, this.verticalSplitArea, false);
                break;
            }
            case 2: {
                this.leftPinArea = this.pinViewToArea(view, this.leftPinArea, this.horizontalSplitArea, true);
                break;
            }
            case 3: {
                this.pinboardPerspective.addMainView(view, true, true);
                break;
            }
            case 4: {
                this.rightPinArea = this.pinViewToArea(view, this.rightPinArea, this.horizontalSplitArea, false);
            }
        }
    }

    private ViewFolder pinViewToArea(View view, ViewFolder pinArea, SashForm splitter, boolean moveToTop) {
        if (pinArea == null || pinArea.isDisposed()) {
            int[] weights = splitter.getWeights();
            pinArea = new ViewFolder((Window)this, null, (Composite)splitter, true, false, false);
            pinArea.setAllViewsAsCloseable(true);
            pinArea.setUseGlobalViewId(true);
            pinArea.setDisposeWhenEmpty(true);
            if (moveToTop) {
                pinArea.moveAbove(null);
                int[] nweights = new int[weights.length + 1];
                int total = 0;
                for (int w : weights) {
                    total += w;
                }
                nweights[0] = 3 * total / 7;
                System.arraycopy(weights, 0, nweights, 1, weights.length);
                weights = nweights;
            } else {
                weights = Arrays.copyOf(weights, weights.length + 1);
                int total = 0;
                for (int w : weights) {
                    total += w;
                }
                weights[weights.length - 1] = 3 * total / 7;
            }
            splitter.setWeights(weights);
            this.windowContent.layout(true, true);
        }
        pinArea.addView(view, true, true);
        return pinArea;
    }

    private void showPreferences() {
        PreferenceManager pm = new PreferenceManager();
        pm.addToRoot((IPreferenceNode)new PreferenceNode("appearance", (IPreferencePage)new Appearance()));
        10 dlg = new /* Unavailable Anonymous Inner Class!! */;
        dlg.setBlockOnOpen(true);
        dlg.open();
        this.showServerClock = PreferenceStore.getInstance().getAsBoolean("Appearance.ShowServerClock", false);
        if (this.showServerClock && this.serverClock == null) {
            this.createServerClockWidget();
            this.headerArea.layout(true);
        } else if (!this.showServerClock && this.serverClock != null) {
            this.serverClock.dispose();
            this.serverClock = null;
            this.headerArea.layout(true);
        }
    }

    private void createServerClockWidget() {
        this.serverClock = new ServerClock(this.serverClockArea, 0);
        this.serverClock.setBackground(this.serverClockArea.getBackground());
        this.serverClock.setForeground(ThemeEngine.getForegroundColor((String)"Window.Header"));
        this.serverClock.setDisplayFormatChangeListener((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void showMenu(MenuManager menuManager, Point location) {
        Menu menu = menuManager.createContextMenu((Control)this.getShell());
        menu.setLocation(location);
        menu.setVisible(true);
    }

    public int addMessage(int level, String text) {
        return this.messageArea.addMessage(level, text);
    }

    public int addMessage(int level, String text, boolean sticky) {
        return this.messageArea.addMessage(level, text);
    }

    public void deleteMessage(int id) {
        this.messageArea.deleteMessage(id);
    }

    public void clearMessages() {
        this.messageArea.clearMessages();
    }
}

