/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.businessservice.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.businessservices.BusinessServiceCheck;
import org.netxms.client.constants.BusinessServiceCheckType;
import org.netxms.client.objects.GenericObject;
import org.netxms.nxmc.base.widgets.AbstractSelector;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.widgets.DciSelector;
import org.netxms.nxmc.modules.nxsl.widgets.ScriptEditor;
import org.netxms.nxmc.modules.objects.widgets.ObjectSelector;
import org.netxms.nxmc.resources.StatusDisplayInfo;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class EditBusinessServiceCheckDlg
extends Dialog {
    private static final I18n i18n = LocalizationHelper.getI18n(EditBusinessServiceCheckDlg.class);
    private static final String[] TYPES = new String[]{i18n.tr("Script"), i18n.tr("DCI threshold"), i18n.tr("Object status")};
    private BusinessServiceCheck check;
    private boolean createNew;
    private LabeledText descriptionText;
    private Combo typeCombo;
    private Combo thresholdCombo;
    private AbstractSelector objectOrDciSelector;
    private Label scriptLabel;
    private ScriptEditor scriptEditor;
    private Composite selectorGroup;
    private Composite dialogArea;

    public EditBusinessServiceCheckDlg(Shell parentShell, BusinessServiceCheck check, boolean createNew) {
        super(parentShell);
        this.check = check;
        this.createNew = createNew;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.createNew ? i18n.tr("Create Business Service Check") : i18n.tr("Edit Business Service Check"));
    }

    protected Control createDialogArea(Composite parent) {
        this.dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 5;
        layout.numColumns = 2;
        this.dialogArea.setLayout((Layout)layout);
        this.descriptionText = new LabeledText(this.dialogArea, 0);
        this.descriptionText.setLabel("Description");
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        gd.widthHint = 700;
        this.descriptionText.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.typeCombo = WidgetHelper.createLabeledCombo((Composite)this.dialogArea, (int)8, (String)i18n.tr("Check type"), (Object)gd);
        for (String type : TYPES) {
            this.typeCombo.add(type);
        }
        this.typeCombo.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.thresholdCombo = WidgetHelper.createLabeledCombo((Composite)this.dialogArea, (int)8, (String)i18n.tr("Status threshold"), (Object)gd);
        this.thresholdCombo.add(i18n.tr("Default"));
        for (int i = 1; i <= 4; ++i) {
            this.thresholdCombo.add(StatusDisplayInfo.getStatusText((int)i));
        }
        this.selectorGroup = new Composite(this.dialogArea, 0);
        this.selectorGroup.setLayout((Layout)new FillLayout());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.selectorGroup.setLayoutData((Object)gd);
        if (this.check.getCheckType() == BusinessServiceCheckType.DCI) {
            this.objectOrDciSelector = new DciSelector(this.selectorGroup, 0);
            this.objectOrDciSelector.setLabel(i18n.tr("Data collection item"));
            ((DciSelector)this.objectOrDciSelector).setDciId(this.check.getObjectId(), this.check.getDciId());
        } else {
            this.objectOrDciSelector = new ObjectSelector(this.selectorGroup, 0, true);
            ((ObjectSelector)this.objectOrDciSelector).setObjectClass(GenericObject.class);
            ((ObjectSelector)this.objectOrDciSelector).setObjectId(this.check.getObjectId());
        }
        this.scriptLabel = new Label(this.dialogArea, 0);
        this.scriptLabel.setText(i18n.tr("Check script"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.scriptLabel.setLayoutData((Object)gd);
        this.scriptEditor = new ScriptEditor(this.dialogArea, 2048, 768, true, true);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.widthHint = 700;
        gd.heightHint = 300;
        gd.horizontalSpan = 2;
        this.scriptEditor.setLayoutData((Object)gd);
        this.descriptionText.setText(this.check.getDescription());
        this.typeCombo.select(this.check.getCheckType() == BusinessServiceCheckType.NONE ? BusinessServiceCheckType.OBJECT.getValue() - 1 : this.check.getCheckType().getValue() - 1);
        this.thresholdCombo.select(this.check.getThreshold());
        this.scriptEditor.setText(this.check.getScript());
        this.updateElementVisibility();
        return this.dialogArea;
    }

    protected Control createContents(Composite parent) {
        Control content = super.createContents(parent);
        this.getShell().pack();
        return content;
    }

    private void updateElementVisibility() {
        BusinessServiceCheckType type = BusinessServiceCheckType.getByValue((int)(this.typeCombo.getSelectionIndex() + 1));
        if (type == BusinessServiceCheckType.DCI && !(this.objectOrDciSelector instanceof DciSelector)) {
            this.objectOrDciSelector.dispose();
            this.objectOrDciSelector = new DciSelector(this.selectorGroup, 0);
            this.objectOrDciSelector.setLabel(i18n.tr("Data collection item"));
            ((DciSelector)this.objectOrDciSelector).setDciId(this.check.getObjectId(), this.check.getDciId());
        }
        if (!(type != BusinessServiceCheckType.OBJECT && type != BusinessServiceCheckType.SCRIPT || this.objectOrDciSelector instanceof ObjectSelector)) {
            this.objectOrDciSelector.dispose();
            this.objectOrDciSelector = new ObjectSelector(this.selectorGroup, 0, true);
            ((ObjectSelector)this.objectOrDciSelector).setObjectClass(GenericObject.class);
            ((ObjectSelector)this.objectOrDciSelector).setObjectId(this.check.getObjectId());
        }
        if (type == BusinessServiceCheckType.SCRIPT) {
            this.scriptEditor.setVisible(true);
            ((GridData)this.scriptEditor.getLayoutData()).exclude = false;
            this.scriptLabel.setVisible(true);
            ((GridData)this.scriptLabel.getLayoutData()).exclude = false;
        } else {
            this.scriptEditor.setVisible(false);
            ((GridData)this.scriptEditor.getLayoutData()).exclude = true;
            this.scriptLabel.setVisible(false);
            ((GridData)this.scriptLabel.getLayoutData()).exclude = true;
        }
        this.thresholdCombo.setEnabled(type == BusinessServiceCheckType.OBJECT || type == BusinessServiceCheckType.DCI);
        if (type == BusinessServiceCheckType.OBJECT) {
            this.objectOrDciSelector.setLabel(i18n.tr("Object to check"));
        } else if (type == BusinessServiceCheckType.SCRIPT) {
            this.objectOrDciSelector.setLabel(i18n.tr("Related object"));
        }
        this.getShell().layout(true, true);
        this.getShell().pack();
    }

    protected void okPressed() {
        this.check.setDescription(this.descriptionText.getText());
        BusinessServiceCheckType type = BusinessServiceCheckType.getByValue((int)(this.typeCombo.getSelectionIndex() + 1));
        this.check.setCheckType(type);
        if (type == BusinessServiceCheckType.DCI) {
            this.check.setThreshold(this.thresholdCombo.getSelectionIndex());
            this.check.setObjectId(((DciSelector)this.objectOrDciSelector).getNodeId());
            this.check.setDciId(((DciSelector)this.objectOrDciSelector).getDciId());
            this.check.setScript("");
        } else if (type == BusinessServiceCheckType.OBJECT) {
            this.check.setThreshold(this.thresholdCombo.getSelectionIndex());
            this.check.setObjectId(((ObjectSelector)this.objectOrDciSelector).getObjectId());
            this.check.setDciId(0L);
            this.check.setScript("");
        } else if (type == BusinessServiceCheckType.SCRIPT) {
            this.check.setObjectId(((ObjectSelector)this.objectOrDciSelector).getObjectId());
            this.check.setDciId(0L);
            this.check.setScript(this.scriptEditor.getText());
        }
        super.okPressed();
    }
}

