/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.netxms.client.NXCSession;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.datacollection.ChartConfiguration;
import org.netxms.client.datacollection.ChartDciConfig;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.charts.api.ChartType;
import org.netxms.nxmc.modules.charts.widgets.Chart;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.config.LineChartConfig;
import org.netxms.nxmc.modules.dashboards.views.AbstractDashboardView;
import org.netxms.nxmc.modules.dashboards.widgets.DashboardControl;
import org.netxms.nxmc.modules.dashboards.widgets.ElementWidget;
import org.netxms.nxmc.modules.dashboards.widgets.LineChartElement;
import org.netxms.nxmc.modules.datacollection.views.HistoricalGraphView;
import org.netxms.nxmc.tools.ViewRefreshController;
import org.xnap.commons.i18n.I18n;

public class LineChartElement
extends ElementWidget
implements HistoricalGraphView.HistoricalChartOwner {
    private final I18n i18n = LocalizationHelper.getI18n(LineChartElement.class);
    private Chart chart;
    private LineChartConfig config;
    private ViewRefreshController refreshController;
    private boolean updateInProgress = false;
    private NXCSession session;
    private List<ChartDciConfig> runtimeDciList = new ArrayList();
    private List<DataCacheElement> dataCache = new ArrayList(16);
    private Action actionRefresh;
    private Action actionAdjustX;
    private Action actionAdjustY;
    private Action actionAdjustBoth;
    private Action[] presetActions;

    public LineChartElement(DashboardControl parent, DashboardElement element, AbstractDashboardView view) {
        super(parent, element, view);
        this.session = Registry.getSession();
        try {
            this.config = LineChartConfig.createFromXml((String)element.getData());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.config = new LineChartConfig();
        }
        this.processCommonSettings((DashboardElementConfig)this.config);
        ChartConfiguration chartConfig = new ChartConfiguration();
        chartConfig.setZoomEnabled(this.config.isInteractive());
        chartConfig.setTitleVisible(false);
        chartConfig.setLegendVisible(this.config.isShowLegend());
        chartConfig.setLegendPosition(this.config.getLegendPosition());
        chartConfig.setExtendedLegend(this.config.isExtendedLegend());
        chartConfig.setGridVisible(this.config.isShowGrid());
        chartConfig.setLogScale(this.config.isLogScaleEnabled());
        chartConfig.setStacked(this.config.isStacked());
        chartConfig.setLineWidth(this.config.getLineWidth());
        chartConfig.setArea(this.config.isArea());
        chartConfig.setTranslucent(this.config.isTranslucent());
        chartConfig.setUseMultipliers(this.config.isUseMultipliers());
        chartConfig.setAutoScale(this.config.isAutoScale());
        chartConfig.setMinYScaleValue(this.config.getMinYScaleValue());
        chartConfig.setMaxYScaleValue(this.config.getMaxYScaleValue());
        chartConfig.setModifyYBase(this.config.modifyYBase());
        this.chart = new Chart(this.getContentArea(), 0, ChartType.LINE, chartConfig);
        this.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        if (this.config.isInteractive()) {
            this.createActions();
            this.createChartContextMenu();
        }
        this.configureMetrics();
    }

    private void configureMetrics() {
        2 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }

    private void createActions() {
        this.actionRefresh = new /* Unavailable Anonymous Inner Class!! */;
        this.actionAdjustX = HistoricalGraphView.createAction((HistoricalGraphView.ChartActionType)HistoricalGraphView.ChartActionType.ADJUST_X, (HistoricalGraphView.HistoricalChartOwner)this);
        this.actionAdjustY = HistoricalGraphView.createAction((HistoricalGraphView.ChartActionType)HistoricalGraphView.ChartActionType.ADJUST_Y, (HistoricalGraphView.HistoricalChartOwner)this);
        this.actionAdjustBoth = HistoricalGraphView.createAction((HistoricalGraphView.ChartActionType)HistoricalGraphView.ChartActionType.ADJUST_BOTH, (HistoricalGraphView.HistoricalChartOwner)this);
        this.presetActions = HistoricalGraphView.createPresetActions((HistoricalGraphView.PresetHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void createChartContextMenu() {
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        this.chart.setMenuManager(manager);
    }

    private void fillContextMenu(IMenuManager manager) {
        MenuManager presets = new MenuManager("&Presets");
        for (int i = 0; i < this.presetActions.length; ++i) {
            presets.add((IAction)this.presetActions[i]);
        }
        manager.add((IContributionItem)presets);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionAdjustBoth);
        manager.add((IAction)this.actionAdjustX);
        manager.add((IAction)this.actionAdjustY);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void refreshData() {
        if (this.updateInProgress) {
            return;
        }
        this.updateInProgress = true;
        6 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size = super.computeSize(wHint, hHint, changed);
        if (hHint == -1 && size.y < 210) {
            size.y = 210;
        }
        return size;
    }

    public List<DataCacheElement> getDataCache() {
        return new ArrayList<DataCacheElement>(this.dataCache);
    }

    public Chart getChart() {
        return this.chart;
    }
}

