/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.widgets;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Scrollable;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.RackOrientation;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.objects.Rack;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.config.RackDiagramConfig;
import org.netxms.nxmc.modules.dashboards.config.RackDisplayMode;
import org.netxms.nxmc.modules.dashboards.views.AbstractDashboardView;
import org.netxms.nxmc.modules.dashboards.widgets.DashboardControl;
import org.netxms.nxmc.modules.dashboards.widgets.ElementWidget;
import org.netxms.nxmc.modules.dashboards.widgets.RackDiagramElement;
import org.netxms.nxmc.modules.objects.ObjectContextMenuManager;
import org.netxms.nxmc.modules.objects.widgets.RackWidget;
import org.netxms.nxmc.modules.objects.widgets.helpers.ElementSelectionListener;
import org.netxms.nxmc.resources.ThemeEngine;
import org.netxms.nxmc.tools.WidgetHelper;

public class RackDiagramElement
extends ElementWidget
implements ISelectionProvider {
    private RackWidget rackFrontWidget = null;
    private RackWidget rackRearWidget = null;
    private NXCSession session;
    private RackDiagramConfig config;
    private Composite rackArea;
    private ScrolledComposite scroller;
    private Font font = null;
    private ISelection selection = new StructuredSelection();
    private Set<ISelectionChangedListener> selectionListeners = new HashSet();

    protected RackDiagramElement(DashboardControl parent, DashboardElement element, AbstractDashboardView view) {
        super(parent, element, view);
        try {
            this.config = RackDiagramConfig.createFromXml((String)element.getData());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.config = new RackDiagramConfig();
        }
        this.processCommonSettings((DashboardElementConfig)this.config);
        this.session = Registry.getSession();
        Rack rack = (Rack)this.session.findObjectById(this.getEffectiveObjectId(this.config.getObjectId()), Rack.class);
        if (rack != null) {
            Color backgroundColor = ThemeEngine.getBackgroundColor((String)"Rack");
            this.scroller = new ScrolledComposite(this.getContentArea(), 256);
            this.rackArea = new /* Unavailable Anonymous Inner Class!! */;
            this.rackArea.setBackground(backgroundColor);
            this.rackArea.addControlListener((ControlListener)new /* Unavailable Anonymous Inner Class!! */);
            if (this.config.getDisplayMode() == RackDisplayMode.FULL || this.config.getDisplayMode() == RackDisplayMode.FRONT) {
                this.setRackFrontWidget(new RackWidget(this.rackArea, 0, rack, RackOrientation.FRONT, (View)view));
            }
            if (this.config.getDisplayMode() == RackDisplayMode.FULL || this.config.getDisplayMode() == RackDisplayMode.BACK) {
                this.setRackRearWidget(new RackWidget(this.rackArea, 0, rack, RackOrientation.REAR, (View)view));
            }
            this.scroller.setContent((Control)this.rackArea);
            this.scroller.setExpandHorizontal(true);
            this.scroller.setExpandVertical(true);
            WidgetHelper.setScrollBarIncrement((Scrollable)this.scroller, (int)256, (int)20);
            this.scroller.addControlListener((ControlListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        5 listener = new /* Unavailable Anonymous Inner Class!! */;
        if (this.rackFrontWidget != null) {
            this.rackFrontWidget.addSelectionListener((ElementSelectionListener)listener);
        }
        if (this.rackRearWidget != null) {
            this.rackRearWidget.addSelectionListener((ElementSelectionListener)listener);
        }
        this.createPopupMenu();
    }

    private void createPopupMenu() {
        ObjectContextMenuManager menuMgr = new ObjectContextMenuManager((View)this.view, (ISelectionProvider)this, null);
        if (this.rackFrontWidget != null) {
            this.rackFrontWidget.setMenu(menuMgr.createContextMenu((Control)this.rackFrontWidget));
        }
        if (this.rackRearWidget != null) {
            this.rackRearWidget.setMenu(menuMgr.createContextMenu((Control)this.rackRearWidget));
        }
    }

    public RackWidget getRackRearWidget() {
        return this.rackRearWidget;
    }

    public void setRackRearWidget(RackWidget rackRearWidget) {
        this.rackRearWidget = rackRearWidget;
    }

    public RackWidget getRackFrontWidget() {
        return this.rackFrontWidget;
    }

    public void setRackFrontWidget(RackWidget rackFrontWidget) {
        this.rackFrontWidget = rackFrontWidget;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add(listener);
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
    }
}

