/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.constants.DataType;
import org.netxms.client.datacollection.ColumnDefinition;
import org.netxms.client.snmp.SnmpObjectId;
import org.netxms.client.snmp.SnmpObjectIdFormatException;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.dialogs.EditColumnDialog;
import org.netxms.nxmc.modules.datacollection.widgets.helpers.DataCollectionDisplayInfo;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

/*
 * Exception performing whole class analysis ignored.
 */
public class EditColumnDialog
extends Dialog {
    private static final I18n i18n = LocalizationHelper.getI18n(EditColumnDialog.class);
    private ColumnDefinition column;
    private LabeledText name;
    private LabeledText displayName;
    private Combo dataType;
    private Combo aggregationFunction;
    private Button checkInstanceColumn;
    private Button checkSnmpHexString;
    private LabeledText snmpOid;
    private static final DataType[] TYPES = new DataType[]{DataType.INT32, DataType.UINT32, DataType.COUNTER32, DataType.INT64, DataType.UINT64, DataType.COUNTER64, DataType.FLOAT, DataType.STRING};

    public EditColumnDialog(Shell parentShell, ColumnDefinition column) {
        super(parentShell);
        this.column = column;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.column.getName().isEmpty() ? i18n.tr("Add Column Definition") : i18n.tr("Edit Column Definition "));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        dialogArea.setLayout((Layout)layout);
        this.name = new LabeledText(dialogArea, 0);
        this.name.setLabel(i18n.tr("Name"));
        this.name.setText(this.column.getName());
        this.name.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.displayName = new LabeledText(dialogArea, 0);
        this.displayName.setLabel(i18n.tr("Display name"));
        this.displayName.setText(this.column.getDisplayName());
        this.displayName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.dataType = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)i18n.tr("Data type"), (Object)new GridData(4, 0x1000000, true, false));
        this.dataType.add(DataCollectionDisplayInfo.getDataTypeName((DataType)DataType.INT32));
        this.dataType.add(DataCollectionDisplayInfo.getDataTypeName((DataType)DataType.UINT32));
        this.dataType.add(DataCollectionDisplayInfo.getDataTypeName((DataType)DataType.COUNTER32));
        this.dataType.add(DataCollectionDisplayInfo.getDataTypeName((DataType)DataType.INT64));
        this.dataType.add(DataCollectionDisplayInfo.getDataTypeName((DataType)DataType.UINT64));
        this.dataType.add(DataCollectionDisplayInfo.getDataTypeName((DataType)DataType.COUNTER64));
        this.dataType.add(DataCollectionDisplayInfo.getDataTypeName((DataType)DataType.FLOAT));
        this.dataType.add(DataCollectionDisplayInfo.getDataTypeName((DataType)DataType.STRING));
        this.dataType.select(EditColumnDialog.getDataTypePosition((DataType)this.column.getDataType()));
        this.aggregationFunction = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)i18n.tr("Aggregation function"), (Object)new GridData(4, 0x1000000, true, false));
        this.aggregationFunction.add(i18n.tr("SUM"));
        this.aggregationFunction.add(i18n.tr("AVG"));
        this.aggregationFunction.add(i18n.tr("MIN"));
        this.aggregationFunction.add(i18n.tr("MAX"));
        this.aggregationFunction.select(this.column.getAggregationFunction());
        this.checkInstanceColumn = new Button(dialogArea, 32);
        this.checkInstanceColumn.setText(i18n.tr("This column is instance (key) column"));
        this.checkInstanceColumn.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.checkInstanceColumn.setSelection(this.column.isInstanceColumn());
        this.checkSnmpHexString = new Button(dialogArea, 32);
        this.checkSnmpHexString.setText("Convert SNMP value to &hexadecimal string");
        this.checkSnmpHexString.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.checkSnmpHexString.setSelection(this.column.isConvertSnmpStringToHex());
        this.snmpOid = new LabeledText(dialogArea, 0);
        this.snmpOid.setLabel(i18n.tr("SNMP Object ID"));
        this.snmpOid.setText(this.column.getSnmpObjectId() != null ? this.column.getSnmpObjectId().toString() : "");
        this.snmpOid.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        return dialogArea;
    }

    protected void okPressed() {
        String oidText = this.snmpOid.getText().trim();
        if (!oidText.isEmpty()) {
            try {
                SnmpObjectId oid = SnmpObjectId.parseSnmpObjectId((String)oidText);
                this.column.setSnmpObjectId(oid);
            }
            catch (SnmpObjectIdFormatException e) {
                MessageDialogHelper.openWarning((Shell)this.getShell(), (String)i18n.tr("Warning"), (String)i18n.tr("Entered SNMP object ID is invalid"));
                return;
            }
        } else {
            this.column.setSnmpObjectId(null);
        }
        if (this.name.getText().trim().isEmpty()) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)i18n.tr("Warning"), (String)i18n.tr("Column name can not be empty"));
            return;
        }
        this.column.setName(this.name.getText().trim());
        this.column.setDisplayName(this.displayName.getText().trim().isEmpty() ? this.name.getText().trim() : this.displayName.getText().trim());
        this.column.setInstanceColumn(this.checkInstanceColumn.getSelection());
        this.column.setConvertSnmpStringToHex(this.checkSnmpHexString.getSelection());
        this.column.setDataType(EditColumnDialog.getDataTypeByPosition((int)this.dataType.getSelectionIndex()));
        this.column.setAggregationFunction(this.aggregationFunction.getSelectionIndex());
        super.okPressed();
    }

    private static int getDataTypePosition(DataType type) {
        switch (1.$SwitchMap$org$netxms$client$constants$DataType[type.ordinal()]) {
            case 1: {
                return 2;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 6;
            }
            case 4: {
                return 0;
            }
            case 5: {
                return 3;
            }
            case 6: {
                return 7;
            }
            case 7: {
                return 1;
            }
            case 8: {
                return 4;
            }
        }
        return 0;
    }

    private static DataType getDataTypeByPosition(int position) {
        return TYPES[position];
    }
}

