/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.propertypages;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Interface;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.propertypages.ObjectPropertyPage;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class InterfacePolling
extends ObjectPropertyPage {
    private static I18n i18n = LocalizationHelper.getI18n(InterfacePolling.class);
    private Spinner pollCount;
    private Combo expectedState;
    private Interface iface;
    private int currentPollCount;
    private int currentExpectedState;
    private int currentFlags;
    private List<Button> flagButtons = new ArrayList();
    private List<Integer> flagValues = new ArrayList();

    public InterfacePolling(AbstractObject object) {
        super(i18n.tr("Polling"), object);
    }

    public String getId() {
        return "interfacePolling";
    }

    public int getPriority() {
        return 20;
    }

    public boolean isVisible() {
        return this.object instanceof Interface;
    }

    protected Control createContents(Composite parent) {
        this.iface = (Interface)this.object;
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.pollCount = WidgetHelper.createLabeledSpinner((Composite)dialogArea, (int)2048, (String)i18n.tr("Required poll count"), (int)0, (int)1000, (Object)"WidgetHelper::default_layout_data");
        this.pollCount.setSelection(this.iface.getRequiredPollCount());
        this.expectedState = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)2056, (String)i18n.tr("Expected state"), (Object)"WidgetHelper::default_layout_data");
        this.expectedState.add(i18n.tr("UP"));
        this.expectedState.add(i18n.tr("DOWN"));
        this.expectedState.add(i18n.tr("IGNORE"));
        this.expectedState.select(this.iface.getExpectedState());
        this.addFlag(dialogArea, 4, i18n.tr("&Exclude this interface from network topology"));
        this.addFlag(dialogArea, 64, "&Collect ICMP response statistic for this interface");
        this.addFlag(dialogArea, 512, "Disable status polling with NetXMS &agent");
        this.addFlag(dialogArea, 128, "Disable status polling with &SNMP");
        this.addFlag(dialogArea, 256, "Disable status polling with &ICMP");
        this.currentPollCount = this.iface.getRequiredPollCount();
        this.currentExpectedState = this.iface.getExpectedState();
        this.currentFlags = this.iface.getFlags() & this.collectFlagsMask();
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        int flags = this.collectFlags();
        int flagMask = this.collectFlagsMask();
        if (this.expectedState.getSelectionIndex() == this.currentExpectedState && this.pollCount.getSelection() == this.currentPollCount && flags == this.currentFlags) {
            return true;
        }
        if (isApply) {
            this.setValid(false);
        }
        NXCSession session = Registry.getSession();
        NXCObjectModificationData data = new NXCObjectModificationData(this.object.getObjectId());
        data.setExpectedState(this.expectedState.getSelectionIndex());
        data.setRequiredPolls(this.pollCount.getSelection());
        data.setObjectFlags(flags, flagMask);
        new /* Unavailable Anonymous Inner Class!! */.start();
        return true;
    }

    private void addFlag(Composite parent, int value, String name) {
        Button button = new Button(parent, 32);
        button.setText(name);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        button.setLayoutData((Object)gd);
        button.setSelection((this.iface.getFlags() & value) != 0);
        this.flagButtons.add(button);
        this.flagValues.add(value);
    }

    private int collectFlags() {
        int flags = this.iface.getFlags();
        for (int i = 0; i < this.flagButtons.size(); ++i) {
            if (((Button)this.flagButtons.get(i)).getSelection()) {
                flags |= ((Integer)this.flagValues.get(i)).intValue();
                continue;
            }
            flags &= ~((Integer)this.flagValues.get(i)).intValue();
        }
        return flags;
    }

    private int collectFlagsMask() {
        int mask = 0;
        for (int i = 0; i < this.flagButtons.size(); ++i) {
            mask |= ((Integer)this.flagValues.get(i)).intValue();
        }
        return mask;
    }
}

