/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views;

import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TableColumn;
import org.netxms.client.objects.queries.ObjectQueryResult;
import org.netxms.nxmc.base.actions.CopyTableRowsAction;
import org.netxms.nxmc.base.actions.ExportToCsvAction;
import org.netxms.nxmc.base.views.ConfigurationView;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.modules.objects.views.helpers.ObjectQueryResultLabelProvider;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.resources.SharedIcons;

public class ObjectQueryResultView
extends ConfigurationView {
    private List<ObjectQueryResult> resultSet;
    private SortableTableViewer viewer;
    private Action actionExportToCSV;
    private Action actionCopyToClipboard;
    private Action actionCopySelectionToClipboard;

    public ObjectQueryResultView(String queryName, List<ObjectQueryResult> resultSet) {
        super(queryName, ResourceManager.getImageDescriptor((String)"icons/config-views/object-query-results.png"), "ObjectQueryResultView." + queryName, false);
        this.resultSet = resultSet;
    }

    protected void createContent(Composite parent) {
        this.viewer = new SortableTableViewer(parent, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ObjectQueryResultLabelProvider(this.viewer.getTable()));
        this.createActions();
        this.createContextMenu();
    }

    protected void postContentCreate() {
        super.postContentCreate();
        this.updateResultTable(this.resultSet);
    }

    private void createActions() {
        this.actionExportToCSV = new ExportToCsvAction((View)this, (ColumnViewer)this.viewer, false);
        this.actionCopyToClipboard = new CopyTableRowsAction((ColumnViewer)this.viewer, false);
        this.actionCopyToClipboard.setImageDescriptor(SharedIcons.COPY_TO_CLIPBOARD);
        this.actionCopySelectionToClipboard = new CopyTableRowsAction((ColumnViewer)this.viewer, true);
        this.actionCopySelectionToClipboard.setImageDescriptor(SharedIcons.COPY_TO_CLIPBOARD);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionCopyToClipboard);
        manager.add((IAction)this.actionExportToCSV);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionCopyToClipboard);
        manager.add((IAction)this.actionExportToCSV);
    }

    private void createContextMenu() {
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = manager.createContextMenu((Control)this.viewer.getTable());
        this.viewer.getTable().setMenu(menu);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private void resetResultTable() {
        TableColumn[] columns = this.viewer.getTable().getColumns();
        for (int i = 0; i < columns.length; ++i) {
            columns[i].dispose();
        }
    }

    private void updateResultTable(List<ObjectQueryResult> objects) {
        this.resetResultTable();
        HashSet<String> registeredProperties = new HashSet<String>();
        for (ObjectQueryResult r : objects) {
            for (String n : r.getPropertyNames()) {
                if (registeredProperties.contains(n)) continue;
                TableColumn tc = this.viewer.addColumn(n, 200);
                tc.setData("propertyName", (Object)n);
                registeredProperties.add(n);
            }
        }
        this.viewer.setInput(objects);
    }

    public boolean isModified() {
        return false;
    }

    public void save() {
    }
}

