/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views.elements;

import org.eclipse.swt.widgets.Composite;
import org.netxms.base.InetAddressEx;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.AccessPoint;
import org.netxms.client.objects.BusinessService;
import org.netxms.client.objects.Chassis;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.DataCollectionTarget;
import org.netxms.client.objects.Interface;
import org.netxms.client.objects.MobileDevice;
import org.netxms.client.objects.Rack;
import org.netxms.client.objects.Sensor;
import org.netxms.client.objects.Subnet;
import org.netxms.client.objects.Template;
import org.netxms.client.objects.Zone;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.DateFormatFactory;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objects.views.elements.OverviewPageElement;
import org.netxms.nxmc.modules.objects.views.elements.TableElement;
import org.netxms.nxmc.modules.objects.views.helpers.InterfaceListLabelProvider;
import org.netxms.nxmc.resources.StatusDisplayInfo;
import org.xnap.commons.i18n.I18n;

public class GeneralInfo
extends TableElement {
    private static final I18n i18n = LocalizationHelper.getI18n(GeneralInfo.class);
    private static final String[] ifaceExpectedState = new String[]{i18n.tr("Up"), i18n.tr("Down"), i18n.tr("Ignore"), i18n.tr("Auto")};

    public GeneralInfo(Composite parent, OverviewPageElement anchor, ObjectView objectView) {
        super(parent, anchor, objectView);
    }

    protected void fillTable() {
        AbstractObject object = this.getObject();
        NXCSession session = Registry.getSession();
        this.addPair(i18n.tr("ID"), Long.toString(object.getObjectId()));
        if (object.getGuid() != null) {
            this.addPair(i18n.tr("GUID"), object.getGuid().toString());
        }
        this.addPair(i18n.tr("Class"), object.getObjectClassName());
        this.addPair(i18n.tr("Alias"), object.getAlias(), false);
        if (object.isInMaintenanceMode()) {
            this.addPair(i18n.tr("Status"), StatusDisplayInfo.getStatusText((ObjectStatus)object.getStatus()) + i18n.tr(" (maintenance)"));
            AbstractUserObject user = session.findUserDBObjectById(object.getMaintenanceInitiatorId(), (Runnable)new /* Unavailable Anonymous Inner Class!! */);
            this.addPair(i18n.tr("Maintenance initiator"), (String)(user != null ? user.getName() : "[" + object.getMaintenanceInitiatorId() + "]"));
        } else {
            this.addPair(i18n.tr("Status"), StatusDisplayInfo.getStatusText((ObjectStatus)object.getStatus()));
        }
        if (object instanceof AbstractNode && (((AbstractNode)object).getCapabilities() & 0x800000) != 0) {
            this.addPair(i18n.tr("Device state"), ((AbstractNode)object).getCipStateText(), false);
            this.addPair(i18n.tr("Device status"), ((AbstractNode)object).getCipStatusText(), false);
            if ((((AbstractNode)object).getCipStatus() >> 4 & 0xF) != 0) {
                this.addPair(i18n.tr("Extended device status"), ((AbstractNode)object).getCipExtendedStatusText(), false);
            }
        }
        if (object.getCreationTime() != null && object.getCreationTime().getTime() != 0L) {
            this.addPair(i18n.tr("Creation time"), DateFormatFactory.getDateTimeFormat().format(object.getCreationTime()), false);
        }
        switch (object.getObjectClass()) {
            case 35: {
                Rack rack;
                AbstractNode node;
                Chassis chassis = (Chassis)object;
                if (chassis.getControllerId() != 0L && (node = (AbstractNode)session.findObjectById(chassis.getControllerId(), AbstractNode.class)) != null) {
                    this.addPair(i18n.tr("Controller"), node.getObjectName());
                }
                if (chassis.getPhysicalContainerId() == 0L || (rack = (Rack)session.findObjectById(chassis.getPhysicalContainerId(), Rack.class)) == null) break;
                this.addPair(i18n.tr("Rack"), String.format(i18n.tr("%s (units %d-%d)"), rack.getObjectName(), rack.isTopBottomNumbering() ? chassis.getRackPosition() : chassis.getRackPosition() - chassis.getRackHeight() + 1, rack.isTopBottomNumbering() ? chassis.getRackPosition() + chassis.getRackHeight() - 1 : chassis.getRackPosition()));
                break;
            }
            case 3: {
                Interface iface = (Interface)object;
                Interface parentIface = iface.getParentInterface();
                if (parentIface != null) {
                    this.addPair(i18n.tr("Parent interface"), parentIface.getObjectName());
                }
                this.addPair(i18n.tr("Interface index"), Integer.toString(iface.getIfIndex()));
                String typeName = iface.getIfTypeName();
                this.addPair(i18n.tr("Interface type"), typeName != null ? String.format("%d (%s)", iface.getIfType(), typeName) : Integer.toString(iface.getIfType()));
                this.addPair(i18n.tr("Description"), iface.getDescription(), false);
                this.addPair(i18n.tr("Interface alias"), iface.getIfAlias(), false);
                if (iface.getMtu() > 0) {
                    this.addPair(i18n.tr("MTU"), Integer.toString(iface.getMtu()));
                }
                if (iface.getSpeed() > 0L) {
                    this.addPair(i18n.tr("Speed"), InterfaceListLabelProvider.ifSpeedTotext((long)iface.getSpeed()));
                }
                this.addPair(i18n.tr("MAC address"), iface.getMacAddress().toString());
                String vendor = session.getVendorByMac(iface.getMacAddress(), null);
                if (vendor != null && !vendor.isEmpty()) {
                    this.addPair(i18n.tr("MAC Address Vendor"), vendor);
                }
                if (iface.isPhysicalPort()) {
                    this.addPair(i18n.tr("Physical location"), iface.getPhysicalLocation());
                    AbstractNode node = iface.getParentNode();
                    if (node != null && node.is8021xSupported()) {
                        this.addPair(i18n.tr("802.1x PAE state"), iface.getDot1xPaeStateAsText());
                        this.addPair(i18n.tr("802.1x backend state"), iface.getDot1xBackendStateAsText());
                    }
                }
                this.addPair("VLAN", InterfaceListLabelProvider.getVlanList((Interface)iface), false);
                if (iface.getIpAddressList().size() > 0) {
                    if (session.isZoningEnabled()) {
                        this.addPair(i18n.tr("Zone UIN"), this.getZoneName(iface.getZoneId()));
                    }
                    this.addPair(i18n.tr("IP address"), ((InetAddressEx)iface.getIpAddressList().get(0)).toString());
                    for (int i = 1; i < iface.getIpAddressList().size(); ++i) {
                        this.addPair("", ((InetAddressEx)iface.getIpAddressList().get(i)).toString());
                    }
                }
                if (iface.isOSPF()) {
                    this.addPair(i18n.tr("OSPF area"), iface.getOSPFArea().getHostAddress());
                    this.addPair(i18n.tr("OSPF interface type"), iface.getOSPFType().getText(), false);
                    this.addPair(i18n.tr("OSPF interface state"), iface.getOSPFState().getText(), false);
                }
                this.addPair(i18n.tr("Administrative state"), iface.getAdminStateAsText());
                this.addPair(i18n.tr("Operational state"), iface.getOperStateAsText());
                this.addPair(i18n.tr("Expected state"), ifaceExpectedState[iface.getExpectedState()]);
                break;
            }
            case 2: {
                Rack rack;
                AbstractNode node = (AbstractNode)object;
                if (session.isZoningEnabled()) {
                    this.addPair(i18n.tr("Zone UIN"), this.getZoneName(node.getZoneId()));
                }
                this.addPair(i18n.tr("Primary host name"), node.getPrimaryName());
                this.addPair(i18n.tr("Primary IP address"), node.getPrimaryIP().getHostAddress());
                this.addPair(i18n.tr("Node type"), node.getNodeType().toString(), false);
                this.addPair(i18n.tr("Hypervisor type"), node.getHypervisorType(), false);
                this.addPair(i18n.tr("Hypervisor information"), node.getHypervisorInformation(), false);
                this.addPair(i18n.tr("Vendor"), node.getHardwareVendor(), false);
                if ((node.getCapabilities() & 0x800000) != 0) {
                    this.addPair(i18n.tr("Device type"), node.getCipDeviceTypeName(), false);
                }
                this.addPair(i18n.tr("Product name"), node.getHardwareProductName(), false);
                this.addPair(i18n.tr("Product code"), node.getHardwareProductCode(), false);
                this.addPair(i18n.tr("Product version"), node.getHardwareProductVersion(), false);
                this.addPair(i18n.tr("Serial number"), node.getHardwareSerialNumber(), false);
                if (node.hasAgent()) {
                    this.addPair(i18n.tr("Hardware ID"), node.getHardwareIdAsText(), false);
                    this.addPair(i18n.tr("Agent version"), node.getAgentVersion());
                    if (node.getAgentId() != null) {
                        this.addPair(i18n.tr("Agent ID"), node.getAgentId().toString());
                    }
                }
                this.addPair(i18n.tr("System description"), node.getSystemDescription(), false);
                this.addPair(i18n.tr("Platform name"), node.getPlatformName(), false);
                this.addPair(i18n.tr("SNMP sysName"), node.getSnmpSysName(), false);
                this.addPair(i18n.tr("SNMP object ID"), node.getSnmpOID(), false);
                this.addPair(i18n.tr("SNMP sysLocation"), node.getSnmpSysLocation(), false);
                this.addPair(i18n.tr("SNMP sysContact"), node.getSnmpSysContact(), false);
                if (node.isBridge()) {
                    this.addPair(i18n.tr("Bridge base address"), node.getBridgeBaseAddress().toString());
                }
                if (node.isOSPF()) {
                    this.addPair(i18n.tr("OSPF router ID"), node.getOSPFRouterId().getHostAddress());
                }
                this.addPair(i18n.tr("Driver"), node.getDriverName(), false);
                if (node.getBootTime() != null) {
                    this.addPair(i18n.tr("Boot time"), DateFormatFactory.getDateTimeFormat().format(node.getBootTime()), false);
                }
                if (node.hasAgent()) {
                    this.addPair(i18n.tr("Agent status"), (node.getStateFlags() & 0x10000) != 0 ? i18n.tr("Unreachable") : i18n.tr("Connected"));
                }
                if (node.getLastAgentCommTime() != null) {
                    this.addPair(i18n.tr("Last agent contact"), DateFormatFactory.getDateTimeFormat().format(node.getLastAgentCommTime()), false);
                }
                if (node.getPhysicalContainerId() != 0L && (rack = (Rack)session.findObjectById(node.getPhysicalContainerId(), Rack.class)) != null) {
                    this.addPair(i18n.tr("Rack"), String.format(i18n.tr("%s (units %d-%d)"), rack.getObjectName(), rack.isTopBottomNumbering() ? node.getRackPosition() : node.getRackPosition() - node.getRackHeight() + 1, rack.isTopBottomNumbering() ? node.getRackPosition() + node.getRackHeight() - 1 : node.getRackPosition()));
                }
                if (!node.isIcmpStatisticsCollected()) break;
                this.addPair(i18n.tr("ICMP average response time"), node.getIcmpAverageResponseTime() + " ms");
                this.addPair(i18n.tr("ICMP packet loss"), node.getIcmpPacketLoss() + "%");
                break;
            }
            case 31: {
                MobileDevice md = (MobileDevice)object;
                if (md.getLastReportTime().getTime() == 0L) {
                    this.addPair(i18n.tr("Last report"), i18n.tr("Never"));
                } else {
                    this.addPair(i18n.tr("Last report"), DateFormatFactory.getDateTimeFormat().format(md.getLastReportTime()));
                }
                this.addPair(i18n.tr("Device ID"), md.getDeviceId());
                this.addPair(i18n.tr("Vendor"), md.getVendor());
                this.addPair(i18n.tr("Model"), md.getModel());
                this.addPair(i18n.tr("Serial number"), md.getSerialNumber());
                this.addPair(i18n.tr("Operating System"), md.getOsName());
                this.addPair(i18n.tr("Operating System Version"), md.getOsVersion());
                this.addPair(i18n.tr("User"), md.getUserId(), false);
                if (md.getBatteryLevel() < 0) break;
                this.addPair(i18n.tr("Battery level"), Integer.toString(md.getBatteryLevel()) + "%");
                break;
            }
            case 37: {
                Sensor sensor = (Sensor)object;
                this.addPair(i18n.tr("Device address"), sensor.getDeviceAddress(), false);
                if (sensor.getMacAddress() != null && !sensor.getMacAddress().isNull()) {
                    this.addPair(i18n.tr("MAC address"), sensor.getMacAddress().toString(), true);
                    String vendorMac = session.getVendorByMac(sensor.getMacAddress(), null);
                    if (vendorMac != null && !vendorMac.isEmpty()) {
                        this.addPair(i18n.tr("MAC Address Vendor"), vendorMac);
                    }
                }
                this.addPair(i18n.tr("Vendor"), sensor.getVendor(), true);
                this.addPair(i18n.tr("Device class"), Sensor.DEV_CLASS_NAMES[sensor.getDeviceClass()]);
                this.addPair(i18n.tr("Communication protocol"), Sensor.COMM_METHOD[sensor.getCommProtocol()]);
                this.addPair(i18n.tr("Serial number"), sensor.getSerialNumber(), true);
                this.addPair(i18n.tr("Meta type"), sensor.getMetaType(), true);
                this.addPair(i18n.tr("Description"), sensor.getDescription(), true);
                if (sensor.getFrameCount() != 0) {
                    this.addPair(i18n.tr("Frame count"), Integer.toString(sensor.getFrameCount()));
                }
                if (sensor.getSignalStrenght() != 1) {
                    this.addPair(i18n.tr("RSSI"), Integer.toString(sensor.getSignalStrenght()));
                }
                if (sensor.getSignalNoise() != Integer.MAX_VALUE) {
                    this.addPair(i18n.tr("SNR"), Double.toString((double)sensor.getSignalNoise() / 10.0));
                }
                if (sensor.getFrequency() == 0) break;
                this.addPair(i18n.tr("Frequency"), Double.toString((double)sensor.getFrequency() / 10.0));
                break;
            }
            case 33: {
                AccessPoint ap = (AccessPoint)object;
                this.addPair(i18n.tr("State"), ap.getState().toString());
                this.addPair(i18n.tr("Vendor"), ap.getVendor());
                this.addPair(i18n.tr("Model"), ap.getModel());
                this.addPair(i18n.tr("Serial number"), ap.getSerialNumber());
                this.addPair(i18n.tr("MAC address"), ap.getMacAddress().toString());
                String vendorMac = session.getVendorByMac(ap.getMacAddress(), null);
                if (vendorMac != null && !vendorMac.isEmpty()) {
                    this.addPair(i18n.tr("MAC Address Vendor"), vendorMac);
                }
                if (!ap.getIpAddress().isValidAddress()) break;
                this.addPair(i18n.tr("IP address"), ap.getIpAddress().getHostAddress());
                break;
            }
            case 1: {
                Subnet subnet = (Subnet)object;
                if (session.isZoningEnabled()) {
                    this.addPair(i18n.tr("Zone UIN"), this.getZoneName(subnet.getZoneId()));
                }
                this.addPair(i18n.tr("IP address"), subnet.getNetworkAddress().toString());
                break;
            }
            case 8: {
                Template template = (Template)object;
                this.addPair(i18n.tr("Number of DCIs"), Integer.toString(template.getNumDataCollectionItems()));
                this.addPair(i18n.tr("Number of policies"), Integer.toString(template.getNumPolicies()));
                break;
            }
            case 6: {
                Zone zone = (Zone)object;
                this.addPair(i18n.tr("Zone UIN"), Long.toString(zone.getUIN()));
                break;
            }
            case 28: {
                BusinessService businessService = (BusinessService)object;
                this.addPair(i18n.tr("Service state"), businessService.getServiceState().toString());
                break;
            }
            case 14: {
                Cluster cluster = (Cluster)object;
                if (!session.isZoningEnabled()) break;
                this.addPair(i18n.tr("Zone UIN"), this.getZoneName(cluster.getZoneId()));
                break;
            }
        }
        if (object instanceof DataCollectionTarget) {
            this.addPair(i18n.tr("Number of DCIs"), Integer.toString(((DataCollectionTarget)object).getNumDataCollectionItems()));
        }
        if (object.getGeolocation().getType() != 0) {
            this.addPair(i18n.tr("Location"), object.getGeolocation().toString());
            if (object instanceof MobileDevice) {
                MobileDevice md = (MobileDevice)object;
                if (md.getSpeed() >= 0.0f) {
                    this.addPair(i18n.tr("Speed"), Double.toString(md.getSpeed()) + " km/h");
                }
                if (md.getDirection() >= 0) {
                    this.addPair(i18n.tr("Direction"), Integer.toString(md.getDirection()) + "\u00b0");
                }
                this.addPair(i18n.tr("Altitude"), Integer.toString(md.getAltitude()) + " m");
            }
        }
        if (!object.getPostalAddress().isEmpty()) {
            this.addPair(i18n.tr("Postal Address"), object.getPostalAddress().getAddressLine());
        }
    }

    protected String getTitle() {
        return i18n.tr("General");
    }

    private String getZoneName(int zoneId) {
        Zone zone = Registry.getSession().findZone(zoneId);
        if (zone == null) {
            return Long.toString(zoneId);
        }
        return String.format("%d (%s)", zoneId, zone.getObjectName());
    }
}

