/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import java.util.Date;
import org.netxms.base.NXCPMessage;
import org.netxms.client.NCConfigurationTemplate;

public class NotificationChannel {
    public static final int SEND_STATUS_UNKNOWN = 0;
    public static final int SEND_STATUS_SUCCESS = 1;
    public static final int SEND_STATUS_FAILURE = 2;
    private String name;
    private String description;
    private String driverName;
    private String configuration;
    private boolean isActive;
    private NCConfigurationTemplate configurationTemplate;
    private String errorMessage;
    private int sendStatus;
    private boolean healthCheckStatus;
    private Date lastMessageTimestamp;
    private int messageCount;
    private int failureCount;

    protected NotificationChannel(NXCPMessage msg2, long baseId) {
        this.name = msg2.getFieldAsString(baseId);
        this.description = msg2.getFieldAsString(baseId + 1L);
        this.driverName = msg2.getFieldAsString(baseId + 2L);
        this.configuration = msg2.getFieldAsString(baseId + 3L);
        this.isActive = msg2.getFieldAsBoolean(baseId + 4L);
        this.configurationTemplate = new NCConfigurationTemplate(msg2, baseId + 5L);
        this.errorMessage = msg2.getFieldAsString(baseId + 7L);
        this.sendStatus = msg2.getFieldAsInt32(baseId + 8L);
        this.healthCheckStatus = msg2.getFieldAsBoolean(baseId + 9L);
        this.lastMessageTimestamp = msg2.getFieldAsDate(baseId + 10L);
        this.messageCount = msg2.getFieldAsInt32(baseId + 11L);
        this.failureCount = msg2.getFieldAsInt32(baseId + 12L);
    }

    public NotificationChannel() {
        this.name = "";
        this.description = "";
        this.driverName = null;
        this.configuration = "";
        this.isActive = false;
        this.configurationTemplate = null;
    }

    public void fillMessage(NXCPMessage msg2) {
        msg2.setField(20L, this.name);
        msg2.setField(27L, this.description);
        msg2.setField(380L, this.driverName);
        msg2.setField(584L, this.configuration);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    public NCConfigurationTemplate getConfigurationTemplate() {
        return this.configurationTemplate;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getSendStatus() {
        return this.sendStatus;
    }

    public boolean getHealthCheckStatus() {
        return this.healthCheckStatus;
    }

    public Date getLastMessageTimestamp() {
        return this.lastMessageTimestamp;
    }

    public int getMessageCount() {
        return this.messageCount;
    }

    public int getFailureCount() {
        return this.failureCount;
    }
}

