/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import org.netxms.base.NXCPMessage;
import org.netxms.client.constants.DataType;
import org.netxms.client.datacollection.MeasurementUnit;

public class TableColumnDefinition {
    private String name;
    private String displayName;
    private DataType dataType;
    private boolean instanceColumn;
    private MeasurementUnit measurementUnit;

    public TableColumnDefinition(String name, String displayName, DataType dataType, boolean instanceColumn) {
        this.name = name;
        this.displayName = displayName != null ? displayName : name;
        this.dataType = dataType;
        this.instanceColumn = instanceColumn;
        this.measurementUnit = null;
    }

    protected TableColumnDefinition(NXCPMessage msg2, long baseId) {
        this.name = msg2.getFieldAsString(baseId);
        this.dataType = DataType.getByValue(msg2.getFieldAsInt32(baseId + 1L));
        this.displayName = msg2.getFieldAsString(baseId + 2L);
        if (this.displayName == null) {
            this.displayName = this.name;
        }
        this.instanceColumn = msg2.getFieldAsBoolean(baseId + 3L);
        this.measurementUnit = new MeasurementUnit(msg2, baseId + 4L);
    }

    protected void fillMessage(NXCPMessage msg2, long baseId) {
        msg2.setField(baseId, this.name);
        msg2.setFieldInt32(baseId + 1L, this.dataType.getValue());
        msg2.setField(baseId + 2L, this.displayName);
        msg2.setFieldInt16(baseId + 3L, this.instanceColumn ? 1 : 0);
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public boolean isInstanceColumn() {
        return this.instanceColumn;
    }

    public MeasurementUnit getMeasurementUnit() {
        return this.measurementUnit;
    }
}

