/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.events;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.netxms.base.NXCPMessage;
import org.netxms.client.constants.Severity;
import org.netxms.client.events.ActionExecutionConfiguration;
import org.netxms.client.events.TimeFrame;

public class EventProcessingPolicyRule {
    public static final int STOP_PROCESSING = 1;
    public static final int NEGATED_SOURCE = 2;
    public static final int NEGATED_EVENTS = 4;
    public static final int GENERATE_ALARM = 8;
    public static final int DISABLED = 16;
    public static final int TERMINATE_BY_REGEXP = 32;
    public static final int SEVERITY_NORMAL = 256;
    public static final int SEVERITY_WARNING = 512;
    public static final int SEVERITY_MINOR = 1024;
    public static final int SEVERITY_MAJOR = 2048;
    public static final int SEVERITY_CRITICAL = 4096;
    public static final int CREATE_TICKET = 8192;
    public static final int ACCEPT_CORRELATED = 16384;
    public static final int NEGATED_TIME_FRAMES = 32768;
    public static final int SEVERITY_ANY = 7936;
    private UUID guid;
    private List<Long> sources;
    private List<Long> sourceExclusions;
    private List<Long> events;
    private String filterScript;
    private List<TimeFrame> timeFrames;
    private int flags;
    private String alarmKey;
    private String alarmMessage;
    private Severity alarmSeverity;
    private int alarmTimeout;
    private long alarmTimeoutEvent;
    private List<Long> alarmCategoryIds;
    private String rcaScriptName;
    private String actionScript;
    private List<ActionExecutionConfiguration> actions;
    private List<String> timerCancellations;
    private Map<String, String> persistentStorageSet;
    private List<String> persistentStorageDelete;
    private Map<String, String> customAttributeStorageSet;
    private List<String> customAttributeStorageDelete;
    private String comments;
    private int ruleNumber;

    public EventProcessingPolicyRule() {
        this.guid = UUID.randomUUID();
        this.sources = new ArrayList<Long>(0);
        this.sourceExclusions = new ArrayList<Long>(0);
        this.events = new ArrayList<Long>(0);
        this.filterScript = "";
        this.timeFrames = new ArrayList<TimeFrame>();
        this.flags = 7936;
        this.alarmKey = "";
        this.alarmMessage = "%m";
        this.alarmSeverity = Severity.UNKNOWN;
        this.alarmTimeout = 0;
        this.alarmTimeoutEvent = 43L;
        this.alarmCategoryIds = new ArrayList<Long>(0);
        this.rcaScriptName = null;
        this.actionScript = null;
        this.actions = new ArrayList<ActionExecutionConfiguration>(0);
        this.timerCancellations = new ArrayList<String>(0);
        this.persistentStorageSet = new HashMap<String, String>(0);
        this.persistentStorageDelete = new ArrayList<String>(0);
        this.customAttributeStorageSet = new HashMap<String, String>(0);
        this.customAttributeStorageDelete = new ArrayList<String>(0);
        this.comments = "";
        this.ruleNumber = 0;
    }

    public EventProcessingPolicyRule(EventProcessingPolicyRule src) {
        this.guid = UUID.randomUUID();
        this.sources = new ArrayList<Long>(src.sources);
        this.sourceExclusions = new ArrayList<Long>(src.sourceExclusions);
        this.events = new ArrayList<Long>(src.events);
        this.filterScript = src.filterScript;
        for (TimeFrame timeFrame : src.timeFrames) {
            this.timeFrames.add(new TimeFrame(timeFrame));
        }
        this.flags = src.flags;
        this.alarmKey = src.alarmKey;
        this.alarmMessage = src.alarmMessage;
        this.alarmSeverity = src.alarmSeverity;
        this.alarmTimeout = src.alarmTimeout;
        this.alarmTimeoutEvent = src.alarmTimeoutEvent;
        this.alarmCategoryIds = src.alarmCategoryIds;
        this.rcaScriptName = src.rcaScriptName;
        this.actionScript = src.actionScript;
        this.actions = new ArrayList<ActionExecutionConfiguration>(src.actions.size());
        for (ActionExecutionConfiguration actionExecutionConfiguration : src.actions) {
            this.actions.add(new ActionExecutionConfiguration(actionExecutionConfiguration));
        }
        this.timerCancellations = new ArrayList<String>(src.timerCancellations);
        this.persistentStorageSet = new HashMap<String, String>(src.persistentStorageSet);
        this.persistentStorageDelete = new ArrayList<String>(src.persistentStorageDelete);
        this.customAttributeStorageSet = new HashMap<String, String>(src.customAttributeStorageSet);
        this.customAttributeStorageDelete = new ArrayList<String>(src.customAttributeStorageDelete);
        this.comments = src.comments;
        this.ruleNumber = src.ruleNumber;
    }

    public EventProcessingPolicyRule(NXCPMessage msg2, int ruleNumber) {
        this.guid = msg2.getFieldAsUUID(222L);
        this.sources = Arrays.asList(msg2.getFieldAsUInt32ArrayEx(71L));
        this.sourceExclusions = Arrays.asList(msg2.getFieldAsUInt32ArrayEx(808L));
        this.events = Arrays.asList(msg2.getFieldAsUInt32ArrayEx(72L));
        this.filterScript = msg2.getFieldAsString(228L);
        int frameCount = msg2.getFieldAsInt32(812L);
        this.timeFrames = new ArrayList<TimeFrame>(frameCount);
        long fieldId = 0x70000000L;
        for (int i = 0; i < frameCount; ++i) {
            this.timeFrames.add(new TimeFrame(msg2.getFieldAsInt32(fieldId++), msg2.getFieldAsInt64(fieldId++)));
        }
        this.flags = msg2.getFieldAsInt32(13L);
        this.alarmKey = msg2.getFieldAsString(64L);
        this.alarmMessage = msg2.getFieldAsString(66L);
        this.alarmSeverity = Severity.getByValue(msg2.getFieldAsInt32(63L));
        this.alarmTimeout = msg2.getFieldAsInt32(65L);
        this.alarmTimeoutEvent = msg2.getFieldAsInt64(283L);
        this.alarmCategoryIds = Arrays.asList(msg2.getFieldAsUInt32ArrayEx(555L));
        this.rcaScriptName = msg2.getFieldAsString(670L);
        this.actionScript = msg2.getFieldAsString(805L);
        this.comments = msg2.getFieldAsString(82L);
        int actionCount = msg2.getFieldAsInt32(70L);
        this.actions = new ArrayList<ActionExecutionConfiguration>(actionCount);
        fieldId = 0x50000000L;
        for (int i = 0; i < actionCount; ++i) {
            this.actions.add(new ActionExecutionConfiguration(msg2, fieldId));
            fieldId += 10L;
        }
        this.timerCancellations = msg2.getStringListFromFields(0x60000000L, 624L);
        this.persistentStorageSet = msg2.getStringMapFromFields(0x10000000L, 305L);
        this.persistentStorageDelete = msg2.getStringListFromFields(0x20000000L, 303L);
        this.customAttributeStorageSet = msg2.getStringMapFromFields(0x30000000L, 806L);
        this.customAttributeStorageDelete = msg2.getStringListFromFields(0x40000000L, 807L);
        this.ruleNumber = ruleNumber;
    }

    public void fillMessage(NXCPMessage msg2) {
        msg2.setField(222L, this.guid);
        msg2.setFieldInt32(13L, this.flags);
        msg2.setField(82L, this.comments);
        msg2.setField(228L, this.filterScript);
        msg2.setFieldInt32(70L, this.actions.size());
        long fieldId = 0x50000000L;
        for (ActionExecutionConfiguration d : this.actions) {
            d.fillMessage(msg2, fieldId);
            fieldId += 10L;
        }
        msg2.setFieldsFromStringCollection(this.timerCancellations, 0x60000000L, 624L);
        msg2.setField(72L, this.events.toArray(new Long[this.events.size()]));
        msg2.setField(71L, this.sources.toArray(new Long[this.sources.size()]));
        msg2.setField(808L, this.sourceExclusions.toArray(new Long[this.sourceExclusions.size()]));
        msg2.setFieldInt32(812L, this.timeFrames.size());
        fieldId = 0x70000000L;
        for (TimeFrame frame : this.timeFrames) {
            frame.fillMessage(msg2, fieldId);
            fieldId += 2L;
        }
        msg2.setField(64L, this.alarmKey);
        msg2.setField(66L, this.alarmMessage);
        msg2.setFieldInt16(63L, this.alarmSeverity.getValue());
        msg2.setFieldInt32(65L, this.alarmTimeout);
        msg2.setFieldInt32(283L, (int)this.alarmTimeoutEvent);
        msg2.setField(555L, this.alarmCategoryIds.toArray(new Long[this.alarmCategoryIds.size()]));
        msg2.setField(670L, this.rcaScriptName);
        msg2.setField(805L, this.actionScript);
        msg2.setFieldsFromStringMap(this.persistentStorageSet, 0x10000000L, 305L);
        msg2.setFieldsFromStringCollection(this.persistentStorageDelete, 0x20000000L, 303L);
        msg2.setFieldsFromStringMap(this.customAttributeStorageSet, 0x30000000L, 806L);
        msg2.setFieldsFromStringCollection(this.customAttributeStorageDelete, 0x40000000L, 807L);
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public String getFilterScript() {
        return this.filterScript;
    }

    public void setFilterScript(String script) {
        this.filterScript = script;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public String getAlarmKey() {
        return this.alarmKey;
    }

    public void setAlarmKey(String alarmKey) {
        this.alarmKey = alarmKey;
    }

    public String getAlarmMessage() {
        return this.alarmMessage;
    }

    public void setAlarmMessage(String alarmMessage) {
        this.alarmMessage = alarmMessage;
    }

    public Severity getAlarmSeverity() {
        return this.alarmSeverity;
    }

    public void setAlarmSeverity(Severity alarmSeverity) {
        this.alarmSeverity = alarmSeverity;
    }

    public int getAlarmTimeout() {
        return this.alarmTimeout;
    }

    public void setAlarmTimeout(int alarmTimeout) {
        this.alarmTimeout = alarmTimeout;
    }

    public long getAlarmTimeoutEvent() {
        return this.alarmTimeoutEvent;
    }

    public void setAlarmTimeoutEvent(long alarmTimeoutEvent) {
        this.alarmTimeoutEvent = alarmTimeoutEvent;
    }

    public List<Long> getAlarmCategories() {
        return this.alarmCategoryIds;
    }

    public void setAlarmCategories(List<Long> alarmCategoryIds) {
        this.alarmCategoryIds = alarmCategoryIds;
    }

    public void removeAlarmCategory(Long categoryId) {
        for (int i = 0; i < this.alarmCategoryIds.size(); ++i) {
            if (this.alarmCategoryIds.get(i) != categoryId) continue;
            this.alarmCategoryIds.remove(i);
            break;
        }
    }

    public String getRcaScriptName() {
        return this.rcaScriptName;
    }

    public void setRcaScriptName(String rcaScriptName) {
        this.rcaScriptName = rcaScriptName;
    }

    public List<Long> getSources() {
        return this.sources;
    }

    public List<Long> getSourceExclusions() {
        return this.sourceExclusions;
    }

    public void setSourceExclusions(List<Long> sourceExclusions) {
        this.sourceExclusions = sourceExclusions;
    }

    public List<Long> getEvents() {
        return this.events;
    }

    public List<ActionExecutionConfiguration> getActions() {
        return this.actions;
    }

    public Map<String, String> getPStorageSet() {
        return this.persistentStorageSet;
    }

    public List<String> getPStorageDelete() {
        return this.persistentStorageDelete;
    }

    public void setSources(List<Long> sources) {
        this.sources = sources;
    }

    public void setEvents(List<Long> events) {
        this.events = events;
    }

    public void setActions(List<ActionExecutionConfiguration> actions) {
        this.actions = actions;
    }

    public List<String> getTimerCancellations() {
        return this.timerCancellations;
    }

    public void setTimerCancellations(List<String> timerCancellations) {
        this.timerCancellations = timerCancellations;
    }

    public void setPStorageSet(Map<String, String> persistentStorageSet) {
        this.persistentStorageSet = persistentStorageSet;
    }

    public void setPStorageDelete(List<String> persistentStorageDelete) {
        this.persistentStorageDelete = persistentStorageDelete;
    }

    public boolean isDisabled() {
        return (this.flags & 0x10) != 0;
    }

    public boolean isSourceInverted() {
        return (this.flags & 2) != 0;
    }

    public boolean isEventsInverted() {
        return (this.flags & 4) != 0;
    }

    public boolean isTimeFramesInverted() {
        return (this.flags & 0x8000) != 0;
    }

    public UUID getGuid() {
        return this.guid;
    }

    public int getRuleNumber() {
        return this.ruleNumber;
    }

    public void setRuleNumber(int ruleNumber) {
        this.ruleNumber = ruleNumber;
    }

    public String getActionScript() {
        return this.actionScript;
    }

    public void setActionScript(String actionScript) {
        this.actionScript = actionScript;
    }

    public Map<String, String> getCustomAttributeStorageSet() {
        return this.customAttributeStorageSet;
    }

    public void setCustomAttributeStorageSet(Map<String, String> customAttributeStorageSet) {
        this.customAttributeStorageSet = customAttributeStorageSet;
    }

    public List<String> getCustomAttributeStorageDelete() {
        return this.customAttributeStorageDelete;
    }

    public void setCustomAttributeStorageDelete(List<String> customAttributeStorageDelete) {
        this.customAttributeStorageDelete = customAttributeStorageDelete;
    }

    public List<TimeFrame> getTimeFrames() {
        return this.timeFrames;
    }

    public void setTimeFrames(List<TimeFrame> timeFrames) {
        this.timeFrames = timeFrames;
    }
}

