/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objects;

import java.util.HashSet;
import java.util.Set;
import org.netxms.base.InetAddressEx;
import org.netxms.base.MacAddress;
import org.netxms.base.NXCPMessage;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.AccessPointState;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.DataCollectionTarget;
import org.netxms.client.objects.interfaces.NodeChild;
import org.netxms.client.topology.RadioInterface;

public class AccessPoint
extends DataCollectionTarget
implements NodeChild {
    private long nodeId;
    private int index;
    private MacAddress macAddress;
    private InetAddressEx ipAddress;
    private AccessPointState state;
    private String vendor;
    private String model;
    private String serialNumber;
    private RadioInterface[] radios;

    public AccessPoint(NXCPMessage msg2, NXCSession session) {
        super(msg2, session);
        this.nodeId = msg2.getFieldAsInt64(393L);
        this.index = msg2.getFieldAsInt32(495L);
        this.macAddress = new MacAddress(msg2.getFieldAsBinary(113L));
        this.ipAddress = msg2.getFieldAsInetAddressEx(8L);
        this.state = AccessPointState.getByValue(msg2.getFieldAsInt32(243L));
        this.vendor = msg2.getFieldAsString(428L);
        this.model = msg2.getFieldAsString(429L);
        this.serialNumber = msg2.getFieldAsString(432L);
        int count2 = msg2.getFieldAsInt32(442L);
        this.radios = new RadioInterface[count2];
        long fieldId = 0x30000000L;
        for (int i = 0; i < count2; ++i) {
            this.radios[i] = new RadioInterface(this, msg2, fieldId);
            fieldId += 10L;
        }
    }

    @Override
    public String getObjectClassName() {
        return "AccessPoint";
    }

    @Override
    public boolean isAllowedOnMap() {
        return true;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public int getIndex() {
        return this.index;
    }

    public MacAddress getMacAddress() {
        return this.macAddress;
    }

    public InetAddressEx getIpAddress() {
        return this.ipAddress;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getModel() {
        return this.model;
    }

    public RadioInterface[] getRadios() {
        return this.radios;
    }

    public AccessPointState getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractNode getParentNode() {
        AbstractNode node = null;
        HashSet hashSet = this.parents;
        synchronized (hashSet) {
            for (Long id : this.parents) {
                AbstractObject object = this.session.findObjectById(id);
                if (!(object instanceof AbstractNode)) continue;
                node = (AbstractNode)object;
                break;
            }
        }
        return node;
    }

    @Override
    public Set<String> getStrings() {
        Set<String> strings = super.getStrings();
        AccessPoint.addString(strings, this.model);
        AccessPoint.addString(strings, this.serialNumber);
        AccessPoint.addString(strings, this.vendor);
        return strings;
    }
}

