/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objects;

import java.util.Set;
import org.netxms.base.NXCPMessage;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.AgentCacheMode;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objects.interfaces.AutoBindDCIObject;
import org.netxms.client.objects.interfaces.AutoBindObject;
import org.netxms.client.objects.interfaces.PollingTarget;

public class BaseBusinessService
extends GenericObject
implements AutoBindObject,
AutoBindDCIObject,
PollingTarget {
    private int autoBindFlags;
    private String objectAutoBindFilter;
    private String dciAutoBindFilter;
    private int objectStatusThreshold;
    private int dciStatusThreshold;

    public BaseBusinessService(NXCPMessage msg2, NXCSession session) {
        super(msg2, session);
        this.objectAutoBindFilter = msg2.getFieldAsString(321L);
        this.autoBindFlags = msg2.getFieldAsInt32(625L);
        this.objectStatusThreshold = msg2.getFieldAsInt32(773L);
        this.dciAutoBindFilter = msg2.getFieldAsString(626L);
        this.dciStatusThreshold = msg2.getFieldAsInt32(774L);
    }

    @Override
    public int getAutoBindFlags() {
        return this.autoBindFlags;
    }

    @Override
    public boolean isAutoBindEnabled() {
        return (this.autoBindFlags & 1) > 0;
    }

    @Override
    public boolean isAutoUnbindEnabled() {
        return (this.autoBindFlags & 2) > 0;
    }

    @Override
    public String getAutoBindFilter() {
        return this.objectAutoBindFilter;
    }

    @Override
    public boolean isDciAutoBindEnabled() {
        return (this.autoBindFlags & 4) > 0;
    }

    @Override
    public boolean isDciAutoUnbindEnabled() {
        return (this.autoBindFlags & 8) > 0;
    }

    @Override
    public String getDciAutoBindFilter() {
        return this.dciAutoBindFilter;
    }

    @Override
    public int getIfXTablePolicy() {
        return 0;
    }

    @Override
    public AgentCacheMode getAgentCacheMode() {
        return null;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public long getPollerNodeId() {
        return 0L;
    }

    @Override
    public boolean canHaveAgent() {
        return false;
    }

    @Override
    public boolean canHaveInterfaces() {
        return false;
    }

    @Override
    public boolean canHavePollerNode() {
        return false;
    }

    @Override
    public boolean canUseEtherNetIP() {
        return false;
    }

    public int getDciStatusThreshold() {
        return this.dciStatusThreshold;
    }

    public int getObjectStatusThreshold() {
        return this.objectStatusThreshold;
    }

    @Override
    public Set<String> getStrings() {
        Set<String> strings = super.getStrings();
        BaseBusinessService.addString(strings, this.objectAutoBindFilter);
        BaseBusinessService.addString(strings, this.dciAutoBindFilter);
        return strings;
    }
}

