/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.search;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netxms.client.search.SearchAttributeProvider;

public class SearchQuery {
    private Set<String> includedTexts = null;
    private Set<String> excludedTexts = null;
    private Map<String, Set<String>> includedAttributes = null;
    private Map<String, Set<String>> excludedAttributes = null;

    public SearchQuery(String source) {
        char[] input = source.toCharArray();
        int start = -1;
        int state = 0;
        boolean negateNext = false;
        Set<String> attributeValues = null;
        block6: for (int position = 0; position <= input.length; ++position) {
            int ch = position < input.length ? input[position] : 32;
            switch (state) {
                case 0: {
                    if (ch == 34) {
                        state = 3;
                        start = position + 1;
                        continue block6;
                    }
                    if (Character.isWhitespace(ch)) continue block6;
                    state = 1;
                    start = position;
                    continue block6;
                }
                case 1: {
                    Map<String, Set<String>> attributes;
                    if (Character.isWhitespace(ch)) {
                        String text2 = new String(input, start, position - start);
                        if (text2.equalsIgnoreCase("not")) {
                            negateNext = true;
                        } else if (negateNext) {
                            if (this.excludedTexts == null) {
                                this.excludedTexts = new HashSet<String>();
                            }
                            this.excludedTexts.add(text2.toLowerCase());
                            negateNext = false;
                        } else {
                            if (this.includedTexts == null) {
                                this.includedTexts = new HashSet<String>();
                            }
                            this.includedTexts.add(text2.toLowerCase());
                        }
                        state = 0;
                        continue block6;
                    }
                    if (ch != 58) continue block6;
                    if (input[start] == '-' || negateNext) {
                        if (this.excludedAttributes == null) {
                            this.excludedAttributes = new HashMap<String, Set<String>>();
                        }
                        attributes = this.excludedAttributes;
                        if (input[start] == '-') {
                            ++start;
                        }
                        negateNext = false;
                    } else {
                        if (this.includedAttributes == null) {
                            this.includedAttributes = new HashMap<String, Set<String>>();
                        }
                        attributes = this.includedAttributes;
                    }
                    String name = new String(input, start, position - start).toLowerCase();
                    attributeValues = attributes.get(name);
                    if (attributeValues == null) {
                        attributeValues = new HashSet<String>();
                        attributes.put(name, attributeValues);
                    }
                    start = position + 1;
                    state = 2;
                    continue block6;
                }
                case 2: {
                    if (!Character.isWhitespace(ch) && ch != 44) continue block6;
                    String v = new String(input, start, position - start).toLowerCase();
                    if (!v.isEmpty()) {
                        attributeValues.add(v);
                    }
                    if (ch == 44) {
                        start = position + 1;
                        continue block6;
                    }
                    state = 0;
                    continue block6;
                }
                case 3: {
                    if (ch != 34) continue block6;
                    if (negateNext) {
                        if (this.excludedTexts == null) {
                            this.excludedTexts = new HashSet<String>();
                        }
                        this.excludedTexts.add(new String(input, start, position - start).toLowerCase());
                        negateNext = false;
                    } else {
                        if (this.includedTexts == null) {
                            this.includedTexts = new HashSet<String>();
                        }
                        this.includedTexts.add(new String(input, start, position - start).toLowerCase());
                    }
                    state = 0;
                }
            }
        }
    }

    public boolean match(Object object) {
        String text2;
        String string2 = text2 = object instanceof SearchAttributeProvider ? ((SearchAttributeProvider)object).getText().toLowerCase() : object.toString().toLowerCase();
        if (this.excludedTexts != null) {
            for (String string3 : this.excludedTexts) {
                if (!text2.contains(string3)) continue;
                return false;
            }
        }
        if (this.includedTexts != null) {
            for (String string4 : this.includedTexts) {
                if (text2.contains(string4)) continue;
                return false;
            }
        }
        if (object instanceof SearchAttributeProvider) {
            String value;
            if (this.excludedAttributes != null) {
                for (Map.Entry entry : this.excludedAttributes.entrySet()) {
                    value = ((SearchAttributeProvider)object).getAttribute((String)entry.getKey());
                    if (value == null || !((Set)entry.getValue()).contains(value.toLowerCase())) continue;
                    return false;
                }
            }
            if (this.includedAttributes != null) {
                for (Map.Entry entry : this.includedAttributes.entrySet()) {
                    value = ((SearchAttributeProvider)object).getAttribute((String)entry.getKey());
                    if (value != null && ((Set)entry.getValue()).contains(value.toLowerCase())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public String toString() {
        return "SearchQuery [includedTexts=" + this.includedTexts + ", excludedTexts=" + this.excludedTexts + ", includedAttributes=" + this.includedAttributes + ", excludedAttributes=" + this.excludedAttributes + "]";
    }
}

