/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.server;

import java.util.Date;
import java.util.List;
import org.netxms.base.NXCPMessage;
import org.netxms.client.AgentFileInfo;
import org.netxms.client.server.RemoteFile;

public class AgentFile
implements RemoteFile {
    public static final int FILE = 1;
    public static final int DIRECTORY = 2;
    public static final int SYMBOLYC_LINK = 4;
    public static final int PLACEHOLDER = 65536;
    private String name;
    private long size;
    private Date modificationTime;
    private String extension;
    private int type = 0;
    private String owner;
    private String group;
    private String accessRights;
    private List<AgentFile> children;
    private AgentFile parent;
    private long nodeId;
    private AgentFileInfo info;

    public AgentFile(NXCPMessage msg2, long baseId, AgentFile parent, long nodeId) {
        this.name = msg2.getFieldAsString(baseId);
        this.size = msg2.getFieldAsInt64(baseId + 1L);
        this.modificationTime = msg2.getFieldAsDate(baseId + 2L);
        this.type = (int)msg2.getFieldAsInt64(baseId + 3L);
        this.owner = msg2.getFieldAsString(baseId + 5L);
        this.group = msg2.getFieldAsString(baseId + 6L);
        this.accessRights = msg2.getFieldAsString(baseId + 7L);
        this.parent = parent;
        this.nodeId = nodeId;
        this.setExtension();
    }

    public AgentFile(String name, int fileType, AgentFile parent, long nodeId) {
        this.name = name;
        this.type = fileType;
        this.parent = parent;
        this.nodeId = nodeId;
        this.modificationTime = new Date();
        this.setExtension();
    }

    public AgentFile(AgentFile src) {
        this.name = src.name;
        this.size = src.size;
        this.modificationTime = src.modificationTime;
        this.type = src.type;
        this.owner = src.owner;
        this.group = src.group;
        this.accessRights = src.accessRights;
        this.nodeId = src.nodeId;
        this.setExtension();
    }

    private void setExtension() {
        if (this.isDirectory() || this.name.startsWith(".")) {
            this.extension = " ";
            return;
        }
        String[] parts = this.name.split("\\.");
        this.extension = parts.length > 1 ? parts[parts.length - 1] : " ";
    }

    @Override
    public boolean isDirectory() {
        return (this.type & 2) > 0;
    }

    @Override
    public boolean isPlaceholder() {
        return (this.type & 0x10000) > 0;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.setExtension();
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public Date getModificationTime() {
        return this.modificationTime;
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    public List<AgentFile> getChildren() {
        return this.children;
    }

    public void setChildren(List<AgentFile> children) {
        this.children = children;
    }

    public void removeChild(AgentFile child) {
        if (this.children == null) {
            return;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            if (!this.children.get(i).getName().equalsIgnoreCase(child.getName())) continue;
            this.children.remove(i);
        }
    }

    public void addChild(AgentFile child) {
        if (this.children == null) {
            return;
        }
        boolean childReplaced = false;
        for (int i = 0; i < this.children.size(); ++i) {
            if (!this.children.get(i).getName().equalsIgnoreCase(child.getName())) continue;
            if (child.getType() != 2) {
                this.children.set(i, child);
            }
            childReplaced = true;
            break;
        }
        if (!childReplaced) {
            this.children.add(child);
        }
    }

    public String getFullName() {
        if (this.parent == null) {
            return this.name;
        }
        String parentName = this.parent.getFullName();
        return parentName.endsWith("/") || parentName.endsWith("\\") ? parentName + this.name : parentName + "/" + this.name;
    }

    public String getFilePath() {
        if (this.parent == null) {
            return this.name;
        }
        return this.parent.getFilePath() + (this.parent.getFilePath().endsWith("/") || this.parent.getFilePath().endsWith("\\") ? "" : (this.parent.getFilePath().contains("\\") || this.parent.getFilePath().contains(":") ? "\\" : "/")) + this.name;
    }

    public AgentFile getParent() {
        return this.parent;
    }

    public void setParent(AgentFile parent) {
        this.parent = parent;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public int getType() {
        return this.type;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getAccessRights() {
        return this.accessRights;
    }

    public void setAccessRights(String accessRights) {
        this.accessRights = accessRights;
    }

    public void setFileInfo(AgentFileInfo info) {
        this.info = info;
    }

    public AgentFileInfo getFileInfo() {
        return this.info;
    }
}

