/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.websvc.json.adapters;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Type;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.client.datacollection.DataCollectionObject;
import org.netxms.client.datacollection.DataCollectionTable;
import org.netxms.websvc.json.JsonTools;

public class DataCollectionObjectDeserializer
implements JsonDeserializer<DataCollectionObject> {
    private Gson gson;

    public DataCollectionObject deserialize(JsonElement src, Type typeOfSrc, JsonDeserializationContext context) throws JsonParseException {
        String stype;
        JsonObject jsonObject = src.getAsJsonObject();
        JsonPrimitive type = jsonObject.getAsJsonPrimitive("valueType");
        if (type == null) {
            throw new JsonParseException("Missing mandatory attribute \"valueType\"");
        }
        if (this.gson == null) {
            this.gson = JsonTools.createGsonInstance(DataCollectionObjectDeserializer.class);
        }
        if ("single".equals(stype = type.getAsString())) {
            return (DataCollectionObject)this.gson.fromJson(src, DataCollectionItem.class);
        }
        if ("table".equals(stype)) {
            return (DataCollectionObject)this.gson.fromJson(src, DataCollectionTable.class);
        }
        throw new JsonParseException("Invalid value of mandatory attribute \"valueType\"");
    }
}

