/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages.helpers;

import java.util.HashSet;
import java.util.Map;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.configs.CustomAttribute;
import org.netxms.ui.eclipse.console.resources.ThemeEngine;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class AttrListLabelProvider
extends LabelProvider
implements ITableLabelProvider,
IColorProvider,
ITableFontProvider {
    private WorkbenchLabelProvider wbLabelProvider = new WorkbenchLabelProvider();
    private NXCSession session;
    private Font inheritedObjectFont;
    private Color inheritedElementColor = ThemeEngine.getForegroundColor((String)"List.DisabledItem");
    private Color conflictObjectForegroundColor = ThemeEngine.getForegroundColor((String)"List.Error");
    private Color conflictObjectBackgroundColor = ThemeEngine.getBackgroundColor((String)"List.Error");
    private AbstractObject parent;

    public AttrListLabelProvider(AbstractObject parent) {
        this.session = ConsoleSharedData.getSession();
        FontData fd = JFaceResources.getDefaultFont().getFontData()[0];
        fd.setStyle(2);
        this.inheritedObjectFont = new Font((Device)Display.getCurrent(), fd);
        this.parent = parent;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 3) {
            CustomAttribute attr = (CustomAttribute)((Map.Entry)element).getValue();
            if (attr.getSourceObject() == 0L || attr.isRedefined() || attr.isConflict()) {
                return null;
            }
            AbstractObject object = this.session.findObjectById(attr.getSourceObject());
            return object != null ? this.wbLabelProvider.getImage((Object)object) : null;
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (!(element instanceof Map.Entry)) {
            return null;
        }
        switch (columnIndex) {
            case 0: {
                Object key = ((Map.Entry)element).getKey();
                return key instanceof String ? (String)key : null;
            }
            case 1: {
                CustomAttribute attr = (CustomAttribute)((Map.Entry)element).getValue();
                return attr.getValue();
            }
            case 2: {
                CustomAttribute attr = (CustomAttribute)((Map.Entry)element).getValue();
                return (attr.getFlags() & 1L) > 0L ? "Yes" : "No";
            }
            case 3: {
                CustomAttribute attr = (CustomAttribute)((Map.Entry)element).getValue();
                if (attr.isConflict()) {
                    StringBuilder parentList = new StringBuilder();
                    HashSet<Long> objectSet = new HashSet<Long>();
                    AbstractObject[] abstractObjectArray = this.parent.getParentsAsArray();
                    int n = abstractObjectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        AbstractObject obj = abstractObjectArray[n2];
                        CustomAttribute ca = obj.getCustomAttribute((String)((Map.Entry)element).getKey());
                        if (ca != null && ca.isInheritable()) {
                            long id = 0L;
                            id = ca.getSourceObject() == 0L || ca.isRedefined() ? obj.getObjectId() : ca.getSourceObject();
                            if (!objectSet.contains(id)) {
                                objectSet.add(id);
                                if (parentList.length() == 0) {
                                    parentList.append("In conflict: ");
                                } else {
                                    parentList.append(", ");
                                }
                                AbstractObject object = this.session.findObjectById(id);
                                if (object != null) {
                                    parentList.append(object.getObjectName());
                                } else {
                                    parentList.append("[" + Long.toString(ca.getSourceObject()) + "]");
                                }
                            }
                        }
                        ++n2;
                    }
                    return parentList.toString();
                }
                if (attr.getSourceObject() == 0L || attr.isRedefined()) {
                    return null;
                }
                AbstractObject object = this.session.findObjectById(attr.getSourceObject());
                return object != null ? object.getObjectName() : "[" + Long.toString(attr.getSourceObject()) + "]";
            }
        }
        return null;
    }

    public Color getForeground(Object element) {
        CustomAttribute attr = (CustomAttribute)((Map.Entry)element).getValue();
        if (attr.isConflict()) {
            return this.conflictObjectForegroundColor;
        }
        return null;
    }

    public Color getBackground(Object element) {
        CustomAttribute attr = (CustomAttribute)((Map.Entry)element).getValue();
        if (attr.isConflict()) {
            return this.conflictObjectBackgroundColor;
        }
        if (attr.getSourceObject() != 0L && (attr.getFlags() & 2L) == 0L) {
            return this.inheritedElementColor;
        }
        return null;
    }

    public void dispose() {
        this.wbLabelProvider.dispose();
        this.inheritedObjectFont.dispose();
        super.dispose();
    }

    public Font getFont(Object element, int columnIndex) {
        CustomAttribute attr = (CustomAttribute)((Map.Entry)element).getValue();
        if (attr.getSourceObject() != 0L && (attr.getFlags() & 2L) == 0L) {
            return this.inheritedObjectFont;
        }
        return null;
    }
}

