/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.topology.views.helpers;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.netxms.base.MacAddress;
import org.netxms.client.NXCSession;
import org.netxms.client.topology.RadioInterface;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class RadioInterfaceComparator
extends ViewerComparator {
    private NXCSession session = ConsoleSharedData.getSession();

    public int compare(Viewer viewer, Object e1, Object e2) {
        int result;
        RadioInterface rif1 = (RadioInterface)e1;
        RadioInterface rif2 = (RadioInterface)e2;
        switch ((Integer)((SortableTableViewer)viewer).getTable().getSortColumn().getData("ID")) {
            case 1: {
                result = rif1.getAccessPoint().getMacAddress().compareTo(rif2.getAccessPoint().getMacAddress());
                break;
            }
            case 3: {
                result = rif1.getAccessPoint().getModel().compareToIgnoreCase(rif2.getAccessPoint().getModel());
                break;
            }
            case 0: {
                result = rif1.getAccessPoint().getObjectName().compareToIgnoreCase(rif2.getAccessPoint().getObjectName());
                break;
            }
            case 4: {
                result = rif1.getAccessPoint().getSerialNumber().compareToIgnoreCase(rif2.getAccessPoint().getSerialNumber());
                break;
            }
            case 2: {
                result = rif1.getAccessPoint().getVendor().compareToIgnoreCase(rif2.getAccessPoint().getVendor());
                break;
            }
            case 9: {
                result = rif1.getChannel() - rif2.getChannel();
                break;
            }
            case 5: {
                result = rif1.getIndex() - rif2.getIndex();
                break;
            }
            case 7: {
                result = rif1.getMacAddress().compareTo(rif2.getMacAddress());
                break;
            }
            case 8: {
                result = this.getVendorByMAC(rif1.getMacAddress()).compareToIgnoreCase(this.getVendorByMAC(rif2.getMacAddress()));
                break;
            }
            case 6: {
                result = rif1.getName().compareToIgnoreCase(rif2.getName());
                break;
            }
            case 10: {
                result = rif1.getPowerDBm() - rif2.getPowerDBm();
                break;
            }
            case 11: {
                result = rif1.getPowerMW() - rif2.getPowerMW();
                break;
            }
            default: {
                result = 0;
            }
        }
        return ((SortableTableViewer)viewer).getTable().getSortDirection() == 128 ? result : -result;
    }

    private String getVendorByMAC(MacAddress macAddr) {
        String vendor = this.session.getVendorByMac(macAddr, null);
        return vendor != null ? vendor : "";
    }
}

