/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.propertypages;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.dashboard.widgets.TitleConfigurator;
import org.netxms.ui.eclipse.dashboard.widgets.internal.FileMonitorConfig;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledSpinner;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class FileMonitor
extends PropertyPage {
    private FileMonitorConfig config;
    private ObjectSelector objectSelector;
    private LabeledText fileName;
    private LabeledText filter;
    private LabeledSpinner historyLimit;
    private Combo syntaxHighlighter;
    private TitleConfigurator title;

    protected Control createContents(Composite parent) {
        this.config = (FileMonitorConfig)this.getElement().getAdapter(FileMonitorConfig.class);
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.title = new TitleConfigurator(dialogArea, this.config);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.title.setLayoutData(gd);
        this.objectSelector = new ObjectSelector(dialogArea, 0, true, true);
        this.objectSelector.setLabel("Node");
        this.objectSelector.setObjectClass(Node.class);
        this.objectSelector.setObjectId(this.config.getObjectId());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.objectSelector.setLayoutData((Object)gd);
        this.fileName = new LabeledText(dialogArea, 0);
        this.fileName.setLabel("File name");
        this.fileName.setText(this.config.getFileName());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.fileName.setLayoutData((Object)gd);
        this.filter = new LabeledText(dialogArea, 0);
        this.filter.setLabel("Line filter (regular expression)");
        this.filter.setText(this.config.getFilter());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.filter.setLayoutData((Object)gd);
        this.historyLimit = new LabeledSpinner(dialogArea, 0);
        this.historyLimit.setLabel("History limit");
        this.historyLimit.setRange(0, 99999999);
        this.historyLimit.setSelection(this.config.getHistoryLimit());
        this.syntaxHighlighter = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)2056, (String)"Highlighter", (Object)"WidgetHelper::default_layout_data");
        this.syntaxHighlighter.add("None");
        int index = this.syntaxHighlighter.indexOf(this.config.getSyntaxHighlighter());
        this.syntaxHighlighter.select(index >= 0 ? index : 0);
        return dialogArea;
    }

    public boolean performOk() {
        this.title.updateConfiguration(this.config);
        this.config.setObjectId(this.objectSelector.getObjectId());
        this.config.setFileName(this.fileName.getText().trim());
        this.config.setFilter(this.filter.getText());
        this.config.setHistoryLimit(this.historyLimit.getSelection());
        this.config.setSyntaxHighlighter(this.syntaxHighlighter.getText());
        return true;
    }
}

