/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.views;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.Rack;
import org.netxms.ui.eclipse.objectview.Activator;
import org.netxms.ui.eclipse.objectview.widgets.PhysicalLinkWidget;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class PhysicalLinkView
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.objectview.views.PhysicalLinkView";
    private PhysicalLinkWidget linkWidget;
    private long objectId;
    private long patchPanelId;
    private boolean initShowFilter = true;
    private IDialogSettings settings;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String[] params = site.getSecondaryId().split("&");
        this.objectId = Long.parseLong(params[0]);
        this.patchPanelId = Long.parseLong(params[1]);
        this.settings = Activator.getDefault().getDialogSettings();
        this.initShowFilter = PhysicalLinkView.safeCast(this.settings.get("PhysicalLinkView"), this.settings.getBoolean("PhysicalLinkView"), this.initShowFilter);
        if (this.objectId != 0L) {
            NXCSession session = ConsoleSharedData.getSession();
            Rack rack = (Rack)session.findObjectById(this.objectId);
            this.setPartName(String.format("Physical link for %s at %s", rack.getPassiveElement(this.patchPanelId).toString(), rack.getObjectName()));
        }
    }

    private static boolean safeCast(String s, boolean b, boolean defval) {
        return s != null ? b : defval;
    }

    public void createPartControl(Composite parent) {
        FormLayout formLayout = new FormLayout();
        parent.setLayout((Layout)formLayout);
        this.linkWidget = new PhysicalLinkWidget(this, parent, 0, this.objectId, this.patchPanelId, this.initShowFilter, null);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.linkWidget.setLayoutData(fd);
        this.linkWidget.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                PhysicalLinkView.this.settings.put("PhysicalLinkView", PhysicalLinkView.this.linkWidget.isFilterEnabled());
            }
        });
        this.linkWidget.contributeToActionBars();
        this.activateContext();
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext("org.netxms.ui.eclipse.objectview.context.PhysicalLinkView");
        }
    }

    public void setFocus() {
        this.linkWidget.setFocus();
    }
}

